/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.FeedbackValueType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAuthEventFeedbackRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, UpdateAuthEventFeedbackRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAuthEventFeedbackRequest.getter(UpdateAuthEventFeedbackRequest::userPoolId)).setter(UpdateAuthEventFeedbackRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAuthEventFeedbackRequest.getter(UpdateAuthEventFeedbackRequest::username)).setter(UpdateAuthEventFeedbackRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAuthEventFeedbackRequest.getter(UpdateAuthEventFeedbackRequest::eventId)).setter(UpdateAuthEventFeedbackRequest.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()}).build();
    private static final SdkField<String> FEEDBACK_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAuthEventFeedbackRequest.getter(UpdateAuthEventFeedbackRequest::feedbackToken)).setter(UpdateAuthEventFeedbackRequest.setter(Builder::feedbackToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackToken").build()}).build();
    private static final SdkField<String> FEEDBACK_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAuthEventFeedbackRequest.getter(UpdateAuthEventFeedbackRequest::feedbackValueAsString)).setter(UpdateAuthEventFeedbackRequest.setter(Builder::feedbackValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, USERNAME_FIELD, EVENT_ID_FIELD, FEEDBACK_TOKEN_FIELD, FEEDBACK_VALUE_FIELD));
    private final String userPoolId;
    private final String username;
    private final String eventId;
    private final String feedbackToken;
    private final String feedbackValue;

    private UpdateAuthEventFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.username = builder.username;
        this.eventId = builder.eventId;
        this.feedbackToken = builder.feedbackToken;
        this.feedbackValue = builder.feedbackValue;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String username() {
        return this.username;
    }

    public String eventId() {
        return this.eventId;
    }

    public String feedbackToken() {
        return this.feedbackToken;
    }

    public FeedbackValueType feedbackValue() {
        return FeedbackValueType.fromValue(this.feedbackValue);
    }

    public String feedbackValueAsString() {
        return this.feedbackValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackValueAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAuthEventFeedbackRequest)) {
            return false;
        }
        UpdateAuthEventFeedbackRequest other = (UpdateAuthEventFeedbackRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.feedbackToken(), other.feedbackToken()) && Objects.equals(this.feedbackValueAsString(), other.feedbackValueAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateAuthEventFeedbackRequest").add("UserPoolId", (Object)this.userPoolId()).add("Username", (Object)(this.username() == null ? null : "*** Sensitive Data Redacted ***")).add("EventId", (Object)this.eventId()).add("FeedbackToken", (Object)(this.feedbackToken() == null ? null : "*** Sensitive Data Redacted ***")).add("FeedbackValue", (Object)this.feedbackValueAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "EventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "FeedbackToken": {
                return Optional.ofNullable(clazz.cast(this.feedbackToken()));
            }
            case "FeedbackValue": {
                return Optional.ofNullable(clazz.cast(this.feedbackValueAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAuthEventFeedbackRequest, T> g) {
        return obj -> g.apply((UpdateAuthEventFeedbackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private String username;
        private String eventId;
        private String feedbackToken;
        private String feedbackValue;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAuthEventFeedbackRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.username(model.username);
            this.eventId(model.eventId);
            this.feedbackToken(model.feedbackToken);
            this.feedbackValue(model.feedbackValue);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getEventId() {
            return this.eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getFeedbackToken() {
            return this.feedbackToken;
        }

        @Override
        public final Builder feedbackToken(String feedbackToken) {
            this.feedbackToken = feedbackToken;
            return this;
        }

        public final void setFeedbackToken(String feedbackToken) {
            this.feedbackToken = feedbackToken;
        }

        public final String getFeedbackValueAsString() {
            return this.feedbackValue;
        }

        @Override
        public final Builder feedbackValue(String feedbackValue) {
            this.feedbackValue = feedbackValue;
            return this;
        }

        @Override
        public final Builder feedbackValue(FeedbackValueType feedbackValue) {
            this.feedbackValue(feedbackValue.toString());
            return this;
        }

        public final void setFeedbackValue(String feedbackValue) {
            this.feedbackValue = feedbackValue;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAuthEventFeedbackRequest build() {
            return new UpdateAuthEventFeedbackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAuthEventFeedbackRequest> {
        public Builder userPoolId(String var1);

        public Builder username(String var1);

        public Builder eventId(String var1);

        public Builder feedbackToken(String var1);

        public Builder feedbackValue(String var1);

        public Builder feedbackValue(FeedbackValueType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

