/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The UpdateUserPoolDomain response output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserPoolDomainResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<UpdateUserPoolDomainResponse.Builder, UpdateUserPoolDomainResponse> {
    private static final SdkField<Integer> MANAGED_LOGIN_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ManagedLoginVersion").getter(getter(UpdateUserPoolDomainResponse::managedLoginVersion))
            .setter(setter(Builder::managedLoginVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedLoginVersion").build())
            .build();

    private static final SdkField<String> CLOUD_FRONT_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudFrontDomain").getter(getter(UpdateUserPoolDomainResponse::cloudFrontDomain))
            .setter(setter(Builder::cloudFrontDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFrontDomain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_LOGIN_VERSION_FIELD,
            CLOUD_FRONT_DOMAIN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer managedLoginVersion;

    private final String cloudFrontDomain;

    private UpdateUserPoolDomainResponse(BuilderImpl builder) {
        super(builder);
        this.managedLoginVersion = builder.managedLoginVersion;
        this.cloudFrontDomain = builder.cloudFrontDomain;
    }

    /**
     * <p>
     * A version number that indicates the state of managed login for your domain. Version <code>1</code> is hosted UI
     * (classic). Version <code>2</code> is the newer managed login with the branding editor. For more information, see
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html">Managed
     * login</a>.
     * </p>
     * 
     * @return A version number that indicates the state of managed login for your domain. Version <code>1</code> is
     *         hosted UI (classic). Version <code>2</code> is the newer managed login with the branding editor. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html"
     *         >Managed login</a>.
     */
    public final Integer managedLoginVersion() {
        return managedLoginVersion;
    }

    /**
     * <p>
     * The fully-qualified domain name (FQDN) of the Amazon CloudFront distribution that hosts your managed login or
     * classic hosted UI pages. You domain-name authority must have an alias record that points requests for your custom
     * domain to this FQDN. Amazon Cognito returns this value if you set a custom domain with
     * <code>CustomDomainConfig</code>. If you set an Amazon Cognito prefix domain, this operation returns a blank
     * response.
     * </p>
     * 
     * @return The fully-qualified domain name (FQDN) of the Amazon CloudFront distribution that hosts your managed
     *         login or classic hosted UI pages. You domain-name authority must have an alias record that points
     *         requests for your custom domain to this FQDN. Amazon Cognito returns this value if you set a custom
     *         domain with <code>CustomDomainConfig</code>. If you set an Amazon Cognito prefix domain, this operation
     *         returns a blank response.
     */
    public final String cloudFrontDomain() {
        return cloudFrontDomain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(managedLoginVersion());
        hashCode = 31 * hashCode + Objects.hashCode(cloudFrontDomain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserPoolDomainResponse)) {
            return false;
        }
        UpdateUserPoolDomainResponse other = (UpdateUserPoolDomainResponse) obj;
        return Objects.equals(managedLoginVersion(), other.managedLoginVersion())
                && Objects.equals(cloudFrontDomain(), other.cloudFrontDomain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateUserPoolDomainResponse").add("ManagedLoginVersion", managedLoginVersion())
                .add("CloudFrontDomain", cloudFrontDomain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManagedLoginVersion":
            return Optional.ofNullable(clazz.cast(managedLoginVersion()));
        case "CloudFrontDomain":
            return Optional.ofNullable(clazz.cast(cloudFrontDomain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ManagedLoginVersion", MANAGED_LOGIN_VERSION_FIELD);
        map.put("CloudFrontDomain", CLOUD_FRONT_DOMAIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserPoolDomainResponse, T> g) {
        return obj -> g.apply((UpdateUserPoolDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateUserPoolDomainResponse> {
        /**
         * <p>
         * A version number that indicates the state of managed login for your domain. Version <code>1</code> is hosted
         * UI (classic). Version <code>2</code> is the newer managed login with the branding editor. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html"
         * >Managed login</a>.
         * </p>
         * 
         * @param managedLoginVersion
         *        A version number that indicates the state of managed login for your domain. Version <code>1</code> is
         *        hosted UI (classic). Version <code>2</code> is the newer managed login with the branding editor. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html"
         *        >Managed login</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedLoginVersion(Integer managedLoginVersion);

        /**
         * <p>
         * The fully-qualified domain name (FQDN) of the Amazon CloudFront distribution that hosts your managed login or
         * classic hosted UI pages. You domain-name authority must have an alias record that points requests for your
         * custom domain to this FQDN. Amazon Cognito returns this value if you set a custom domain with
         * <code>CustomDomainConfig</code>. If you set an Amazon Cognito prefix domain, this operation returns a blank
         * response.
         * </p>
         * 
         * @param cloudFrontDomain
         *        The fully-qualified domain name (FQDN) of the Amazon CloudFront distribution that hosts your managed
         *        login or classic hosted UI pages. You domain-name authority must have an alias record that points
         *        requests for your custom domain to this FQDN. Amazon Cognito returns this value if you set a custom
         *        domain with <code>CustomDomainConfig</code>. If you set an Amazon Cognito prefix domain, this
         *        operation returns a blank response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFrontDomain(String cloudFrontDomain);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private Integer managedLoginVersion;

        private String cloudFrontDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserPoolDomainResponse model) {
            super(model);
            managedLoginVersion(model.managedLoginVersion);
            cloudFrontDomain(model.cloudFrontDomain);
        }

        public final Integer getManagedLoginVersion() {
            return managedLoginVersion;
        }

        public final void setManagedLoginVersion(Integer managedLoginVersion) {
            this.managedLoginVersion = managedLoginVersion;
        }

        @Override
        public final Builder managedLoginVersion(Integer managedLoginVersion) {
            this.managedLoginVersion = managedLoginVersion;
            return this;
        }

        public final String getCloudFrontDomain() {
            return cloudFrontDomain;
        }

        public final void setCloudFrontDomain(String cloudFrontDomain) {
            this.cloudFrontDomain = cloudFrontDomain;
        }

        @Override
        public final Builder cloudFrontDomain(String cloudFrontDomain) {
            this.cloudFrontDomain = cloudFrontDomain;
            return this;
        }

        @Override
        public UpdateUserPoolDomainResponse build() {
            return new UpdateUserPoolDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
