/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeManagedLoginBrandingByClientRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<DescribeManagedLoginBrandingByClientRequest.Builder, DescribeManagedLoginBrandingByClientRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(DescribeManagedLoginBrandingByClientRequest::userPoolId))
            .setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientId").getter(getter(DescribeManagedLoginBrandingByClientRequest::clientId))
            .setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<Boolean> RETURN_MERGED_RESOURCES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReturnMergedResources")
            .getter(getter(DescribeManagedLoginBrandingByClientRequest::returnMergedResources))
            .setter(setter(Builder::returnMergedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnMergedResources").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            CLIENT_ID_FIELD, RETURN_MERGED_RESOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String userPoolId;

    private final String clientId;

    private final Boolean returnMergedResources;

    private DescribeManagedLoginBrandingByClientRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.clientId = builder.clientId;
        this.returnMergedResources = builder.returnMergedResources;
    }

    /**
     * <p>
     * The ID of the user pool that contains the app client where you want more information about the managed login
     * branding style.
     * </p>
     * 
     * @return The ID of the user pool that contains the app client where you want more information about the managed
     *         login branding style.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The app client that's assigned to the branding style that you want more information about.
     * </p>
     * 
     * @return The app client that's assigned to the branding style that you want more information about.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * When <code>true</code>, returns values for branding options that are unchanged from Amazon Cognito defaults. When
     * <code>false</code> or when you omit this parameter, returns only values that you customized in your branding
     * style.
     * </p>
     * 
     * @return When <code>true</code>, returns values for branding options that are unchanged from Amazon Cognito
     *         defaults. When <code>false</code> or when you omit this parameter, returns only values that you
     *         customized in your branding style.
     */
    public final Boolean returnMergedResources() {
        return returnMergedResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(returnMergedResources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeManagedLoginBrandingByClientRequest)) {
            return false;
        }
        DescribeManagedLoginBrandingByClientRequest other = (DescribeManagedLoginBrandingByClientRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(clientId(), other.clientId())
                && Objects.equals(returnMergedResources(), other.returnMergedResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeManagedLoginBrandingByClientRequest").add("UserPoolId", userPoolId())
                .add("ClientId", clientId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ReturnMergedResources", returnMergedResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "ReturnMergedResources":
            return Optional.ofNullable(clazz.cast(returnMergedResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserPoolId", USER_POOL_ID_FIELD);
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("ReturnMergedResources", RETURN_MERGED_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeManagedLoginBrandingByClientRequest, T> g) {
        return obj -> g.apply((DescribeManagedLoginBrandingByClientRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeManagedLoginBrandingByClientRequest> {
        /**
         * <p>
         * The ID of the user pool that contains the app client where you want more information about the managed login
         * branding style.
         * </p>
         * 
         * @param userPoolId
         *        The ID of the user pool that contains the app client where you want more information about the managed
         *        login branding style.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The app client that's assigned to the branding style that you want more information about.
         * </p>
         * 
         * @param clientId
         *        The app client that's assigned to the branding style that you want more information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * When <code>true</code>, returns values for branding options that are unchanged from Amazon Cognito defaults.
         * When <code>false</code> or when you omit this parameter, returns only values that you customized in your
         * branding style.
         * </p>
         * 
         * @param returnMergedResources
         *        When <code>true</code>, returns values for branding options that are unchanged from Amazon Cognito
         *        defaults. When <code>false</code> or when you omit this parameter, returns only values that you
         *        customized in your branding style.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnMergedResources(Boolean returnMergedResources);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private String clientId;

        private Boolean returnMergedResources;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeManagedLoginBrandingByClientRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            clientId(model.clientId);
            returnMergedResources(model.returnMergedResources);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final Boolean getReturnMergedResources() {
            return returnMergedResources;
        }

        public final void setReturnMergedResources(Boolean returnMergedResources) {
            this.returnMergedResources = returnMergedResources;
        }

        @Override
        public final Builder returnMergedResources(Boolean returnMergedResources) {
            this.returnMergedResources = returnMergedResources;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeManagedLoginBrandingByClientRequest build() {
            return new DescribeManagedLoginBrandingByClientRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
