/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LogConfigurationListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LogConfigurationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogDeliveryConfigurationType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogDeliveryConfigurationType> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(LogDeliveryConfigurationType.getter(LogDeliveryConfigurationType::userPoolId)).setter(LogDeliveryConfigurationType.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<List<LogConfigurationType>> LOG_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogConfigurations").getter(LogDeliveryConfigurationType.getter(LogDeliveryConfigurationType::logConfigurations)).setter(LogDeliveryConfigurationType.setter(Builder::logConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, LOG_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LogDeliveryConfigurationType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String userPoolId;
    private final List<LogConfigurationType> logConfigurations;

    private LogDeliveryConfigurationType(BuilderImpl builder) {
        this.userPoolId = builder.userPoolId;
        this.logConfigurations = builder.logConfigurations;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final boolean hasLogConfigurations() {
        return this.logConfigurations != null && !(this.logConfigurations instanceof SdkAutoConstructList);
    }

    public final List<LogConfigurationType> logConfigurations() {
        return this.logConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogConfigurations() ? this.logConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogDeliveryConfigurationType)) {
            return false;
        }
        LogDeliveryConfigurationType other = (LogDeliveryConfigurationType)obj;
        return Objects.equals(this.userPoolId(), other.userPoolId()) && this.hasLogConfigurations() == other.hasLogConfigurations() && Objects.equals(this.logConfigurations(), other.logConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"LogDeliveryConfigurationType").add("UserPoolId", (Object)this.userPoolId()).add("LogConfigurations", this.hasLogConfigurations() ? this.logConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "LogConfigurations": {
                return Optional.ofNullable(clazz.cast(this.logConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UserPoolId", USER_POOL_ID_FIELD);
        map.put("LogConfigurations", LOG_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogDeliveryConfigurationType, T> g) {
        return obj -> g.apply((LogDeliveryConfigurationType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userPoolId;
        private List<LogConfigurationType> logConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LogDeliveryConfigurationType model) {
            this.userPoolId(model.userPoolId);
            this.logConfigurations(model.logConfigurations);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final List<LogConfigurationType.Builder> getLogConfigurations() {
            List<LogConfigurationType.Builder> result = LogConfigurationListTypeCopier.copyToBuilder(this.logConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogConfigurations(Collection<LogConfigurationType.BuilderImpl> logConfigurations) {
            this.logConfigurations = LogConfigurationListTypeCopier.copyFromBuilder(logConfigurations);
        }

        @Override
        public final Builder logConfigurations(Collection<LogConfigurationType> logConfigurations) {
            this.logConfigurations = LogConfigurationListTypeCopier.copy(logConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logConfigurations(LogConfigurationType ... logConfigurations) {
            this.logConfigurations(Arrays.asList(logConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logConfigurations(Consumer<LogConfigurationType.Builder> ... logConfigurations) {
            this.logConfigurations(Stream.of(logConfigurations).map(c -> (LogConfigurationType)((LogConfigurationType.Builder)LogConfigurationType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LogDeliveryConfigurationType build() {
            return new LogDeliveryConfigurationType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogDeliveryConfigurationType> {
        public Builder userPoolId(String var1);

        public Builder logConfigurations(Collection<LogConfigurationType> var1);

        public Builder logConfigurations(LogConfigurationType ... var1);

        public Builder logConfigurations(Consumer<LogConfigurationType.Builder> ... var1);
    }
}

