/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CustomDomainConfigType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserPoolDomainRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, UpdateUserPoolDomainRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateUserPoolDomainRequest.getter(UpdateUserPoolDomainRequest::domain)).setter(UpdateUserPoolDomainRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateUserPoolDomainRequest.getter(UpdateUserPoolDomainRequest::userPoolId)).setter(UpdateUserPoolDomainRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<CustomDomainConfigType> CUSTOM_DOMAIN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateUserPoolDomainRequest.getter(UpdateUserPoolDomainRequest::customDomainConfig)).setter(UpdateUserPoolDomainRequest.setter(Builder::customDomainConfig)).constructor(CustomDomainConfigType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomainConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, USER_POOL_ID_FIELD, CUSTOM_DOMAIN_CONFIG_FIELD));
    private final String domain;
    private final String userPoolId;
    private final CustomDomainConfigType customDomainConfig;

    private UpdateUserPoolDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.userPoolId = builder.userPoolId;
        this.customDomainConfig = builder.customDomainConfig;
    }

    public String domain() {
        return this.domain;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public CustomDomainConfigType customDomainConfig() {
        return this.customDomainConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomainConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserPoolDomainRequest)) {
            return false;
        }
        UpdateUserPoolDomainRequest other = (UpdateUserPoolDomainRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.customDomainConfig(), other.customDomainConfig());
    }

    public String toString() {
        return ToString.builder((String)"UpdateUserPoolDomainRequest").add("Domain", (Object)this.domain()).add("UserPoolId", (Object)this.userPoolId()).add("CustomDomainConfig", (Object)this.customDomainConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "CustomDomainConfig": {
                return Optional.ofNullable(clazz.cast(this.customDomainConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserPoolDomainRequest, T> g) {
        return obj -> g.apply((UpdateUserPoolDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String domain;
        private String userPoolId;
        private CustomDomainConfigType customDomainConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserPoolDomainRequest model) {
            super(model);
            this.domain(model.domain);
            this.userPoolId(model.userPoolId);
            this.customDomainConfig(model.customDomainConfig);
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final CustomDomainConfigType.Builder getCustomDomainConfig() {
            return this.customDomainConfig != null ? this.customDomainConfig.toBuilder() : null;
        }

        @Override
        public final Builder customDomainConfig(CustomDomainConfigType customDomainConfig) {
            this.customDomainConfig = customDomainConfig;
            return this;
        }

        public final void setCustomDomainConfig(CustomDomainConfigType.BuilderImpl customDomainConfig) {
            this.customDomainConfig = customDomainConfig != null ? customDomainConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserPoolDomainRequest build() {
            return new UpdateUserPoolDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUserPoolDomainRequest> {
        public Builder domain(String var1);

        public Builder userPoolId(String var1);

        public Builder customDomainConfig(CustomDomainConfigType var1);

        default public Builder customDomainConfig(Consumer<CustomDomainConfigType.Builder> customDomainConfig) {
            return this.customDomainConfig((CustomDomainConfigType)((CustomDomainConfigType.Builder)CustomDomainConfigType.builder().applyMutation(customDomainConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

