/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeMappingTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.IdpIdentifiersListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ProviderDetailsTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIdentityProviderRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, CreateIdentityProviderRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(CreateIdentityProviderRequest.getter(CreateIdentityProviderRequest::userPoolId)).setter(CreateIdentityProviderRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProviderName").getter(CreateIdentityProviderRequest.getter(CreateIdentityProviderRequest::providerName)).setter(CreateIdentityProviderRequest.setter(Builder::providerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderName").build()}).build();
    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProviderType").getter(CreateIdentityProviderRequest.getter(CreateIdentityProviderRequest::providerTypeAsString)).setter(CreateIdentityProviderRequest.setter(Builder::providerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()}).build();
    private static final SdkField<Map<String, String>> PROVIDER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ProviderDetails").getter(CreateIdentityProviderRequest.getter(CreateIdentityProviderRequest::providerDetails)).setter(CreateIdentityProviderRequest.setter(Builder::providerDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderDetails").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTE_MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AttributeMapping").getter(CreateIdentityProviderRequest.getter(CreateIdentityProviderRequest::attributeMapping)).setter(CreateIdentityProviderRequest.setter(Builder::attributeMapping)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeMapping").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IDP_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IdpIdentifiers").getter(CreateIdentityProviderRequest.getter(CreateIdentityProviderRequest::idpIdentifiers)).setter(CreateIdentityProviderRequest.setter(Builder::idpIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdpIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, PROVIDER_NAME_FIELD, PROVIDER_TYPE_FIELD, PROVIDER_DETAILS_FIELD, ATTRIBUTE_MAPPING_FIELD, IDP_IDENTIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateIdentityProviderRequest.memberNameToFieldInitializer();
    private final String userPoolId;
    private final String providerName;
    private final String providerType;
    private final Map<String, String> providerDetails;
    private final Map<String, String> attributeMapping;
    private final List<String> idpIdentifiers;

    private CreateIdentityProviderRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.providerName = builder.providerName;
        this.providerType = builder.providerType;
        this.providerDetails = builder.providerDetails;
        this.attributeMapping = builder.attributeMapping;
        this.idpIdentifiers = builder.idpIdentifiers;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final String providerName() {
        return this.providerName;
    }

    public final IdentityProviderTypeType providerType() {
        return IdentityProviderTypeType.fromValue(this.providerType);
    }

    public final String providerTypeAsString() {
        return this.providerType;
    }

    public final boolean hasProviderDetails() {
        return this.providerDetails != null && !(this.providerDetails instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> providerDetails() {
        return this.providerDetails;
    }

    public final boolean hasAttributeMapping() {
        return this.attributeMapping != null && !(this.attributeMapping instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributeMapping() {
        return this.attributeMapping;
    }

    public final boolean hasIdpIdentifiers() {
        return this.idpIdentifiers != null && !(this.idpIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> idpIdentifiers() {
        return this.idpIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProviderDetails() ? this.providerDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeMapping() ? this.attributeMapping() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdpIdentifiers() ? this.idpIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIdentityProviderRequest)) {
            return false;
        }
        CreateIdentityProviderRequest other = (CreateIdentityProviderRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.providerName(), other.providerName()) && Objects.equals(this.providerTypeAsString(), other.providerTypeAsString()) && this.hasProviderDetails() == other.hasProviderDetails() && Objects.equals(this.providerDetails(), other.providerDetails()) && this.hasAttributeMapping() == other.hasAttributeMapping() && Objects.equals(this.attributeMapping(), other.attributeMapping()) && this.hasIdpIdentifiers() == other.hasIdpIdentifiers() && Objects.equals(this.idpIdentifiers(), other.idpIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIdentityProviderRequest").add("UserPoolId", (Object)this.userPoolId()).add("ProviderName", (Object)this.providerName()).add("ProviderType", (Object)this.providerTypeAsString()).add("ProviderDetails", this.hasProviderDetails() ? this.providerDetails() : null).add("AttributeMapping", this.hasAttributeMapping() ? this.attributeMapping() : null).add("IdpIdentifiers", this.hasIdpIdentifiers() ? this.idpIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "ProviderName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
            case "ProviderType": {
                return Optional.ofNullable(clazz.cast(this.providerTypeAsString()));
            }
            case "ProviderDetails": {
                return Optional.ofNullable(clazz.cast(this.providerDetails()));
            }
            case "AttributeMapping": {
                return Optional.ofNullable(clazz.cast(this.attributeMapping()));
            }
            case "IdpIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.idpIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UserPoolId", USER_POOL_ID_FIELD);
        map.put("ProviderName", PROVIDER_NAME_FIELD);
        map.put("ProviderType", PROVIDER_TYPE_FIELD);
        map.put("ProviderDetails", PROVIDER_DETAILS_FIELD);
        map.put("AttributeMapping", ATTRIBUTE_MAPPING_FIELD);
        map.put("IdpIdentifiers", IDP_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIdentityProviderRequest, T> g) {
        return obj -> g.apply((CreateIdentityProviderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private String providerName;
        private String providerType;
        private Map<String, String> providerDetails = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> attributeMapping = DefaultSdkAutoConstructMap.getInstance();
        private List<String> idpIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIdentityProviderRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.providerName(model.providerName);
            this.providerType(model.providerType);
            this.providerDetails(model.providerDetails);
            this.attributeMapping(model.attributeMapping);
            this.idpIdentifiers(model.idpIdentifiers);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final String getProviderType() {
            return this.providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(IdentityProviderTypeType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final Map<String, String> getProviderDetails() {
            if (this.providerDetails instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.providerDetails;
        }

        public final void setProviderDetails(Map<String, String> providerDetails) {
            this.providerDetails = ProviderDetailsTypeCopier.copy(providerDetails);
        }

        @Override
        public final Builder providerDetails(Map<String, String> providerDetails) {
            this.providerDetails = ProviderDetailsTypeCopier.copy(providerDetails);
            return this;
        }

        public final Map<String, String> getAttributeMapping() {
            if (this.attributeMapping instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributeMapping;
        }

        public final void setAttributeMapping(Map<String, String> attributeMapping) {
            this.attributeMapping = AttributeMappingTypeCopier.copy(attributeMapping);
        }

        @Override
        public final Builder attributeMapping(Map<String, String> attributeMapping) {
            this.attributeMapping = AttributeMappingTypeCopier.copy(attributeMapping);
            return this;
        }

        public final Collection<String> getIdpIdentifiers() {
            if (this.idpIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.idpIdentifiers;
        }

        public final void setIdpIdentifiers(Collection<String> idpIdentifiers) {
            this.idpIdentifiers = IdpIdentifiersListTypeCopier.copy(idpIdentifiers);
        }

        @Override
        public final Builder idpIdentifiers(Collection<String> idpIdentifiers) {
            this.idpIdentifiers = IdpIdentifiersListTypeCopier.copy(idpIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idpIdentifiers(String ... idpIdentifiers) {
            this.idpIdentifiers(Arrays.asList(idpIdentifiers));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIdentityProviderRequest build() {
            return new CreateIdentityProviderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIdentityProviderRequest> {
        public Builder userPoolId(String var1);

        public Builder providerName(String var1);

        public Builder providerType(String var1);

        public Builder providerType(IdentityProviderTypeType var1);

        public Builder providerDetails(Map<String, String> var1);

        public Builder attributeMapping(Map<String, String> var1);

        public Builder idpIdentifiers(Collection<String> var1);

        public Builder idpIdentifiers(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

