/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserPoolDomainResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, UpdateUserPoolDomainResponse> {
    private static final SdkField<Integer> MANAGED_LOGIN_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ManagedLoginVersion").getter(UpdateUserPoolDomainResponse.getter(UpdateUserPoolDomainResponse::managedLoginVersion)).setter(UpdateUserPoolDomainResponse.setter(Builder::managedLoginVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedLoginVersion").build()}).build();
    private static final SdkField<String> CLOUD_FRONT_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudFrontDomain").getter(UpdateUserPoolDomainResponse.getter(UpdateUserPoolDomainResponse::cloudFrontDomain)).setter(UpdateUserPoolDomainResponse.setter(Builder::cloudFrontDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFrontDomain").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_LOGIN_VERSION_FIELD, CLOUD_FRONT_DOMAIN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateUserPoolDomainResponse.memberNameToFieldInitializer();
    private final Integer managedLoginVersion;
    private final String cloudFrontDomain;

    private UpdateUserPoolDomainResponse(BuilderImpl builder) {
        super(builder);
        this.managedLoginVersion = builder.managedLoginVersion;
        this.cloudFrontDomain = builder.cloudFrontDomain;
    }

    public final Integer managedLoginVersion() {
        return this.managedLoginVersion;
    }

    public final String cloudFrontDomain() {
        return this.cloudFrontDomain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.managedLoginVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFrontDomain());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserPoolDomainResponse)) {
            return false;
        }
        UpdateUserPoolDomainResponse other = (UpdateUserPoolDomainResponse)((Object)obj);
        return Objects.equals(this.managedLoginVersion(), other.managedLoginVersion()) && Objects.equals(this.cloudFrontDomain(), other.cloudFrontDomain());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateUserPoolDomainResponse").add("ManagedLoginVersion", (Object)this.managedLoginVersion()).add("CloudFrontDomain", (Object)this.cloudFrontDomain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManagedLoginVersion": {
                return Optional.ofNullable(clazz.cast(this.managedLoginVersion()));
            }
            case "CloudFrontDomain": {
                return Optional.ofNullable(clazz.cast(this.cloudFrontDomain()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ManagedLoginVersion", MANAGED_LOGIN_VERSION_FIELD);
        map.put("CloudFrontDomain", CLOUD_FRONT_DOMAIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserPoolDomainResponse, T> g) {
        return obj -> g.apply((UpdateUserPoolDomainResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private Integer managedLoginVersion;
        private String cloudFrontDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserPoolDomainResponse model) {
            super(model);
            this.managedLoginVersion(model.managedLoginVersion);
            this.cloudFrontDomain(model.cloudFrontDomain);
        }

        public final Integer getManagedLoginVersion() {
            return this.managedLoginVersion;
        }

        public final void setManagedLoginVersion(Integer managedLoginVersion) {
            this.managedLoginVersion = managedLoginVersion;
        }

        @Override
        public final Builder managedLoginVersion(Integer managedLoginVersion) {
            this.managedLoginVersion = managedLoginVersion;
            return this;
        }

        public final String getCloudFrontDomain() {
            return this.cloudFrontDomain;
        }

        public final void setCloudFrontDomain(String cloudFrontDomain) {
            this.cloudFrontDomain = cloudFrontDomain;
        }

        @Override
        public final Builder cloudFrontDomain(String cloudFrontDomain) {
            this.cloudFrontDomain = cloudFrontDomain;
            return this;
        }

        @Override
        public UpdateUserPoolDomainResponse build() {
            return new UpdateUserPoolDomainResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUserPoolDomainResponse> {
        public Builder managedLoginVersion(Integer var1);

        public Builder cloudFrontDomain(String var1);
    }
}

