/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SearchedAttributeNamesListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUsersRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, ListUsersRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(ListUsersRequest.getter(ListUsersRequest::userPoolId)).setter(ListUsersRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTES_TO_GET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributesToGet").getter(ListUsersRequest.getter(ListUsersRequest::attributesToGet)).setter(ListUsersRequest.setter(Builder::attributesToGet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesToGet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(ListUsersRequest.getter(ListUsersRequest::limit)).setter(ListUsersRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaginationToken").getter(ListUsersRequest.getter(ListUsersRequest::paginationToken)).setter(ListUsersRequest.setter(Builder::paginationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()}).build();
    private static final SdkField<String> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Filter").getter(ListUsersRequest.getter(ListUsersRequest::filter)).setter(ListUsersRequest.setter(Builder::filter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, ATTRIBUTES_TO_GET_FIELD, LIMIT_FIELD, PAGINATION_TOKEN_FIELD, FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListUsersRequest.memberNameToFieldInitializer();
    private final String userPoolId;
    private final List<String> attributesToGet;
    private final Integer limit;
    private final String paginationToken;
    private final String filter;

    private ListUsersRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.attributesToGet = builder.attributesToGet;
        this.limit = builder.limit;
        this.paginationToken = builder.paginationToken;
        this.filter = builder.filter;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final boolean hasAttributesToGet() {
        return this.attributesToGet != null && !(this.attributesToGet instanceof SdkAutoConstructList);
    }

    public final List<String> attributesToGet() {
        return this.attributesToGet;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String paginationToken() {
        return this.paginationToken;
    }

    public final String filter() {
        return this.filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributesToGet() ? this.attributesToGet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.paginationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsersRequest)) {
            return false;
        }
        ListUsersRequest other = (ListUsersRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && this.hasAttributesToGet() == other.hasAttributesToGet() && Objects.equals(this.attributesToGet(), other.attributesToGet()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.paginationToken(), other.paginationToken()) && Objects.equals(this.filter(), other.filter());
    }

    public final String toString() {
        return ToString.builder((String)"ListUsersRequest").add("UserPoolId", (Object)this.userPoolId()).add("AttributesToGet", this.hasAttributesToGet() ? this.attributesToGet() : null).add("Limit", (Object)this.limit()).add("PaginationToken", (Object)this.paginationToken()).add("Filter", (Object)this.filter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "AttributesToGet": {
                return Optional.ofNullable(clazz.cast(this.attributesToGet()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "PaginationToken": {
                return Optional.ofNullable(clazz.cast(this.paginationToken()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UserPoolId", USER_POOL_ID_FIELD);
        map.put("AttributesToGet", ATTRIBUTES_TO_GET_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("PaginationToken", PAGINATION_TOKEN_FIELD);
        map.put("Filter", FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUsersRequest, T> g) {
        return obj -> g.apply((ListUsersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private List<String> attributesToGet = DefaultSdkAutoConstructList.getInstance();
        private Integer limit;
        private String paginationToken;
        private String filter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsersRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.attributesToGet(model.attributesToGet);
            this.limit(model.limit);
            this.paginationToken(model.paginationToken);
            this.filter(model.filter);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final Collection<String> getAttributesToGet() {
            if (this.attributesToGet instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributesToGet;
        }

        public final void setAttributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = SearchedAttributeNamesListTypeCopier.copy(attributesToGet);
        }

        @Override
        public final Builder attributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = SearchedAttributeNamesListTypeCopier.copy(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGet(String ... attributesToGet) {
            this.attributesToGet(Arrays.asList(attributesToGet));
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getPaginationToken() {
            return this.paginationToken;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final String getFilter() {
            return this.filter;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        @Override
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListUsersRequest build() {
            return new ListUsersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUsersRequest> {
        public Builder userPoolId(String var1);

        public Builder attributesToGet(Collection<String> var1);

        public Builder attributesToGet(String ... var1);

        public Builder limit(Integer var1);

        public Builder paginationToken(String var1);

        public Builder filter(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

