/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UserPoolTierType {
    LITE("LITE"),
    ESSENTIALS("ESSENTIALS"),
    PLUS("PLUS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UserPoolTierType> VALUE_MAP;
    private final String value;

    private UserPoolTierType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UserPoolTierType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UserPoolTierType> knownValues() {
        EnumSet<UserPoolTierType> knownValues = EnumSet.allOf(UserPoolTierType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UserPoolTierType.class, UserPoolTierType::toString);
    }
}

