/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserPoolClientDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserPoolClientDescription> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientId").getter(UserPoolClientDescription.getter(UserPoolClientDescription::clientId)).setter(UserPoolClientDescription.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(UserPoolClientDescription.getter(UserPoolClientDescription::userPoolId)).setter(UserPoolClientDescription.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> CLIENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientName").getter(UserPoolClientDescription.getter(UserPoolClientDescription::clientName)).setter(UserPoolClientDescription.setter(Builder::clientName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, USER_POOL_ID_FIELD, CLIENT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UserPoolClientDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clientId;
    private final String userPoolId;
    private final String clientName;

    private UserPoolClientDescription(BuilderImpl builder) {
        this.clientId = builder.clientId;
        this.userPoolId = builder.userPoolId;
        this.clientName = builder.clientName;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final String clientName() {
        return this.clientName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPoolClientDescription)) {
            return false;
        }
        UserPoolClientDescription other = (UserPoolClientDescription)obj;
        return Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.clientName(), other.clientName());
    }

    public final String toString() {
        return ToString.builder((String)"UserPoolClientDescription").add("ClientId", (Object)(this.clientId() == null ? null : "*** Sensitive Data Redacted ***")).add("UserPoolId", (Object)this.userPoolId()).add("ClientName", (Object)this.clientName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "ClientName": {
                return Optional.ofNullable(clazz.cast(this.clientName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("UserPoolId", USER_POOL_ID_FIELD);
        map.put("ClientName", CLIENT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserPoolClientDescription, T> g) {
        return obj -> g.apply((UserPoolClientDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientId;
        private String userPoolId;
        private String clientName;

        private BuilderImpl() {
        }

        private BuilderImpl(UserPoolClientDescription model) {
            this.clientId(model.clientId);
            this.userPoolId(model.userPoolId);
            this.clientName(model.clientName);
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getClientName() {
            return this.clientName;
        }

        public final void setClientName(String clientName) {
            this.clientName = clientName;
        }

        @Override
        public final Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public UserPoolClientDescription build() {
            return new UserPoolClientDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserPoolClientDescription> {
        public Builder clientId(String var1);

        public Builder userPoolId(String var1);

        public Builder clientName(String var1);
    }
}

