/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGroupRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, CreateGroupRequest> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(CreateGroupRequest.getter(CreateGroupRequest::groupName)).setter(CreateGroupRequest.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(CreateGroupRequest.getter(CreateGroupRequest::userPoolId)).setter(CreateGroupRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateGroupRequest.getter(CreateGroupRequest::description)).setter(CreateGroupRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateGroupRequest.getter(CreateGroupRequest::roleArn)).setter(CreateGroupRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Integer> PRECEDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Precedence").getter(CreateGroupRequest.getter(CreateGroupRequest::precedence)).setter(CreateGroupRequest.setter(Builder::precedence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Precedence").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, USER_POOL_ID_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD, PRECEDENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GroupName", GROUP_NAME_FIELD);
            this.put("UserPoolId", USER_POOL_ID_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("Precedence", PRECEDENCE_FIELD);
        }
    });
    private final String groupName;
    private final String userPoolId;
    private final String description;
    private final String roleArn;
    private final Integer precedence;

    private CreateGroupRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.userPoolId = builder.userPoolId;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.precedence = builder.precedence;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final String description() {
        return this.description;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Integer precedence() {
        return this.precedence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.precedence());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupRequest)) {
            return false;
        }
        CreateGroupRequest other = (CreateGroupRequest)((Object)obj);
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.precedence(), other.precedence());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGroupRequest").add("GroupName", (Object)this.groupName()).add("UserPoolId", (Object)this.userPoolId()).add("Description", (Object)this.description()).add("RoleArn", (Object)this.roleArn()).add("Precedence", (Object)this.precedence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Precedence": {
                return Optional.ofNullable(clazz.cast(this.precedence()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateGroupRequest, T> g) {
        return obj -> g.apply((CreateGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String groupName;
        private String userPoolId;
        private String description;
        private String roleArn;
        private Integer precedence;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGroupRequest model) {
            super(model);
            this.groupName(model.groupName);
            this.userPoolId(model.userPoolId);
            this.description(model.description);
            this.roleArn(model.roleArn);
            this.precedence(model.precedence);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Integer getPrecedence() {
            return this.precedence;
        }

        public final void setPrecedence(Integer precedence) {
            this.precedence = precedence;
        }

        @Override
        public final Builder precedence(Integer precedence) {
            this.precedence = precedence;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGroupRequest build() {
            return new CreateGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGroupRequest> {
        public Builder groupName(String var1);

        public Builder userPoolId(String var1);

        public Builder description(String var1);

        public Builder roleArn(String var1);

        public Builder precedence(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

