/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DefaultEmailOptionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerificationMessageTemplateType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VerificationMessageTemplateType> {
    private static final SdkField<String> SMS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SmsMessage").getter(VerificationMessageTemplateType.getter(VerificationMessageTemplateType::smsMessage)).setter(VerificationMessageTemplateType.setter(Builder::smsMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsMessage").build()}).build();
    private static final SdkField<String> EMAIL_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailMessage").getter(VerificationMessageTemplateType.getter(VerificationMessageTemplateType::emailMessage)).setter(VerificationMessageTemplateType.setter(Builder::emailMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMessage").build()}).build();
    private static final SdkField<String> EMAIL_SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailSubject").getter(VerificationMessageTemplateType.getter(VerificationMessageTemplateType::emailSubject)).setter(VerificationMessageTemplateType.setter(Builder::emailSubject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailSubject").build()}).build();
    private static final SdkField<String> EMAIL_MESSAGE_BY_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailMessageByLink").getter(VerificationMessageTemplateType.getter(VerificationMessageTemplateType::emailMessageByLink)).setter(VerificationMessageTemplateType.setter(Builder::emailMessageByLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMessageByLink").build()}).build();
    private static final SdkField<String> EMAIL_SUBJECT_BY_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailSubjectByLink").getter(VerificationMessageTemplateType.getter(VerificationMessageTemplateType::emailSubjectByLink)).setter(VerificationMessageTemplateType.setter(Builder::emailSubjectByLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailSubjectByLink").build()}).build();
    private static final SdkField<String> DEFAULT_EMAIL_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultEmailOption").getter(VerificationMessageTemplateType.getter(VerificationMessageTemplateType::defaultEmailOptionAsString)).setter(VerificationMessageTemplateType.setter(Builder::defaultEmailOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultEmailOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMS_MESSAGE_FIELD, EMAIL_MESSAGE_FIELD, EMAIL_SUBJECT_FIELD, EMAIL_MESSAGE_BY_LINK_FIELD, EMAIL_SUBJECT_BY_LINK_FIELD, DEFAULT_EMAIL_OPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VerificationMessageTemplateType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String smsMessage;
    private final String emailMessage;
    private final String emailSubject;
    private final String emailMessageByLink;
    private final String emailSubjectByLink;
    private final String defaultEmailOption;

    private VerificationMessageTemplateType(BuilderImpl builder) {
        this.smsMessage = builder.smsMessage;
        this.emailMessage = builder.emailMessage;
        this.emailSubject = builder.emailSubject;
        this.emailMessageByLink = builder.emailMessageByLink;
        this.emailSubjectByLink = builder.emailSubjectByLink;
        this.defaultEmailOption = builder.defaultEmailOption;
    }

    public final String smsMessage() {
        return this.smsMessage;
    }

    public final String emailMessage() {
        return this.emailMessage;
    }

    public final String emailSubject() {
        return this.emailSubject;
    }

    public final String emailMessageByLink() {
        return this.emailMessageByLink;
    }

    public final String emailSubjectByLink() {
        return this.emailSubjectByLink;
    }

    public final DefaultEmailOptionType defaultEmailOption() {
        return DefaultEmailOptionType.fromValue(this.defaultEmailOption);
    }

    public final String defaultEmailOptionAsString() {
        return this.defaultEmailOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.smsMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailSubject());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailMessageByLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailSubjectByLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultEmailOptionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerificationMessageTemplateType)) {
            return false;
        }
        VerificationMessageTemplateType other = (VerificationMessageTemplateType)obj;
        return Objects.equals(this.smsMessage(), other.smsMessage()) && Objects.equals(this.emailMessage(), other.emailMessage()) && Objects.equals(this.emailSubject(), other.emailSubject()) && Objects.equals(this.emailMessageByLink(), other.emailMessageByLink()) && Objects.equals(this.emailSubjectByLink(), other.emailSubjectByLink()) && Objects.equals(this.defaultEmailOptionAsString(), other.defaultEmailOptionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"VerificationMessageTemplateType").add("SmsMessage", (Object)this.smsMessage()).add("EmailMessage", (Object)this.emailMessage()).add("EmailSubject", (Object)this.emailSubject()).add("EmailMessageByLink", (Object)this.emailMessageByLink()).add("EmailSubjectByLink", (Object)this.emailSubjectByLink()).add("DefaultEmailOption", (Object)this.defaultEmailOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SmsMessage": {
                return Optional.ofNullable(clazz.cast(this.smsMessage()));
            }
            case "EmailMessage": {
                return Optional.ofNullable(clazz.cast(this.emailMessage()));
            }
            case "EmailSubject": {
                return Optional.ofNullable(clazz.cast(this.emailSubject()));
            }
            case "EmailMessageByLink": {
                return Optional.ofNullable(clazz.cast(this.emailMessageByLink()));
            }
            case "EmailSubjectByLink": {
                return Optional.ofNullable(clazz.cast(this.emailSubjectByLink()));
            }
            case "DefaultEmailOption": {
                return Optional.ofNullable(clazz.cast(this.defaultEmailOptionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SmsMessage", SMS_MESSAGE_FIELD);
        map.put("EmailMessage", EMAIL_MESSAGE_FIELD);
        map.put("EmailSubject", EMAIL_SUBJECT_FIELD);
        map.put("EmailMessageByLink", EMAIL_MESSAGE_BY_LINK_FIELD);
        map.put("EmailSubjectByLink", EMAIL_SUBJECT_BY_LINK_FIELD);
        map.put("DefaultEmailOption", DEFAULT_EMAIL_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerificationMessageTemplateType, T> g) {
        return obj -> g.apply((VerificationMessageTemplateType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String smsMessage;
        private String emailMessage;
        private String emailSubject;
        private String emailMessageByLink;
        private String emailSubjectByLink;
        private String defaultEmailOption;

        private BuilderImpl() {
        }

        private BuilderImpl(VerificationMessageTemplateType model) {
            this.smsMessage(model.smsMessage);
            this.emailMessage(model.emailMessage);
            this.emailSubject(model.emailSubject);
            this.emailMessageByLink(model.emailMessageByLink);
            this.emailSubjectByLink(model.emailSubjectByLink);
            this.defaultEmailOption(model.defaultEmailOption);
        }

        public final String getSmsMessage() {
            return this.smsMessage;
        }

        public final void setSmsMessage(String smsMessage) {
            this.smsMessage = smsMessage;
        }

        @Override
        public final Builder smsMessage(String smsMessage) {
            this.smsMessage = smsMessage;
            return this;
        }

        public final String getEmailMessage() {
            return this.emailMessage;
        }

        public final void setEmailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
        }

        @Override
        public final Builder emailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final String getEmailSubject() {
            return this.emailSubject;
        }

        public final void setEmailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
        }

        @Override
        public final Builder emailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
            return this;
        }

        public final String getEmailMessageByLink() {
            return this.emailMessageByLink;
        }

        public final void setEmailMessageByLink(String emailMessageByLink) {
            this.emailMessageByLink = emailMessageByLink;
        }

        @Override
        public final Builder emailMessageByLink(String emailMessageByLink) {
            this.emailMessageByLink = emailMessageByLink;
            return this;
        }

        public final String getEmailSubjectByLink() {
            return this.emailSubjectByLink;
        }

        public final void setEmailSubjectByLink(String emailSubjectByLink) {
            this.emailSubjectByLink = emailSubjectByLink;
        }

        @Override
        public final Builder emailSubjectByLink(String emailSubjectByLink) {
            this.emailSubjectByLink = emailSubjectByLink;
            return this;
        }

        public final String getDefaultEmailOption() {
            return this.defaultEmailOption;
        }

        public final void setDefaultEmailOption(String defaultEmailOption) {
            this.defaultEmailOption = defaultEmailOption;
        }

        @Override
        public final Builder defaultEmailOption(String defaultEmailOption) {
            this.defaultEmailOption = defaultEmailOption;
            return this;
        }

        @Override
        public final Builder defaultEmailOption(DefaultEmailOptionType defaultEmailOption) {
            this.defaultEmailOption(defaultEmailOption == null ? null : defaultEmailOption.toString());
            return this;
        }

        public VerificationMessageTemplateType build() {
            return new VerificationMessageTemplateType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VerificationMessageTemplateType> {
        public Builder smsMessage(String var1);

        public Builder emailMessage(String var1);

        public Builder emailSubject(String var1);

        public Builder emailMessageByLink(String var1);

        public Builder emailSubjectByLink(String var1);

        public Builder defaultEmailOption(String var1);

        public Builder defaultEmailOption(DefaultEmailOptionType var1);
    }
}

