/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AuthenticationResultType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AvailableChallengeListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeParametersTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InitiateAuthResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, InitiateAuthResponse> {
    private static final SdkField<String> CHALLENGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChallengeName").getter(InitiateAuthResponse.getter(InitiateAuthResponse::challengeNameAsString)).setter(InitiateAuthResponse.setter(Builder::challengeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeName").build()}).build();
    private static final SdkField<String> SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Session").getter(InitiateAuthResponse.getter(InitiateAuthResponse::session)).setter(InitiateAuthResponse.setter(Builder::session)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Session").build()}).build();
    private static final SdkField<Map<String, String>> CHALLENGE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ChallengeParameters").getter(InitiateAuthResponse.getter(InitiateAuthResponse::challengeParameters)).setter(InitiateAuthResponse.setter(Builder::challengeParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AuthenticationResultType> AUTHENTICATION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthenticationResult").getter(InitiateAuthResponse.getter(InitiateAuthResponse::authenticationResult)).setter(InitiateAuthResponse.setter(Builder::authenticationResult)).constructor(AuthenticationResultType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationResult").build()}).build();
    private static final SdkField<List<String>> AVAILABLE_CHALLENGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailableChallenges").getter(InitiateAuthResponse.getter(InitiateAuthResponse::availableChallengesAsStrings)).setter(InitiateAuthResponse.setter(Builder::availableChallengesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableChallenges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHALLENGE_NAME_FIELD, SESSION_FIELD, CHALLENGE_PARAMETERS_FIELD, AUTHENTICATION_RESULT_FIELD, AVAILABLE_CHALLENGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ChallengeName", CHALLENGE_NAME_FIELD);
            this.put("Session", SESSION_FIELD);
            this.put("ChallengeParameters", CHALLENGE_PARAMETERS_FIELD);
            this.put("AuthenticationResult", AUTHENTICATION_RESULT_FIELD);
            this.put("AvailableChallenges", AVAILABLE_CHALLENGES_FIELD);
        }
    });
    private final String challengeName;
    private final String session;
    private final Map<String, String> challengeParameters;
    private final AuthenticationResultType authenticationResult;
    private final List<String> availableChallenges;

    private InitiateAuthResponse(BuilderImpl builder) {
        super(builder);
        this.challengeName = builder.challengeName;
        this.session = builder.session;
        this.challengeParameters = builder.challengeParameters;
        this.authenticationResult = builder.authenticationResult;
        this.availableChallenges = builder.availableChallenges;
    }

    public final ChallengeNameType challengeName() {
        return ChallengeNameType.fromValue(this.challengeName);
    }

    public final String challengeNameAsString() {
        return this.challengeName;
    }

    public final String session() {
        return this.session;
    }

    public final boolean hasChallengeParameters() {
        return this.challengeParameters != null && !(this.challengeParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> challengeParameters() {
        return this.challengeParameters;
    }

    public final AuthenticationResultType authenticationResult() {
        return this.authenticationResult;
    }

    public final List<ChallengeNameType> availableChallenges() {
        return AvailableChallengeListTypeCopier.copyStringToEnum(this.availableChallenges);
    }

    public final boolean hasAvailableChallenges() {
        return this.availableChallenges != null && !(this.availableChallenges instanceof SdkAutoConstructList);
    }

    public final List<String> availableChallengesAsStrings() {
        return this.availableChallenges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.challengeNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.session());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChallengeParameters() ? this.challengeParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailableChallenges() ? this.availableChallengesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateAuthResponse)) {
            return false;
        }
        InitiateAuthResponse other = (InitiateAuthResponse)((Object)obj);
        return Objects.equals(this.challengeNameAsString(), other.challengeNameAsString()) && Objects.equals(this.session(), other.session()) && this.hasChallengeParameters() == other.hasChallengeParameters() && Objects.equals(this.challengeParameters(), other.challengeParameters()) && Objects.equals(this.authenticationResult(), other.authenticationResult()) && this.hasAvailableChallenges() == other.hasAvailableChallenges() && Objects.equals(this.availableChallengesAsStrings(), other.availableChallengesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"InitiateAuthResponse").add("ChallengeName", (Object)this.challengeNameAsString()).add("Session", (Object)(this.session() == null ? null : "*** Sensitive Data Redacted ***")).add("ChallengeParameters", this.hasChallengeParameters() ? this.challengeParameters() : null).add("AuthenticationResult", (Object)this.authenticationResult()).add("AvailableChallenges", this.hasAvailableChallenges() ? this.availableChallengesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChallengeName": {
                return Optional.ofNullable(clazz.cast(this.challengeNameAsString()));
            }
            case "Session": {
                return Optional.ofNullable(clazz.cast(this.session()));
            }
            case "ChallengeParameters": {
                return Optional.ofNullable(clazz.cast(this.challengeParameters()));
            }
            case "AuthenticationResult": {
                return Optional.ofNullable(clazz.cast(this.authenticationResult()));
            }
            case "AvailableChallenges": {
                return Optional.ofNullable(clazz.cast(this.availableChallengesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InitiateAuthResponse, T> g) {
        return obj -> g.apply((InitiateAuthResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private String challengeName;
        private String session;
        private Map<String, String> challengeParameters = DefaultSdkAutoConstructMap.getInstance();
        private AuthenticationResultType authenticationResult;
        private List<String> availableChallenges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InitiateAuthResponse model) {
            super(model);
            this.challengeName(model.challengeName);
            this.session(model.session);
            this.challengeParameters(model.challengeParameters);
            this.authenticationResult(model.authenticationResult);
            this.availableChallengesWithStrings(model.availableChallenges);
        }

        public final String getChallengeName() {
            return this.challengeName;
        }

        public final void setChallengeName(String challengeName) {
            this.challengeName = challengeName;
        }

        @Override
        public final Builder challengeName(String challengeName) {
            this.challengeName = challengeName;
            return this;
        }

        @Override
        public final Builder challengeName(ChallengeNameType challengeName) {
            this.challengeName(challengeName == null ? null : challengeName.toString());
            return this;
        }

        public final String getSession() {
            return this.session;
        }

        public final void setSession(String session) {
            this.session = session;
        }

        @Override
        public final Builder session(String session) {
            this.session = session;
            return this;
        }

        public final Map<String, String> getChallengeParameters() {
            if (this.challengeParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.challengeParameters;
        }

        public final void setChallengeParameters(Map<String, String> challengeParameters) {
            this.challengeParameters = ChallengeParametersTypeCopier.copy(challengeParameters);
        }

        @Override
        public final Builder challengeParameters(Map<String, String> challengeParameters) {
            this.challengeParameters = ChallengeParametersTypeCopier.copy(challengeParameters);
            return this;
        }

        public final AuthenticationResultType.Builder getAuthenticationResult() {
            return this.authenticationResult != null ? this.authenticationResult.toBuilder() : null;
        }

        public final void setAuthenticationResult(AuthenticationResultType.BuilderImpl authenticationResult) {
            this.authenticationResult = authenticationResult != null ? authenticationResult.build() : null;
        }

        @Override
        public final Builder authenticationResult(AuthenticationResultType authenticationResult) {
            this.authenticationResult = authenticationResult;
            return this;
        }

        public final Collection<String> getAvailableChallenges() {
            if (this.availableChallenges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availableChallenges;
        }

        public final void setAvailableChallenges(Collection<String> availableChallenges) {
            this.availableChallenges = AvailableChallengeListTypeCopier.copy(availableChallenges);
        }

        @Override
        public final Builder availableChallengesWithStrings(Collection<String> availableChallenges) {
            this.availableChallenges = AvailableChallengeListTypeCopier.copy(availableChallenges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableChallengesWithStrings(String ... availableChallenges) {
            this.availableChallengesWithStrings(Arrays.asList(availableChallenges));
            return this;
        }

        @Override
        public final Builder availableChallenges(Collection<ChallengeNameType> availableChallenges) {
            this.availableChallenges = AvailableChallengeListTypeCopier.copyEnumToString(availableChallenges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableChallenges(ChallengeNameType ... availableChallenges) {
            this.availableChallenges(Arrays.asList(availableChallenges));
            return this;
        }

        @Override
        public InitiateAuthResponse build() {
            return new InitiateAuthResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InitiateAuthResponse> {
        public Builder challengeName(String var1);

        public Builder challengeName(ChallengeNameType var1);

        public Builder session(String var1);

        public Builder challengeParameters(Map<String, String> var1);

        public Builder authenticationResult(AuthenticationResultType var1);

        default public Builder authenticationResult(Consumer<AuthenticationResultType.Builder> authenticationResult) {
            return this.authenticationResult((AuthenticationResultType)((AuthenticationResultType.Builder)AuthenticationResultType.builder().applyMutation(authenticationResult)).build());
        }

        public Builder availableChallengesWithStrings(Collection<String> var1);

        public Builder availableChallengesWithStrings(String ... var1);

        public Builder availableChallenges(Collection<ChallengeNameType> var1);

        public Builder availableChallenges(ChallengeNameType ... var1);
    }
}

