/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeResourceServerResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, DescribeResourceServerResponse> {
    private static final SdkField<ResourceServerType> RESOURCE_SERVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceServer").getter(DescribeResourceServerResponse.getter(DescribeResourceServerResponse::resourceServer)).setter(DescribeResourceServerResponse.setter(Builder::resourceServer)).constructor(ResourceServerType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceServer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SERVER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ResourceServer", RESOURCE_SERVER_FIELD);
        }
    });
    private final ResourceServerType resourceServer;

    private DescribeResourceServerResponse(BuilderImpl builder) {
        super(builder);
        this.resourceServer = builder.resourceServer;
    }

    public final ResourceServerType resourceServer() {
        return this.resourceServer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceServer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourceServerResponse)) {
            return false;
        }
        DescribeResourceServerResponse other = (DescribeResourceServerResponse)((Object)obj);
        return Objects.equals(this.resourceServer(), other.resourceServer());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeResourceServerResponse").add("ResourceServer", (Object)this.resourceServer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceServer": {
                return Optional.ofNullable(clazz.cast(this.resourceServer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourceServerResponse, T> g) {
        return obj -> g.apply((DescribeResourceServerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private ResourceServerType resourceServer;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourceServerResponse model) {
            super(model);
            this.resourceServer(model.resourceServer);
        }

        public final ResourceServerType.Builder getResourceServer() {
            return this.resourceServer != null ? this.resourceServer.toBuilder() : null;
        }

        public final void setResourceServer(ResourceServerType.BuilderImpl resourceServer) {
            this.resourceServer = resourceServer != null ? resourceServer.build() : null;
        }

        @Override
        public final Builder resourceServer(ResourceServerType resourceServer) {
            this.resourceServer = resourceServer;
            return this;
        }

        @Override
        public DescribeResourceServerResponse build() {
            return new DescribeResourceServerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeResourceServerResponse> {
        public Builder resourceServer(ResourceServerType var1);

        default public Builder resourceServer(Consumer<ResourceServerType.Builder> resourceServer) {
            return this.resourceServer((ResourceServerType)((ResourceServerType.Builder)ResourceServerType.builder().applyMutation(resourceServer)).build());
        }
    }
}

