/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnCredentialDescription;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnCredentialDescriptionListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWebAuthnCredentialsResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, ListWebAuthnCredentialsResponse> {
    private static final SdkField<List<WebAuthnCredentialDescription>> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Credentials").getter(ListWebAuthnCredentialsResponse.getter(ListWebAuthnCredentialsResponse::credentials)).setter(ListWebAuthnCredentialsResponse.setter(Builder::credentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WebAuthnCredentialDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWebAuthnCredentialsResponse.getter(ListWebAuthnCredentialsResponse::nextToken)).setter(ListWebAuthnCredentialsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Credentials", CREDENTIALS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<WebAuthnCredentialDescription> credentials;
    private final String nextToken;

    private ListWebAuthnCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCredentials() {
        return this.credentials != null && !(this.credentials instanceof SdkAutoConstructList);
    }

    public final List<WebAuthnCredentialDescription> credentials() {
        return this.credentials;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCredentials() ? this.credentials() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWebAuthnCredentialsResponse)) {
            return false;
        }
        ListWebAuthnCredentialsResponse other = (ListWebAuthnCredentialsResponse)((Object)obj);
        return this.hasCredentials() == other.hasCredentials() && Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListWebAuthnCredentialsResponse").add("Credentials", this.hasCredentials() ? this.credentials() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListWebAuthnCredentialsResponse, T> g) {
        return obj -> g.apply((ListWebAuthnCredentialsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private List<WebAuthnCredentialDescription> credentials = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWebAuthnCredentialsResponse model) {
            super(model);
            this.credentials(model.credentials);
            this.nextToken(model.nextToken);
        }

        public final List<WebAuthnCredentialDescription.Builder> getCredentials() {
            List<WebAuthnCredentialDescription.Builder> result = WebAuthnCredentialDescriptionListTypeCopier.copyToBuilder(this.credentials);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCredentials(Collection<WebAuthnCredentialDescription.BuilderImpl> credentials) {
            this.credentials = WebAuthnCredentialDescriptionListTypeCopier.copyFromBuilder(credentials);
        }

        @Override
        public final Builder credentials(Collection<WebAuthnCredentialDescription> credentials) {
            this.credentials = WebAuthnCredentialDescriptionListTypeCopier.copy(credentials);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentials(WebAuthnCredentialDescription ... credentials) {
            this.credentials(Arrays.asList(credentials));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentials(Consumer<WebAuthnCredentialDescription.Builder> ... credentials) {
            this.credentials(Stream.of(credentials).map(c -> (WebAuthnCredentialDescription)((WebAuthnCredentialDescription.Builder)WebAuthnCredentialDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWebAuthnCredentialsResponse build() {
            return new ListWebAuthnCredentialsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWebAuthnCredentialsResponse> {
        public Builder credentials(Collection<WebAuthnCredentialDescription> var1);

        public Builder credentials(WebAuthnCredentialDescription ... var1);

        public Builder credentials(Consumer<WebAuthnCredentialDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

