/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteManagedLoginBrandingRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, DeleteManagedLoginBrandingRequest> {
    private static final SdkField<String> MANAGED_LOGIN_BRANDING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedLoginBrandingId").getter(DeleteManagedLoginBrandingRequest.getter(DeleteManagedLoginBrandingRequest::managedLoginBrandingId)).setter(DeleteManagedLoginBrandingRequest.setter(Builder::managedLoginBrandingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedLoginBrandingId").build()}).build();
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(DeleteManagedLoginBrandingRequest.getter(DeleteManagedLoginBrandingRequest::userPoolId)).setter(DeleteManagedLoginBrandingRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_LOGIN_BRANDING_ID_FIELD, USER_POOL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ManagedLoginBrandingId", MANAGED_LOGIN_BRANDING_ID_FIELD);
            this.put("UserPoolId", USER_POOL_ID_FIELD);
        }
    });
    private final String managedLoginBrandingId;
    private final String userPoolId;

    private DeleteManagedLoginBrandingRequest(BuilderImpl builder) {
        super(builder);
        this.managedLoginBrandingId = builder.managedLoginBrandingId;
        this.userPoolId = builder.userPoolId;
    }

    public final String managedLoginBrandingId() {
        return this.managedLoginBrandingId;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.managedLoginBrandingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteManagedLoginBrandingRequest)) {
            return false;
        }
        DeleteManagedLoginBrandingRequest other = (DeleteManagedLoginBrandingRequest)((Object)obj);
        return Objects.equals(this.managedLoginBrandingId(), other.managedLoginBrandingId()) && Objects.equals(this.userPoolId(), other.userPoolId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteManagedLoginBrandingRequest").add("ManagedLoginBrandingId", (Object)this.managedLoginBrandingId()).add("UserPoolId", (Object)this.userPoolId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManagedLoginBrandingId": {
                return Optional.ofNullable(clazz.cast(this.managedLoginBrandingId()));
            }
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteManagedLoginBrandingRequest, T> g) {
        return obj -> g.apply((DeleteManagedLoginBrandingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String managedLoginBrandingId;
        private String userPoolId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteManagedLoginBrandingRequest model) {
            super(model);
            this.managedLoginBrandingId(model.managedLoginBrandingId);
            this.userPoolId(model.userPoolId);
        }

        public final String getManagedLoginBrandingId() {
            return this.managedLoginBrandingId;
        }

        public final void setManagedLoginBrandingId(String managedLoginBrandingId) {
            this.managedLoginBrandingId = managedLoginBrandingId;
        }

        @Override
        public final Builder managedLoginBrandingId(String managedLoginBrandingId) {
            this.managedLoginBrandingId = managedLoginBrandingId;
            return this;
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteManagedLoginBrandingRequest build() {
            return new DeleteManagedLoginBrandingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteManagedLoginBrandingRequest> {
        public Builder managedLoginBrandingId(String var1);

        public Builder userPoolId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

