/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PreTokenGenerationLambdaVersionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PreTokenGenerationVersionConfigType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PreTokenGenerationVersionConfigType> {
    private static final SdkField<String> LAMBDA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LambdaVersion").getter(PreTokenGenerationVersionConfigType.getter(PreTokenGenerationVersionConfigType::lambdaVersionAsString)).setter(PreTokenGenerationVersionConfigType.setter(Builder::lambdaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaVersion").build()}).build();
    private static final SdkField<String> LAMBDA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LambdaArn").getter(PreTokenGenerationVersionConfigType.getter(PreTokenGenerationVersionConfigType::lambdaArn)).setter(PreTokenGenerationVersionConfigType.setter(Builder::lambdaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_VERSION_FIELD, LAMBDA_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LambdaVersion", LAMBDA_VERSION_FIELD);
            this.put("LambdaArn", LAMBDA_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String lambdaVersion;
    private final String lambdaArn;

    private PreTokenGenerationVersionConfigType(BuilderImpl builder) {
        this.lambdaVersion = builder.lambdaVersion;
        this.lambdaArn = builder.lambdaArn;
    }

    public final PreTokenGenerationLambdaVersionType lambdaVersion() {
        return PreTokenGenerationLambdaVersionType.fromValue(this.lambdaVersion);
    }

    public final String lambdaVersionAsString() {
        return this.lambdaVersion;
    }

    public final String lambdaArn() {
        return this.lambdaArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PreTokenGenerationVersionConfigType)) {
            return false;
        }
        PreTokenGenerationVersionConfigType other = (PreTokenGenerationVersionConfigType)obj;
        return Objects.equals(this.lambdaVersionAsString(), other.lambdaVersionAsString()) && Objects.equals(this.lambdaArn(), other.lambdaArn());
    }

    public final String toString() {
        return ToString.builder((String)"PreTokenGenerationVersionConfigType").add("LambdaVersion", (Object)this.lambdaVersionAsString()).add("LambdaArn", (Object)this.lambdaArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LambdaVersion": {
                return Optional.ofNullable(clazz.cast(this.lambdaVersionAsString()));
            }
            case "LambdaArn": {
                return Optional.ofNullable(clazz.cast(this.lambdaArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PreTokenGenerationVersionConfigType, T> g) {
        return obj -> g.apply((PreTokenGenerationVersionConfigType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lambdaVersion;
        private String lambdaArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PreTokenGenerationVersionConfigType model) {
            this.lambdaVersion(model.lambdaVersion);
            this.lambdaArn(model.lambdaArn);
        }

        public final String getLambdaVersion() {
            return this.lambdaVersion;
        }

        public final void setLambdaVersion(String lambdaVersion) {
            this.lambdaVersion = lambdaVersion;
        }

        @Override
        public final Builder lambdaVersion(String lambdaVersion) {
            this.lambdaVersion = lambdaVersion;
            return this;
        }

        @Override
        public final Builder lambdaVersion(PreTokenGenerationLambdaVersionType lambdaVersion) {
            this.lambdaVersion(lambdaVersion == null ? null : lambdaVersion.toString());
            return this;
        }

        public final String getLambdaArn() {
            return this.lambdaArn;
        }

        public final void setLambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
        }

        @Override
        public final Builder lambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
            return this;
        }

        public PreTokenGenerationVersionConfigType build() {
            return new PreTokenGenerationVersionConfigType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PreTokenGenerationVersionConfigType> {
        public Builder lambdaVersion(String var1);

        public Builder lambdaVersion(PreTokenGenerationLambdaVersionType var1);

        public Builder lambdaArn(String var1);
    }
}

