/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EmailMfaSettingsType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SMSMfaSettingsType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetUserMfaPreferenceRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, SetUserMfaPreferenceRequest> {
    private static final SdkField<SMSMfaSettingsType> SMS_MFA_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SMSMfaSettings").getter(SetUserMfaPreferenceRequest.getter(SetUserMfaPreferenceRequest::smsMfaSettings)).setter(SetUserMfaPreferenceRequest.setter(Builder::smsMfaSettings)).constructor(SMSMfaSettingsType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMSMfaSettings").build()}).build();
    private static final SdkField<SoftwareTokenMfaSettingsType> SOFTWARE_TOKEN_MFA_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SoftwareTokenMfaSettings").getter(SetUserMfaPreferenceRequest.getter(SetUserMfaPreferenceRequest::softwareTokenMfaSettings)).setter(SetUserMfaPreferenceRequest.setter(Builder::softwareTokenMfaSettings)).constructor(SoftwareTokenMfaSettingsType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareTokenMfaSettings").build()}).build();
    private static final SdkField<EmailMfaSettingsType> EMAIL_MFA_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmailMfaSettings").getter(SetUserMfaPreferenceRequest.getter(SetUserMfaPreferenceRequest::emailMfaSettings)).setter(SetUserMfaPreferenceRequest.setter(Builder::emailMfaSettings)).constructor(EmailMfaSettingsType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMfaSettings").build()}).build();
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessToken").getter(SetUserMfaPreferenceRequest.getter(SetUserMfaPreferenceRequest::accessToken)).setter(SetUserMfaPreferenceRequest.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMS_MFA_SETTINGS_FIELD, SOFTWARE_TOKEN_MFA_SETTINGS_FIELD, EMAIL_MFA_SETTINGS_FIELD, ACCESS_TOKEN_FIELD));
    private final SMSMfaSettingsType smsMfaSettings;
    private final SoftwareTokenMfaSettingsType softwareTokenMfaSettings;
    private final EmailMfaSettingsType emailMfaSettings;
    private final String accessToken;

    private SetUserMfaPreferenceRequest(BuilderImpl builder) {
        super(builder);
        this.smsMfaSettings = builder.smsMfaSettings;
        this.softwareTokenMfaSettings = builder.softwareTokenMfaSettings;
        this.emailMfaSettings = builder.emailMfaSettings;
        this.accessToken = builder.accessToken;
    }

    public final SMSMfaSettingsType smsMfaSettings() {
        return this.smsMfaSettings;
    }

    public final SoftwareTokenMfaSettingsType softwareTokenMfaSettings() {
        return this.softwareTokenMfaSettings;
    }

    public final EmailMfaSettingsType emailMfaSettings() {
        return this.emailMfaSettings;
    }

    public final String accessToken() {
        return this.accessToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.smsMfaSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareTokenMfaSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailMfaSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetUserMfaPreferenceRequest)) {
            return false;
        }
        SetUserMfaPreferenceRequest other = (SetUserMfaPreferenceRequest)((Object)obj);
        return Objects.equals(this.smsMfaSettings(), other.smsMfaSettings()) && Objects.equals(this.softwareTokenMfaSettings(), other.softwareTokenMfaSettings()) && Objects.equals(this.emailMfaSettings(), other.emailMfaSettings()) && Objects.equals(this.accessToken(), other.accessToken());
    }

    public final String toString() {
        return ToString.builder((String)"SetUserMfaPreferenceRequest").add("SMSMfaSettings", (Object)this.smsMfaSettings()).add("SoftwareTokenMfaSettings", (Object)this.softwareTokenMfaSettings()).add("EmailMfaSettings", (Object)this.emailMfaSettings()).add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SMSMfaSettings": {
                return Optional.ofNullable(clazz.cast(this.smsMfaSettings()));
            }
            case "SoftwareTokenMfaSettings": {
                return Optional.ofNullable(clazz.cast(this.softwareTokenMfaSettings()));
            }
            case "EmailMfaSettings": {
                return Optional.ofNullable(clazz.cast(this.emailMfaSettings()));
            }
            case "AccessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetUserMfaPreferenceRequest, T> g) {
        return obj -> g.apply((SetUserMfaPreferenceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private SMSMfaSettingsType smsMfaSettings;
        private SoftwareTokenMfaSettingsType softwareTokenMfaSettings;
        private EmailMfaSettingsType emailMfaSettings;
        private String accessToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SetUserMfaPreferenceRequest model) {
            super(model);
            this.smsMfaSettings(model.smsMfaSettings);
            this.softwareTokenMfaSettings(model.softwareTokenMfaSettings);
            this.emailMfaSettings(model.emailMfaSettings);
            this.accessToken(model.accessToken);
        }

        public final SMSMfaSettingsType.Builder getSmsMfaSettings() {
            return this.smsMfaSettings != null ? this.smsMfaSettings.toBuilder() : null;
        }

        public final void setSmsMfaSettings(SMSMfaSettingsType.BuilderImpl smsMfaSettings) {
            this.smsMfaSettings = smsMfaSettings != null ? smsMfaSettings.build() : null;
        }

        @Override
        public final Builder smsMfaSettings(SMSMfaSettingsType smsMfaSettings) {
            this.smsMfaSettings = smsMfaSettings;
            return this;
        }

        public final SoftwareTokenMfaSettingsType.Builder getSoftwareTokenMfaSettings() {
            return this.softwareTokenMfaSettings != null ? this.softwareTokenMfaSettings.toBuilder() : null;
        }

        public final void setSoftwareTokenMfaSettings(SoftwareTokenMfaSettingsType.BuilderImpl softwareTokenMfaSettings) {
            this.softwareTokenMfaSettings = softwareTokenMfaSettings != null ? softwareTokenMfaSettings.build() : null;
        }

        @Override
        public final Builder softwareTokenMfaSettings(SoftwareTokenMfaSettingsType softwareTokenMfaSettings) {
            this.softwareTokenMfaSettings = softwareTokenMfaSettings;
            return this;
        }

        public final EmailMfaSettingsType.Builder getEmailMfaSettings() {
            return this.emailMfaSettings != null ? this.emailMfaSettings.toBuilder() : null;
        }

        public final void setEmailMfaSettings(EmailMfaSettingsType.BuilderImpl emailMfaSettings) {
            this.emailMfaSettings = emailMfaSettings != null ? emailMfaSettings.build() : null;
        }

        @Override
        public final Builder emailMfaSettings(EmailMfaSettingsType emailMfaSettings) {
            this.emailMfaSettings = emailMfaSettings;
            return this;
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetUserMfaPreferenceRequest build() {
            return new SetUserMfaPreferenceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetUserMfaPreferenceRequest> {
        public Builder smsMfaSettings(SMSMfaSettingsType var1);

        default public Builder smsMfaSettings(Consumer<SMSMfaSettingsType.Builder> smsMfaSettings) {
            return this.smsMfaSettings((SMSMfaSettingsType)((SMSMfaSettingsType.Builder)SMSMfaSettingsType.builder().applyMutation(smsMfaSettings)).build());
        }

        public Builder softwareTokenMfaSettings(SoftwareTokenMfaSettingsType var1);

        default public Builder softwareTokenMfaSettings(Consumer<SoftwareTokenMfaSettingsType.Builder> softwareTokenMfaSettings) {
            return this.softwareTokenMfaSettings((SoftwareTokenMfaSettingsType)((SoftwareTokenMfaSettingsType.Builder)SoftwareTokenMfaSettingsType.builder().applyMutation(softwareTokenMfaSettings)).build());
        }

        public Builder emailMfaSettings(EmailMfaSettingsType var1);

        default public Builder emailMfaSettings(Consumer<EmailMfaSettingsType.Builder> emailMfaSettings) {
            return this.emailMfaSettings((EmailMfaSettingsType)((EmailMfaSettingsType.Builder)EmailMfaSettingsType.builder().applyMutation(emailMfaSettings)).build());
        }

        public Builder accessToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

