/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data type TokenValidityUnits specifies the time units you use when you set the duration of ID, access, and
 * refresh tokens.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TokenValidityUnitsType implements SdkPojo, Serializable,
        ToCopyableBuilder<TokenValidityUnitsType.Builder, TokenValidityUnitsType> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessToken").getter(getter(TokenValidityUnitsType::accessTokenAsString))
            .setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()).build();

    private static final SdkField<String> ID_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdToken").getter(getter(TokenValidityUnitsType::idTokenAsString)).setter(setter(Builder::idToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdToken").build()).build();

    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RefreshToken").getter(getter(TokenValidityUnitsType::refreshTokenAsString))
            .setter(setter(Builder::refreshToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD,
            ID_TOKEN_FIELD, REFRESH_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accessToken;

    private final String idToken;

    private final String refreshToken;

    private TokenValidityUnitsType(BuilderImpl builder) {
        this.accessToken = builder.accessToken;
        this.idToken = builder.idToken;
        this.refreshToken = builder.refreshToken;
    }

    /**
     * <p>
     * A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code> for the value
     * that you set in the <code>AccessTokenValidity</code> parameter. The default <code>AccessTokenValidity</code> time
     * unit is hours.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessToken} will
     * return {@link TimeUnitsType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessTokenAsString}.
     * </p>
     * 
     * @return A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code> for
     *         the value that you set in the <code>AccessTokenValidity</code> parameter. The default
     *         <code>AccessTokenValidity</code> time unit is hours.
     * @see TimeUnitsType
     */
    public final TimeUnitsType accessToken() {
        return TimeUnitsType.fromValue(accessToken);
    }

    /**
     * <p>
     * A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code> for the value
     * that you set in the <code>AccessTokenValidity</code> parameter. The default <code>AccessTokenValidity</code> time
     * unit is hours.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessToken} will
     * return {@link TimeUnitsType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessTokenAsString}.
     * </p>
     * 
     * @return A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code> for
     *         the value that you set in the <code>AccessTokenValidity</code> parameter. The default
     *         <code>AccessTokenValidity</code> time unit is hours.
     * @see TimeUnitsType
     */
    public final String accessTokenAsString() {
        return accessToken;
    }

    /**
     * <p>
     * A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code> for the value
     * that you set in the <code>IdTokenValidity</code> parameter. The default <code>IdTokenValidity</code> time unit is
     * hours.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #idToken} will
     * return {@link TimeUnitsType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #idTokenAsString}.
     * </p>
     * 
     * @return A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code> for
     *         the value that you set in the <code>IdTokenValidity</code> parameter. The default
     *         <code>IdTokenValidity</code> time unit is hours.
     * @see TimeUnitsType
     */
    public final TimeUnitsType idToken() {
        return TimeUnitsType.fromValue(idToken);
    }

    /**
     * <p>
     * A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code> for the value
     * that you set in the <code>IdTokenValidity</code> parameter. The default <code>IdTokenValidity</code> time unit is
     * hours.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #idToken} will
     * return {@link TimeUnitsType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #idTokenAsString}.
     * </p>
     * 
     * @return A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code> for
     *         the value that you set in the <code>IdTokenValidity</code> parameter. The default
     *         <code>IdTokenValidity</code> time unit is hours.
     * @see TimeUnitsType
     */
    public final String idTokenAsString() {
        return idToken;
    }

    /**
     * <p>
     * A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code> for the value
     * that you set in the <code>RefreshTokenValidity</code> parameter. The default <code>RefreshTokenValidity</code>
     * time unit is days.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #refreshToken} will
     * return {@link TimeUnitsType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #refreshTokenAsString}.
     * </p>
     * 
     * @return A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code> for
     *         the value that you set in the <code>RefreshTokenValidity</code> parameter. The default
     *         <code>RefreshTokenValidity</code> time unit is days.
     * @see TimeUnitsType
     */
    public final TimeUnitsType refreshToken() {
        return TimeUnitsType.fromValue(refreshToken);
    }

    /**
     * <p>
     * A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code> for the value
     * that you set in the <code>RefreshTokenValidity</code> parameter. The default <code>RefreshTokenValidity</code>
     * time unit is days.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #refreshToken} will
     * return {@link TimeUnitsType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #refreshTokenAsString}.
     * </p>
     * 
     * @return A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code> for
     *         the value that you set in the <code>RefreshTokenValidity</code> parameter. The default
     *         <code>RefreshTokenValidity</code> time unit is days.
     * @see TimeUnitsType
     */
    public final String refreshTokenAsString() {
        return refreshToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessTokenAsString());
        hashCode = 31 * hashCode + Objects.hashCode(idTokenAsString());
        hashCode = 31 * hashCode + Objects.hashCode(refreshTokenAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TokenValidityUnitsType)) {
            return false;
        }
        TokenValidityUnitsType other = (TokenValidityUnitsType) obj;
        return Objects.equals(accessTokenAsString(), other.accessTokenAsString())
                && Objects.equals(idTokenAsString(), other.idTokenAsString())
                && Objects.equals(refreshTokenAsString(), other.refreshTokenAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TokenValidityUnitsType").add("AccessToken", accessTokenAsString())
                .add("IdToken", idTokenAsString()).add("RefreshToken", refreshTokenAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessToken":
            return Optional.ofNullable(clazz.cast(accessTokenAsString()));
        case "IdToken":
            return Optional.ofNullable(clazz.cast(idTokenAsString()));
        case "RefreshToken":
            return Optional.ofNullable(clazz.cast(refreshTokenAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TokenValidityUnitsType, T> g) {
        return obj -> g.apply((TokenValidityUnitsType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TokenValidityUnitsType> {
        /**
         * <p>
         * A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code> for the
         * value that you set in the <code>AccessTokenValidity</code> parameter. The default
         * <code>AccessTokenValidity</code> time unit is hours.
         * </p>
         * 
         * @param accessToken
         *        A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code>
         *        for the value that you set in the <code>AccessTokenValidity</code> parameter. The default
         *        <code>AccessTokenValidity</code> time unit is hours.
         * @see TimeUnitsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeUnitsType
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code> for the
         * value that you set in the <code>AccessTokenValidity</code> parameter. The default
         * <code>AccessTokenValidity</code> time unit is hours.
         * </p>
         * 
         * @param accessToken
         *        A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code>
         *        for the value that you set in the <code>AccessTokenValidity</code> parameter. The default
         *        <code>AccessTokenValidity</code> time unit is hours.
         * @see TimeUnitsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeUnitsType
         */
        Builder accessToken(TimeUnitsType accessToken);

        /**
         * <p>
         * A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code> for the
         * value that you set in the <code>IdTokenValidity</code> parameter. The default <code>IdTokenValidity</code>
         * time unit is hours.
         * </p>
         * 
         * @param idToken
         *        A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code>
         *        for the value that you set in the <code>IdTokenValidity</code> parameter. The default
         *        <code>IdTokenValidity</code> time unit is hours.
         * @see TimeUnitsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeUnitsType
         */
        Builder idToken(String idToken);

        /**
         * <p>
         * A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code> for the
         * value that you set in the <code>IdTokenValidity</code> parameter. The default <code>IdTokenValidity</code>
         * time unit is hours.
         * </p>
         * 
         * @param idToken
         *        A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code>
         *        for the value that you set in the <code>IdTokenValidity</code> parameter. The default
         *        <code>IdTokenValidity</code> time unit is hours.
         * @see TimeUnitsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeUnitsType
         */
        Builder idToken(TimeUnitsType idToken);

        /**
         * <p>
         * A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code> for the
         * value that you set in the <code>RefreshTokenValidity</code> parameter. The default
         * <code>RefreshTokenValidity</code> time unit is days.
         * </p>
         * 
         * @param refreshToken
         *        A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code>
         *        for the value that you set in the <code>RefreshTokenValidity</code> parameter. The default
         *        <code>RefreshTokenValidity</code> time unit is days.
         * @see TimeUnitsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeUnitsType
         */
        Builder refreshToken(String refreshToken);

        /**
         * <p>
         * A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code> for the
         * value that you set in the <code>RefreshTokenValidity</code> parameter. The default
         * <code>RefreshTokenValidity</code> time unit is days.
         * </p>
         * 
         * @param refreshToken
         *        A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code>
         *        for the value that you set in the <code>RefreshTokenValidity</code> parameter. The default
         *        <code>RefreshTokenValidity</code> time unit is days.
         * @see TimeUnitsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeUnitsType
         */
        Builder refreshToken(TimeUnitsType refreshToken);
    }

    static final class BuilderImpl implements Builder {
        private String accessToken;

        private String idToken;

        private String refreshToken;

        private BuilderImpl() {
        }

        private BuilderImpl(TokenValidityUnitsType model) {
            accessToken(model.accessToken);
            idToken(model.idToken);
            refreshToken(model.refreshToken);
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @Override
        public final Builder accessToken(TimeUnitsType accessToken) {
            this.accessToken(accessToken == null ? null : accessToken.toString());
            return this;
        }

        public final String getIdToken() {
            return idToken;
        }

        public final void setIdToken(String idToken) {
            this.idToken = idToken;
        }

        @Override
        public final Builder idToken(String idToken) {
            this.idToken = idToken;
            return this;
        }

        @Override
        public final Builder idToken(TimeUnitsType idToken) {
            this.idToken(idToken == null ? null : idToken.toString());
            return this;
        }

        public final String getRefreshToken() {
            return refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        @Override
        public final Builder refreshToken(TimeUnitsType refreshToken) {
            this.refreshToken(refreshToken == null ? null : refreshToken.toString());
            return this;
        }

        @Override
        public TokenValidityUnitsType build() {
            return new TokenValidityUnitsType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
