/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AttributeDataType {
    STRING("String"),
    NUMBER("Number"),
    DATE_TIME("DateTime"),
    BOOLEAN("Boolean"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AttributeDataType> VALUE_MAP;
    private final String value;

    private AttributeDataType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AttributeDataType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AttributeDataType> knownValues() {
        EnumSet<AttributeDataType> knownValues = EnumSet.allOf(AttributeDataType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AttributeDataType.class, AttributeDataType::toString);
    }
}

