/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeliveryMediumType {
    SMS("SMS"),
    EMAIL("EMAIL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeliveryMediumType> VALUE_MAP;
    private final String value;

    private DeliveryMediumType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeliveryMediumType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeliveryMediumType> knownValues() {
        EnumSet<DeliveryMediumType> knownValues = EnumSet.allOf(DeliveryMediumType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeliveryMediumType.class, DeliveryMediumType::toString);
    }
}

