/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.NotifyEmailType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotifyConfigurationType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotifyConfigurationType> {
    private static final SdkField<String> FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("From").getter(NotifyConfigurationType.getter(NotifyConfigurationType::from)).setter(NotifyConfigurationType.setter(Builder::from)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("From").build()}).build();
    private static final SdkField<String> REPLY_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplyTo").getter(NotifyConfigurationType.getter(NotifyConfigurationType::replyTo)).setter(NotifyConfigurationType.setter(Builder::replyTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplyTo").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(NotifyConfigurationType.getter(NotifyConfigurationType::sourceArn)).setter(NotifyConfigurationType.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<NotifyEmailType> BLOCK_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BlockEmail").getter(NotifyConfigurationType.getter(NotifyConfigurationType::blockEmail)).setter(NotifyConfigurationType.setter(Builder::blockEmail)).constructor(NotifyEmailType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockEmail").build()}).build();
    private static final SdkField<NotifyEmailType> NO_ACTION_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NoActionEmail").getter(NotifyConfigurationType.getter(NotifyConfigurationType::noActionEmail)).setter(NotifyConfigurationType.setter(Builder::noActionEmail)).constructor(NotifyEmailType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoActionEmail").build()}).build();
    private static final SdkField<NotifyEmailType> MFA_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MfaEmail").getter(NotifyConfigurationType.getter(NotifyConfigurationType::mfaEmail)).setter(NotifyConfigurationType.setter(Builder::mfaEmail)).constructor(NotifyEmailType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MfaEmail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_FIELD, REPLY_TO_FIELD, SOURCE_ARN_FIELD, BLOCK_EMAIL_FIELD, NO_ACTION_EMAIL_FIELD, MFA_EMAIL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String from;
    private final String replyTo;
    private final String sourceArn;
    private final NotifyEmailType blockEmail;
    private final NotifyEmailType noActionEmail;
    private final NotifyEmailType mfaEmail;

    private NotifyConfigurationType(BuilderImpl builder) {
        this.from = builder.from;
        this.replyTo = builder.replyTo;
        this.sourceArn = builder.sourceArn;
        this.blockEmail = builder.blockEmail;
        this.noActionEmail = builder.noActionEmail;
        this.mfaEmail = builder.mfaEmail;
    }

    public final String from() {
        return this.from;
    }

    public final String replyTo() {
        return this.replyTo;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final NotifyEmailType blockEmail() {
        return this.blockEmail;
    }

    public final NotifyEmailType noActionEmail() {
        return this.noActionEmail;
    }

    public final NotifyEmailType mfaEmail() {
        return this.mfaEmail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.from());
        hashCode = 31 * hashCode + Objects.hashCode(this.replyTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.noActionEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.mfaEmail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotifyConfigurationType)) {
            return false;
        }
        NotifyConfigurationType other = (NotifyConfigurationType)obj;
        return Objects.equals(this.from(), other.from()) && Objects.equals(this.replyTo(), other.replyTo()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.blockEmail(), other.blockEmail()) && Objects.equals(this.noActionEmail(), other.noActionEmail()) && Objects.equals(this.mfaEmail(), other.mfaEmail());
    }

    public final String toString() {
        return ToString.builder((String)"NotifyConfigurationType").add("From", (Object)this.from()).add("ReplyTo", (Object)this.replyTo()).add("SourceArn", (Object)this.sourceArn()).add("BlockEmail", (Object)this.blockEmail()).add("NoActionEmail", (Object)this.noActionEmail()).add("MfaEmail", (Object)this.mfaEmail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "From": {
                return Optional.ofNullable(clazz.cast(this.from()));
            }
            case "ReplyTo": {
                return Optional.ofNullable(clazz.cast(this.replyTo()));
            }
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "BlockEmail": {
                return Optional.ofNullable(clazz.cast(this.blockEmail()));
            }
            case "NoActionEmail": {
                return Optional.ofNullable(clazz.cast(this.noActionEmail()));
            }
            case "MfaEmail": {
                return Optional.ofNullable(clazz.cast(this.mfaEmail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotifyConfigurationType, T> g) {
        return obj -> g.apply((NotifyConfigurationType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String from;
        private String replyTo;
        private String sourceArn;
        private NotifyEmailType blockEmail;
        private NotifyEmailType noActionEmail;
        private NotifyEmailType mfaEmail;

        private BuilderImpl() {
        }

        private BuilderImpl(NotifyConfigurationType model) {
            this.from(model.from);
            this.replyTo(model.replyTo);
            this.sourceArn(model.sourceArn);
            this.blockEmail(model.blockEmail);
            this.noActionEmail(model.noActionEmail);
            this.mfaEmail(model.mfaEmail);
        }

        public final String getFrom() {
            return this.from;
        }

        public final void setFrom(String from) {
            this.from = from;
        }

        @Override
        @Transient
        public final Builder from(String from) {
            this.from = from;
            return this;
        }

        public final String getReplyTo() {
            return this.replyTo;
        }

        public final void setReplyTo(String replyTo) {
            this.replyTo = replyTo;
        }

        @Override
        @Transient
        public final Builder replyTo(String replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        @Transient
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final NotifyEmailType.Builder getBlockEmail() {
            return this.blockEmail != null ? this.blockEmail.toBuilder() : null;
        }

        public final void setBlockEmail(NotifyEmailType.BuilderImpl blockEmail) {
            this.blockEmail = blockEmail != null ? blockEmail.build() : null;
        }

        @Override
        @Transient
        public final Builder blockEmail(NotifyEmailType blockEmail) {
            this.blockEmail = blockEmail;
            return this;
        }

        public final NotifyEmailType.Builder getNoActionEmail() {
            return this.noActionEmail != null ? this.noActionEmail.toBuilder() : null;
        }

        public final void setNoActionEmail(NotifyEmailType.BuilderImpl noActionEmail) {
            this.noActionEmail = noActionEmail != null ? noActionEmail.build() : null;
        }

        @Override
        @Transient
        public final Builder noActionEmail(NotifyEmailType noActionEmail) {
            this.noActionEmail = noActionEmail;
            return this;
        }

        public final NotifyEmailType.Builder getMfaEmail() {
            return this.mfaEmail != null ? this.mfaEmail.toBuilder() : null;
        }

        public final void setMfaEmail(NotifyEmailType.BuilderImpl mfaEmail) {
            this.mfaEmail = mfaEmail != null ? mfaEmail.build() : null;
        }

        @Override
        @Transient
        public final Builder mfaEmail(NotifyEmailType mfaEmail) {
            this.mfaEmail = mfaEmail;
            return this;
        }

        public NotifyConfigurationType build() {
            return new NotifyConfigurationType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotifyConfigurationType> {
        public Builder from(String var1);

        public Builder replyTo(String var1);

        public Builder sourceArn(String var1);

        public Builder blockEmail(NotifyEmailType var1);

        default public Builder blockEmail(Consumer<NotifyEmailType.Builder> blockEmail) {
            return this.blockEmail((NotifyEmailType)((NotifyEmailType.Builder)NotifyEmailType.builder().applyMutation(blockEmail)).build());
        }

        public Builder noActionEmail(NotifyEmailType var1);

        default public Builder noActionEmail(Consumer<NotifyEmailType.Builder> noActionEmail) {
            return this.noActionEmail((NotifyEmailType)((NotifyEmailType.Builder)NotifyEmailType.builder().applyMutation(noActionEmail)).build());
        }

        public Builder mfaEmail(NotifyEmailType var1);

        default public Builder mfaEmail(Consumer<NotifyEmailType.Builder> mfaEmail) {
            return this.mfaEmail((NotifyEmailType)((NotifyEmailType.Builder)NotifyEmailType.builder().applyMutation(mfaEmail)).build());
        }
    }
}

