/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UsernameAttributeType {
    PHONE_NUMBER("phone_number"),
    EMAIL("email"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UsernameAttributeType> VALUE_MAP;
    private final String value;

    private UsernameAttributeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UsernameAttributeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UsernameAttributeType> knownValues() {
        EnumSet<UsernameAttributeType> knownValues = EnumSet.allOf(UsernameAttributeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UsernameAttributeType.class, UsernameAttributeType::toString);
    }
}

