/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RiskExceptionConfigurationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetRiskConfigurationRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, SetRiskConfigurationRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(SetRiskConfigurationRequest.getter(SetRiskConfigurationRequest::userPoolId)).setter(SetRiskConfigurationRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientId").getter(SetRiskConfigurationRequest.getter(SetRiskConfigurationRequest::clientId)).setter(SetRiskConfigurationRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<CompromisedCredentialsRiskConfigurationType> COMPROMISED_CREDENTIALS_RISK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CompromisedCredentialsRiskConfiguration").getter(SetRiskConfigurationRequest.getter(SetRiskConfigurationRequest::compromisedCredentialsRiskConfiguration)).setter(SetRiskConfigurationRequest.setter(Builder::compromisedCredentialsRiskConfiguration)).constructor(CompromisedCredentialsRiskConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompromisedCredentialsRiskConfiguration").build()}).build();
    private static final SdkField<AccountTakeoverRiskConfigurationType> ACCOUNT_TAKEOVER_RISK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccountTakeoverRiskConfiguration").getter(SetRiskConfigurationRequest.getter(SetRiskConfigurationRequest::accountTakeoverRiskConfiguration)).setter(SetRiskConfigurationRequest.setter(Builder::accountTakeoverRiskConfiguration)).constructor(AccountTakeoverRiskConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountTakeoverRiskConfiguration").build()}).build();
    private static final SdkField<RiskExceptionConfigurationType> RISK_EXCEPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RiskExceptionConfiguration").getter(SetRiskConfigurationRequest.getter(SetRiskConfigurationRequest::riskExceptionConfiguration)).setter(SetRiskConfigurationRequest.setter(Builder::riskExceptionConfiguration)).constructor(RiskExceptionConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskExceptionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, CLIENT_ID_FIELD, COMPROMISED_CREDENTIALS_RISK_CONFIGURATION_FIELD, ACCOUNT_TAKEOVER_RISK_CONFIGURATION_FIELD, RISK_EXCEPTION_CONFIGURATION_FIELD));
    private final String userPoolId;
    private final String clientId;
    private final CompromisedCredentialsRiskConfigurationType compromisedCredentialsRiskConfiguration;
    private final AccountTakeoverRiskConfigurationType accountTakeoverRiskConfiguration;
    private final RiskExceptionConfigurationType riskExceptionConfiguration;

    private SetRiskConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.clientId = builder.clientId;
        this.compromisedCredentialsRiskConfiguration = builder.compromisedCredentialsRiskConfiguration;
        this.accountTakeoverRiskConfiguration = builder.accountTakeoverRiskConfiguration;
        this.riskExceptionConfiguration = builder.riskExceptionConfiguration;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final CompromisedCredentialsRiskConfigurationType compromisedCredentialsRiskConfiguration() {
        return this.compromisedCredentialsRiskConfiguration;
    }

    public final AccountTakeoverRiskConfigurationType accountTakeoverRiskConfiguration() {
        return this.accountTakeoverRiskConfiguration;
    }

    public final RiskExceptionConfigurationType riskExceptionConfiguration() {
        return this.riskExceptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.compromisedCredentialsRiskConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountTakeoverRiskConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.riskExceptionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetRiskConfigurationRequest)) {
            return false;
        }
        SetRiskConfigurationRequest other = (SetRiskConfigurationRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.compromisedCredentialsRiskConfiguration(), other.compromisedCredentialsRiskConfiguration()) && Objects.equals(this.accountTakeoverRiskConfiguration(), other.accountTakeoverRiskConfiguration()) && Objects.equals(this.riskExceptionConfiguration(), other.riskExceptionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"SetRiskConfigurationRequest").add("UserPoolId", (Object)this.userPoolId()).add("ClientId", (Object)(this.clientId() == null ? null : "*** Sensitive Data Redacted ***")).add("CompromisedCredentialsRiskConfiguration", (Object)this.compromisedCredentialsRiskConfiguration()).add("AccountTakeoverRiskConfiguration", (Object)this.accountTakeoverRiskConfiguration()).add("RiskExceptionConfiguration", (Object)this.riskExceptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "CompromisedCredentialsRiskConfiguration": {
                return Optional.ofNullable(clazz.cast(this.compromisedCredentialsRiskConfiguration()));
            }
            case "AccountTakeoverRiskConfiguration": {
                return Optional.ofNullable(clazz.cast(this.accountTakeoverRiskConfiguration()));
            }
            case "RiskExceptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.riskExceptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetRiskConfigurationRequest, T> g) {
        return obj -> g.apply((SetRiskConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private String clientId;
        private CompromisedCredentialsRiskConfigurationType compromisedCredentialsRiskConfiguration;
        private AccountTakeoverRiskConfigurationType accountTakeoverRiskConfiguration;
        private RiskExceptionConfigurationType riskExceptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SetRiskConfigurationRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.clientId(model.clientId);
            this.compromisedCredentialsRiskConfiguration(model.compromisedCredentialsRiskConfiguration);
            this.accountTakeoverRiskConfiguration(model.accountTakeoverRiskConfiguration);
            this.riskExceptionConfiguration(model.riskExceptionConfiguration);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        @Transient
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        @Transient
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final CompromisedCredentialsRiskConfigurationType.Builder getCompromisedCredentialsRiskConfiguration() {
            return this.compromisedCredentialsRiskConfiguration != null ? this.compromisedCredentialsRiskConfiguration.toBuilder() : null;
        }

        public final void setCompromisedCredentialsRiskConfiguration(CompromisedCredentialsRiskConfigurationType.BuilderImpl compromisedCredentialsRiskConfiguration) {
            this.compromisedCredentialsRiskConfiguration = compromisedCredentialsRiskConfiguration != null ? compromisedCredentialsRiskConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder compromisedCredentialsRiskConfiguration(CompromisedCredentialsRiskConfigurationType compromisedCredentialsRiskConfiguration) {
            this.compromisedCredentialsRiskConfiguration = compromisedCredentialsRiskConfiguration;
            return this;
        }

        public final AccountTakeoverRiskConfigurationType.Builder getAccountTakeoverRiskConfiguration() {
            return this.accountTakeoverRiskConfiguration != null ? this.accountTakeoverRiskConfiguration.toBuilder() : null;
        }

        public final void setAccountTakeoverRiskConfiguration(AccountTakeoverRiskConfigurationType.BuilderImpl accountTakeoverRiskConfiguration) {
            this.accountTakeoverRiskConfiguration = accountTakeoverRiskConfiguration != null ? accountTakeoverRiskConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder accountTakeoverRiskConfiguration(AccountTakeoverRiskConfigurationType accountTakeoverRiskConfiguration) {
            this.accountTakeoverRiskConfiguration = accountTakeoverRiskConfiguration;
            return this;
        }

        public final RiskExceptionConfigurationType.Builder getRiskExceptionConfiguration() {
            return this.riskExceptionConfiguration != null ? this.riskExceptionConfiguration.toBuilder() : null;
        }

        public final void setRiskExceptionConfiguration(RiskExceptionConfigurationType.BuilderImpl riskExceptionConfiguration) {
            this.riskExceptionConfiguration = riskExceptionConfiguration != null ? riskExceptionConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder riskExceptionConfiguration(RiskExceptionConfigurationType riskExceptionConfiguration) {
            this.riskExceptionConfiguration = riskExceptionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetRiskConfigurationRequest build() {
            return new SetRiskConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetRiskConfigurationRequest> {
        public Builder userPoolId(String var1);

        public Builder clientId(String var1);

        public Builder compromisedCredentialsRiskConfiguration(CompromisedCredentialsRiskConfigurationType var1);

        default public Builder compromisedCredentialsRiskConfiguration(Consumer<CompromisedCredentialsRiskConfigurationType.Builder> compromisedCredentialsRiskConfiguration) {
            return this.compromisedCredentialsRiskConfiguration((CompromisedCredentialsRiskConfigurationType)((CompromisedCredentialsRiskConfigurationType.Builder)CompromisedCredentialsRiskConfigurationType.builder().applyMutation(compromisedCredentialsRiskConfiguration)).build());
        }

        public Builder accountTakeoverRiskConfiguration(AccountTakeoverRiskConfigurationType var1);

        default public Builder accountTakeoverRiskConfiguration(Consumer<AccountTakeoverRiskConfigurationType.Builder> accountTakeoverRiskConfiguration) {
            return this.accountTakeoverRiskConfiguration((AccountTakeoverRiskConfigurationType)((AccountTakeoverRiskConfigurationType.Builder)AccountTakeoverRiskConfigurationType.builder().applyMutation(accountTakeoverRiskConfiguration)).build());
        }

        public Builder riskExceptionConfiguration(RiskExceptionConfigurationType var1);

        default public Builder riskExceptionConfiguration(Consumer<RiskExceptionConfigurationType.Builder> riskExceptionConfiguration) {
            return this.riskExceptionConfiguration((RiskExceptionConfigurationType)((RiskExceptionConfigurationType.Builder)RiskExceptionConfigurationType.builder().applyMutation(riskExceptionConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

