/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AnalyticsConfigurationType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CallbackURLsListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ClientPermissionListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ExplicitAuthFlowsListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ExplicitAuthFlowsType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LogoutURLsListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.OAuthFlowType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.OAuthFlowsTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PreventUserExistenceErrorTypes;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ScopeListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SupportedIdentityProvidersListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TokenValidityUnitsType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserPoolClientRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, UpdateUserPoolClientRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(UpdateUserPoolClientRequest.getter(UpdateUserPoolClientRequest::userPoolId)).setter(UpdateUserPoolClientRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientId").getter(UpdateUserPoolClientRequest.getter(UpdateUserPoolClientRequest::clientId)).setter(UpdateUserPoolClientRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<String> CLIENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientName").getter(UpdateUserPoolClientRequest.getter(UpdateUserPoolClientRequest::clientName)).setter(UpdateUserPoolClientRequest.setter(Builder::clientName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientName").build()}).build();
    private static final SdkField<Integer> REFRESH_TOKEN_VALIDITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RefreshTokenValidity").getter(UpdateUserPoolClientRequest.getter(UpdateUserPoolClientRequest::refreshTokenValidity)).setter(UpdateUserPoolClientRequest.setter(Builder::refreshTokenValidity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshTokenValidity").build()}).build();
    private static final SdkField<Integer> ACCESS_TOKEN_VALIDITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AccessTokenValidity").getter(UpdateUserPoolClientRequest.getter(UpdateUserPoolClientRequest::accessTokenValidity)).setter(UpdateUserPoolClientRequest.setter(Builder::accessTokenValidity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessTokenValidity").build()}).build();
    private static final SdkField<Integer> ID_TOKEN_VALIDITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IdTokenValidity").getter(UpdateUserPoolClientRequest.getter(UpdateUserPoolClientRequest::idTokenValidity)).setter(UpdateUserPoolClientRequest.setter(Builder::idTokenValidity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdTokenValidity").build()}).build();
    private static final SdkField<TokenValidityUnitsType> TOKEN_VALIDITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TokenValidityUnits").getter(UpdateUserPoolClientRequest.getter(UpdateUserPoolClientRequest::tokenValidityUnits)).setter(UpdateUserPoolClientRequest.setter(Builder::tokenValidityUnits)).constructor(TokenValidityUnitsType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenValidityUnits").build()}).build();
    private static final SdkField<List<String>> READ_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReadAttributes").getter(UpdateUserPoolClientRequest.getter(UpdateUserPoolClientRequest::readAttributes)).setter(UpdateUserPoolClientRequest.setter(Builder::readAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> WRITE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WriteAttributes").getter(UpdateUserPoolClientRequest.getter(UpdateUserPoolClientRequest::writeAttributes)).setter(UpdateUserPoolClientRequest.setter(Builder::writeAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXPLICIT_AUTH_FLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExplicitAuthFlows").getter(UpdateUserPoolClientRequest.getter(UpdateUserPoolClientRequest::explicitAuthFlowsAsStrings)).setter(UpdateUserPoolClientRequest.setter(Builder::explicitAuthFlowsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplicitAuthFlows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_IDENTITY_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedIdentityProviders").getter(UpdateUserPoolClientRequest.getter(UpdateUserPoolClientRequest::supportedIdentityProviders)).setter(UpdateUserPoolClientRequest.setter(Builder::supportedIdentityProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedIdentityProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CALLBACK_UR_LS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CallbackURLs").getter(UpdateUserPoolClientRequest.getter(UpdateUserPoolClientRequest::callbackURLs)).setter(UpdateUserPoolClientRequest.setter(Builder::callbackURLs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackURLs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LOGOUT_UR_LS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogoutURLs").getter(UpdateUserPoolClientRequest.getter(UpdateUserPoolClientRequest::logoutURLs)).setter(UpdateUserPoolClientRequest.setter(Builder::logoutURLs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoutURLs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEFAULT_REDIRECT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultRedirectURI").getter(UpdateUserPoolClientRequest.getter(UpdateUserPoolClientRequest::defaultRedirectURI)).setter(UpdateUserPoolClientRequest.setter(Builder::defaultRedirectURI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRedirectURI").build()}).build();
    private static final SdkField<List<String>> ALLOWED_O_AUTH_FLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedOAuthFlows").getter(UpdateUserPoolClientRequest.getter(UpdateUserPoolClientRequest::allowedOAuthFlowsAsStrings)).setter(UpdateUserPoolClientRequest.setter(Builder::allowedOAuthFlowsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOAuthFlows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_O_AUTH_SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedOAuthScopes").getter(UpdateUserPoolClientRequest.getter(UpdateUserPoolClientRequest::allowedOAuthScopes)).setter(UpdateUserPoolClientRequest.setter(Builder::allowedOAuthScopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOAuthScopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ALLOWED_O_AUTH_FLOWS_USER_POOL_CLIENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowedOAuthFlowsUserPoolClient").getter(UpdateUserPoolClientRequest.getter(UpdateUserPoolClientRequest::allowedOAuthFlowsUserPoolClient)).setter(UpdateUserPoolClientRequest.setter(Builder::allowedOAuthFlowsUserPoolClient)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOAuthFlowsUserPoolClient").build()}).build();
    private static final SdkField<AnalyticsConfigurationType> ANALYTICS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnalyticsConfiguration").getter(UpdateUserPoolClientRequest.getter(UpdateUserPoolClientRequest::analyticsConfiguration)).setter(UpdateUserPoolClientRequest.setter(Builder::analyticsConfiguration)).constructor(AnalyticsConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyticsConfiguration").build()}).build();
    private static final SdkField<String> PREVENT_USER_EXISTENCE_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreventUserExistenceErrors").getter(UpdateUserPoolClientRequest.getter(UpdateUserPoolClientRequest::preventUserExistenceErrorsAsString)).setter(UpdateUserPoolClientRequest.setter(Builder::preventUserExistenceErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreventUserExistenceErrors").build()}).build();
    private static final SdkField<Boolean> ENABLE_TOKEN_REVOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableTokenRevocation").getter(UpdateUserPoolClientRequest.getter(UpdateUserPoolClientRequest::enableTokenRevocation)).setter(UpdateUserPoolClientRequest.setter(Builder::enableTokenRevocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableTokenRevocation").build()}).build();
    private static final SdkField<Boolean> ENABLE_PROPAGATE_ADDITIONAL_USER_CONTEXT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnablePropagateAdditionalUserContextData").getter(UpdateUserPoolClientRequest.getter(UpdateUserPoolClientRequest::enablePropagateAdditionalUserContextData)).setter(UpdateUserPoolClientRequest.setter(Builder::enablePropagateAdditionalUserContextData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePropagateAdditionalUserContextData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, CLIENT_ID_FIELD, CLIENT_NAME_FIELD, REFRESH_TOKEN_VALIDITY_FIELD, ACCESS_TOKEN_VALIDITY_FIELD, ID_TOKEN_VALIDITY_FIELD, TOKEN_VALIDITY_UNITS_FIELD, READ_ATTRIBUTES_FIELD, WRITE_ATTRIBUTES_FIELD, EXPLICIT_AUTH_FLOWS_FIELD, SUPPORTED_IDENTITY_PROVIDERS_FIELD, CALLBACK_UR_LS_FIELD, LOGOUT_UR_LS_FIELD, DEFAULT_REDIRECT_URI_FIELD, ALLOWED_O_AUTH_FLOWS_FIELD, ALLOWED_O_AUTH_SCOPES_FIELD, ALLOWED_O_AUTH_FLOWS_USER_POOL_CLIENT_FIELD, ANALYTICS_CONFIGURATION_FIELD, PREVENT_USER_EXISTENCE_ERRORS_FIELD, ENABLE_TOKEN_REVOCATION_FIELD, ENABLE_PROPAGATE_ADDITIONAL_USER_CONTEXT_DATA_FIELD));
    private final String userPoolId;
    private final String clientId;
    private final String clientName;
    private final Integer refreshTokenValidity;
    private final Integer accessTokenValidity;
    private final Integer idTokenValidity;
    private final TokenValidityUnitsType tokenValidityUnits;
    private final List<String> readAttributes;
    private final List<String> writeAttributes;
    private final List<String> explicitAuthFlows;
    private final List<String> supportedIdentityProviders;
    private final List<String> callbackURLs;
    private final List<String> logoutURLs;
    private final String defaultRedirectURI;
    private final List<String> allowedOAuthFlows;
    private final List<String> allowedOAuthScopes;
    private final Boolean allowedOAuthFlowsUserPoolClient;
    private final AnalyticsConfigurationType analyticsConfiguration;
    private final String preventUserExistenceErrors;
    private final Boolean enableTokenRevocation;
    private final Boolean enablePropagateAdditionalUserContextData;

    private UpdateUserPoolClientRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.clientId = builder.clientId;
        this.clientName = builder.clientName;
        this.refreshTokenValidity = builder.refreshTokenValidity;
        this.accessTokenValidity = builder.accessTokenValidity;
        this.idTokenValidity = builder.idTokenValidity;
        this.tokenValidityUnits = builder.tokenValidityUnits;
        this.readAttributes = builder.readAttributes;
        this.writeAttributes = builder.writeAttributes;
        this.explicitAuthFlows = builder.explicitAuthFlows;
        this.supportedIdentityProviders = builder.supportedIdentityProviders;
        this.callbackURLs = builder.callbackURLs;
        this.logoutURLs = builder.logoutURLs;
        this.defaultRedirectURI = builder.defaultRedirectURI;
        this.allowedOAuthFlows = builder.allowedOAuthFlows;
        this.allowedOAuthScopes = builder.allowedOAuthScopes;
        this.allowedOAuthFlowsUserPoolClient = builder.allowedOAuthFlowsUserPoolClient;
        this.analyticsConfiguration = builder.analyticsConfiguration;
        this.preventUserExistenceErrors = builder.preventUserExistenceErrors;
        this.enableTokenRevocation = builder.enableTokenRevocation;
        this.enablePropagateAdditionalUserContextData = builder.enablePropagateAdditionalUserContextData;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final String clientName() {
        return this.clientName;
    }

    public final Integer refreshTokenValidity() {
        return this.refreshTokenValidity;
    }

    public final Integer accessTokenValidity() {
        return this.accessTokenValidity;
    }

    public final Integer idTokenValidity() {
        return this.idTokenValidity;
    }

    public final TokenValidityUnitsType tokenValidityUnits() {
        return this.tokenValidityUnits;
    }

    public final boolean hasReadAttributes() {
        return this.readAttributes != null && !(this.readAttributes instanceof SdkAutoConstructList);
    }

    public final List<String> readAttributes() {
        return this.readAttributes;
    }

    public final boolean hasWriteAttributes() {
        return this.writeAttributes != null && !(this.writeAttributes instanceof SdkAutoConstructList);
    }

    public final List<String> writeAttributes() {
        return this.writeAttributes;
    }

    public final List<ExplicitAuthFlowsType> explicitAuthFlows() {
        return ExplicitAuthFlowsListTypeCopier.copyStringToEnum(this.explicitAuthFlows);
    }

    public final boolean hasExplicitAuthFlows() {
        return this.explicitAuthFlows != null && !(this.explicitAuthFlows instanceof SdkAutoConstructList);
    }

    public final List<String> explicitAuthFlowsAsStrings() {
        return this.explicitAuthFlows;
    }

    public final boolean hasSupportedIdentityProviders() {
        return this.supportedIdentityProviders != null && !(this.supportedIdentityProviders instanceof SdkAutoConstructList);
    }

    public final List<String> supportedIdentityProviders() {
        return this.supportedIdentityProviders;
    }

    public final boolean hasCallbackURLs() {
        return this.callbackURLs != null && !(this.callbackURLs instanceof SdkAutoConstructList);
    }

    public final List<String> callbackURLs() {
        return this.callbackURLs;
    }

    public final boolean hasLogoutURLs() {
        return this.logoutURLs != null && !(this.logoutURLs instanceof SdkAutoConstructList);
    }

    public final List<String> logoutURLs() {
        return this.logoutURLs;
    }

    public final String defaultRedirectURI() {
        return this.defaultRedirectURI;
    }

    public final List<OAuthFlowType> allowedOAuthFlows() {
        return OAuthFlowsTypeCopier.copyStringToEnum(this.allowedOAuthFlows);
    }

    public final boolean hasAllowedOAuthFlows() {
        return this.allowedOAuthFlows != null && !(this.allowedOAuthFlows instanceof SdkAutoConstructList);
    }

    public final List<String> allowedOAuthFlowsAsStrings() {
        return this.allowedOAuthFlows;
    }

    public final boolean hasAllowedOAuthScopes() {
        return this.allowedOAuthScopes != null && !(this.allowedOAuthScopes instanceof SdkAutoConstructList);
    }

    public final List<String> allowedOAuthScopes() {
        return this.allowedOAuthScopes;
    }

    public final Boolean allowedOAuthFlowsUserPoolClient() {
        return this.allowedOAuthFlowsUserPoolClient;
    }

    public final AnalyticsConfigurationType analyticsConfiguration() {
        return this.analyticsConfiguration;
    }

    public final PreventUserExistenceErrorTypes preventUserExistenceErrors() {
        return PreventUserExistenceErrorTypes.fromValue(this.preventUserExistenceErrors);
    }

    public final String preventUserExistenceErrorsAsString() {
        return this.preventUserExistenceErrors;
    }

    public final Boolean enableTokenRevocation() {
        return this.enableTokenRevocation;
    }

    public final Boolean enablePropagateAdditionalUserContextData() {
        return this.enablePropagateAdditionalUserContextData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientName());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshTokenValidity());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessTokenValidity());
        hashCode = 31 * hashCode + Objects.hashCode(this.idTokenValidity());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenValidityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReadAttributes() ? this.readAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWriteAttributes() ? this.writeAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExplicitAuthFlows() ? this.explicitAuthFlowsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedIdentityProviders() ? this.supportedIdentityProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCallbackURLs() ? this.callbackURLs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogoutURLs() ? this.logoutURLs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRedirectURI());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedOAuthFlows() ? this.allowedOAuthFlowsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedOAuthScopes() ? this.allowedOAuthScopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedOAuthFlowsUserPoolClient());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyticsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.preventUserExistenceErrorsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableTokenRevocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePropagateAdditionalUserContextData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserPoolClientRequest)) {
            return false;
        }
        UpdateUserPoolClientRequest other = (UpdateUserPoolClientRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.clientName(), other.clientName()) && Objects.equals(this.refreshTokenValidity(), other.refreshTokenValidity()) && Objects.equals(this.accessTokenValidity(), other.accessTokenValidity()) && Objects.equals(this.idTokenValidity(), other.idTokenValidity()) && Objects.equals(this.tokenValidityUnits(), other.tokenValidityUnits()) && this.hasReadAttributes() == other.hasReadAttributes() && Objects.equals(this.readAttributes(), other.readAttributes()) && this.hasWriteAttributes() == other.hasWriteAttributes() && Objects.equals(this.writeAttributes(), other.writeAttributes()) && this.hasExplicitAuthFlows() == other.hasExplicitAuthFlows() && Objects.equals(this.explicitAuthFlowsAsStrings(), other.explicitAuthFlowsAsStrings()) && this.hasSupportedIdentityProviders() == other.hasSupportedIdentityProviders() && Objects.equals(this.supportedIdentityProviders(), other.supportedIdentityProviders()) && this.hasCallbackURLs() == other.hasCallbackURLs() && Objects.equals(this.callbackURLs(), other.callbackURLs()) && this.hasLogoutURLs() == other.hasLogoutURLs() && Objects.equals(this.logoutURLs(), other.logoutURLs()) && Objects.equals(this.defaultRedirectURI(), other.defaultRedirectURI()) && this.hasAllowedOAuthFlows() == other.hasAllowedOAuthFlows() && Objects.equals(this.allowedOAuthFlowsAsStrings(), other.allowedOAuthFlowsAsStrings()) && this.hasAllowedOAuthScopes() == other.hasAllowedOAuthScopes() && Objects.equals(this.allowedOAuthScopes(), other.allowedOAuthScopes()) && Objects.equals(this.allowedOAuthFlowsUserPoolClient(), other.allowedOAuthFlowsUserPoolClient()) && Objects.equals(this.analyticsConfiguration(), other.analyticsConfiguration()) && Objects.equals(this.preventUserExistenceErrorsAsString(), other.preventUserExistenceErrorsAsString()) && Objects.equals(this.enableTokenRevocation(), other.enableTokenRevocation()) && Objects.equals(this.enablePropagateAdditionalUserContextData(), other.enablePropagateAdditionalUserContextData());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateUserPoolClientRequest").add("UserPoolId", (Object)this.userPoolId()).add("ClientId", (Object)(this.clientId() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientName", (Object)this.clientName()).add("RefreshTokenValidity", (Object)this.refreshTokenValidity()).add("AccessTokenValidity", (Object)this.accessTokenValidity()).add("IdTokenValidity", (Object)this.idTokenValidity()).add("TokenValidityUnits", (Object)this.tokenValidityUnits()).add("ReadAttributes", this.hasReadAttributes() ? this.readAttributes() : null).add("WriteAttributes", this.hasWriteAttributes() ? this.writeAttributes() : null).add("ExplicitAuthFlows", this.hasExplicitAuthFlows() ? this.explicitAuthFlowsAsStrings() : null).add("SupportedIdentityProviders", this.hasSupportedIdentityProviders() ? this.supportedIdentityProviders() : null).add("CallbackURLs", this.hasCallbackURLs() ? this.callbackURLs() : null).add("LogoutURLs", this.hasLogoutURLs() ? this.logoutURLs() : null).add("DefaultRedirectURI", (Object)this.defaultRedirectURI()).add("AllowedOAuthFlows", this.hasAllowedOAuthFlows() ? this.allowedOAuthFlowsAsStrings() : null).add("AllowedOAuthScopes", this.hasAllowedOAuthScopes() ? this.allowedOAuthScopes() : null).add("AllowedOAuthFlowsUserPoolClient", (Object)this.allowedOAuthFlowsUserPoolClient()).add("AnalyticsConfiguration", (Object)this.analyticsConfiguration()).add("PreventUserExistenceErrors", (Object)this.preventUserExistenceErrorsAsString()).add("EnableTokenRevocation", (Object)this.enableTokenRevocation()).add("EnablePropagateAdditionalUserContextData", (Object)this.enablePropagateAdditionalUserContextData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "ClientName": {
                return Optional.ofNullable(clazz.cast(this.clientName()));
            }
            case "RefreshTokenValidity": {
                return Optional.ofNullable(clazz.cast(this.refreshTokenValidity()));
            }
            case "AccessTokenValidity": {
                return Optional.ofNullable(clazz.cast(this.accessTokenValidity()));
            }
            case "IdTokenValidity": {
                return Optional.ofNullable(clazz.cast(this.idTokenValidity()));
            }
            case "TokenValidityUnits": {
                return Optional.ofNullable(clazz.cast(this.tokenValidityUnits()));
            }
            case "ReadAttributes": {
                return Optional.ofNullable(clazz.cast(this.readAttributes()));
            }
            case "WriteAttributes": {
                return Optional.ofNullable(clazz.cast(this.writeAttributes()));
            }
            case "ExplicitAuthFlows": {
                return Optional.ofNullable(clazz.cast(this.explicitAuthFlowsAsStrings()));
            }
            case "SupportedIdentityProviders": {
                return Optional.ofNullable(clazz.cast(this.supportedIdentityProviders()));
            }
            case "CallbackURLs": {
                return Optional.ofNullable(clazz.cast(this.callbackURLs()));
            }
            case "LogoutURLs": {
                return Optional.ofNullable(clazz.cast(this.logoutURLs()));
            }
            case "DefaultRedirectURI": {
                return Optional.ofNullable(clazz.cast(this.defaultRedirectURI()));
            }
            case "AllowedOAuthFlows": {
                return Optional.ofNullable(clazz.cast(this.allowedOAuthFlowsAsStrings()));
            }
            case "AllowedOAuthScopes": {
                return Optional.ofNullable(clazz.cast(this.allowedOAuthScopes()));
            }
            case "AllowedOAuthFlowsUserPoolClient": {
                return Optional.ofNullable(clazz.cast(this.allowedOAuthFlowsUserPoolClient()));
            }
            case "AnalyticsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.analyticsConfiguration()));
            }
            case "PreventUserExistenceErrors": {
                return Optional.ofNullable(clazz.cast(this.preventUserExistenceErrorsAsString()));
            }
            case "EnableTokenRevocation": {
                return Optional.ofNullable(clazz.cast(this.enableTokenRevocation()));
            }
            case "EnablePropagateAdditionalUserContextData": {
                return Optional.ofNullable(clazz.cast(this.enablePropagateAdditionalUserContextData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserPoolClientRequest, T> g) {
        return obj -> g.apply((UpdateUserPoolClientRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private String clientId;
        private String clientName;
        private Integer refreshTokenValidity;
        private Integer accessTokenValidity;
        private Integer idTokenValidity;
        private TokenValidityUnitsType tokenValidityUnits;
        private List<String> readAttributes = DefaultSdkAutoConstructList.getInstance();
        private List<String> writeAttributes = DefaultSdkAutoConstructList.getInstance();
        private List<String> explicitAuthFlows = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedIdentityProviders = DefaultSdkAutoConstructList.getInstance();
        private List<String> callbackURLs = DefaultSdkAutoConstructList.getInstance();
        private List<String> logoutURLs = DefaultSdkAutoConstructList.getInstance();
        private String defaultRedirectURI;
        private List<String> allowedOAuthFlows = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedOAuthScopes = DefaultSdkAutoConstructList.getInstance();
        private Boolean allowedOAuthFlowsUserPoolClient;
        private AnalyticsConfigurationType analyticsConfiguration;
        private String preventUserExistenceErrors;
        private Boolean enableTokenRevocation;
        private Boolean enablePropagateAdditionalUserContextData;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserPoolClientRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.clientId(model.clientId);
            this.clientName(model.clientName);
            this.refreshTokenValidity(model.refreshTokenValidity);
            this.accessTokenValidity(model.accessTokenValidity);
            this.idTokenValidity(model.idTokenValidity);
            this.tokenValidityUnits(model.tokenValidityUnits);
            this.readAttributes(model.readAttributes);
            this.writeAttributes(model.writeAttributes);
            this.explicitAuthFlowsWithStrings(model.explicitAuthFlows);
            this.supportedIdentityProviders(model.supportedIdentityProviders);
            this.callbackURLs(model.callbackURLs);
            this.logoutURLs(model.logoutURLs);
            this.defaultRedirectURI(model.defaultRedirectURI);
            this.allowedOAuthFlowsWithStrings(model.allowedOAuthFlows);
            this.allowedOAuthScopes(model.allowedOAuthScopes);
            this.allowedOAuthFlowsUserPoolClient(model.allowedOAuthFlowsUserPoolClient);
            this.analyticsConfiguration(model.analyticsConfiguration);
            this.preventUserExistenceErrors(model.preventUserExistenceErrors);
            this.enableTokenRevocation(model.enableTokenRevocation);
            this.enablePropagateAdditionalUserContextData(model.enablePropagateAdditionalUserContextData);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getClientName() {
            return this.clientName;
        }

        public final void setClientName(String clientName) {
            this.clientName = clientName;
        }

        @Override
        public final Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public final Integer getRefreshTokenValidity() {
            return this.refreshTokenValidity;
        }

        public final void setRefreshTokenValidity(Integer refreshTokenValidity) {
            this.refreshTokenValidity = refreshTokenValidity;
        }

        @Override
        public final Builder refreshTokenValidity(Integer refreshTokenValidity) {
            this.refreshTokenValidity = refreshTokenValidity;
            return this;
        }

        public final Integer getAccessTokenValidity() {
            return this.accessTokenValidity;
        }

        public final void setAccessTokenValidity(Integer accessTokenValidity) {
            this.accessTokenValidity = accessTokenValidity;
        }

        @Override
        public final Builder accessTokenValidity(Integer accessTokenValidity) {
            this.accessTokenValidity = accessTokenValidity;
            return this;
        }

        public final Integer getIdTokenValidity() {
            return this.idTokenValidity;
        }

        public final void setIdTokenValidity(Integer idTokenValidity) {
            this.idTokenValidity = idTokenValidity;
        }

        @Override
        public final Builder idTokenValidity(Integer idTokenValidity) {
            this.idTokenValidity = idTokenValidity;
            return this;
        }

        public final TokenValidityUnitsType.Builder getTokenValidityUnits() {
            return this.tokenValidityUnits != null ? this.tokenValidityUnits.toBuilder() : null;
        }

        public final void setTokenValidityUnits(TokenValidityUnitsType.BuilderImpl tokenValidityUnits) {
            this.tokenValidityUnits = tokenValidityUnits != null ? tokenValidityUnits.build() : null;
        }

        @Override
        public final Builder tokenValidityUnits(TokenValidityUnitsType tokenValidityUnits) {
            this.tokenValidityUnits = tokenValidityUnits;
            return this;
        }

        public final Collection<String> getReadAttributes() {
            if (this.readAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.readAttributes;
        }

        public final void setReadAttributes(Collection<String> readAttributes) {
            this.readAttributes = ClientPermissionListTypeCopier.copy(readAttributes);
        }

        @Override
        public final Builder readAttributes(Collection<String> readAttributes) {
            this.readAttributes = ClientPermissionListTypeCopier.copy(readAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readAttributes(String ... readAttributes) {
            this.readAttributes(Arrays.asList(readAttributes));
            return this;
        }

        public final Collection<String> getWriteAttributes() {
            if (this.writeAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.writeAttributes;
        }

        public final void setWriteAttributes(Collection<String> writeAttributes) {
            this.writeAttributes = ClientPermissionListTypeCopier.copy(writeAttributes);
        }

        @Override
        public final Builder writeAttributes(Collection<String> writeAttributes) {
            this.writeAttributes = ClientPermissionListTypeCopier.copy(writeAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder writeAttributes(String ... writeAttributes) {
            this.writeAttributes(Arrays.asList(writeAttributes));
            return this;
        }

        public final Collection<String> getExplicitAuthFlows() {
            if (this.explicitAuthFlows instanceof SdkAutoConstructList) {
                return null;
            }
            return this.explicitAuthFlows;
        }

        public final void setExplicitAuthFlows(Collection<String> explicitAuthFlows) {
            this.explicitAuthFlows = ExplicitAuthFlowsListTypeCopier.copy(explicitAuthFlows);
        }

        @Override
        public final Builder explicitAuthFlowsWithStrings(Collection<String> explicitAuthFlows) {
            this.explicitAuthFlows = ExplicitAuthFlowsListTypeCopier.copy(explicitAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explicitAuthFlowsWithStrings(String ... explicitAuthFlows) {
            this.explicitAuthFlowsWithStrings(Arrays.asList(explicitAuthFlows));
            return this;
        }

        @Override
        public final Builder explicitAuthFlows(Collection<ExplicitAuthFlowsType> explicitAuthFlows) {
            this.explicitAuthFlows = ExplicitAuthFlowsListTypeCopier.copyEnumToString(explicitAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explicitAuthFlows(ExplicitAuthFlowsType ... explicitAuthFlows) {
            this.explicitAuthFlows(Arrays.asList(explicitAuthFlows));
            return this;
        }

        public final Collection<String> getSupportedIdentityProviders() {
            if (this.supportedIdentityProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedIdentityProviders;
        }

        public final void setSupportedIdentityProviders(Collection<String> supportedIdentityProviders) {
            this.supportedIdentityProviders = SupportedIdentityProvidersListTypeCopier.copy(supportedIdentityProviders);
        }

        @Override
        public final Builder supportedIdentityProviders(Collection<String> supportedIdentityProviders) {
            this.supportedIdentityProviders = SupportedIdentityProvidersListTypeCopier.copy(supportedIdentityProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedIdentityProviders(String ... supportedIdentityProviders) {
            this.supportedIdentityProviders(Arrays.asList(supportedIdentityProviders));
            return this;
        }

        public final Collection<String> getCallbackURLs() {
            if (this.callbackURLs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.callbackURLs;
        }

        public final void setCallbackURLs(Collection<String> callbackURLs) {
            this.callbackURLs = CallbackURLsListTypeCopier.copy(callbackURLs);
        }

        @Override
        public final Builder callbackURLs(Collection<String> callbackURLs) {
            this.callbackURLs = CallbackURLsListTypeCopier.copy(callbackURLs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callbackURLs(String ... callbackURLs) {
            this.callbackURLs(Arrays.asList(callbackURLs));
            return this;
        }

        public final Collection<String> getLogoutURLs() {
            if (this.logoutURLs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logoutURLs;
        }

        public final void setLogoutURLs(Collection<String> logoutURLs) {
            this.logoutURLs = LogoutURLsListTypeCopier.copy(logoutURLs);
        }

        @Override
        public final Builder logoutURLs(Collection<String> logoutURLs) {
            this.logoutURLs = LogoutURLsListTypeCopier.copy(logoutURLs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logoutURLs(String ... logoutURLs) {
            this.logoutURLs(Arrays.asList(logoutURLs));
            return this;
        }

        public final String getDefaultRedirectURI() {
            return this.defaultRedirectURI;
        }

        public final void setDefaultRedirectURI(String defaultRedirectURI) {
            this.defaultRedirectURI = defaultRedirectURI;
        }

        @Override
        public final Builder defaultRedirectURI(String defaultRedirectURI) {
            this.defaultRedirectURI = defaultRedirectURI;
            return this;
        }

        public final Collection<String> getAllowedOAuthFlows() {
            if (this.allowedOAuthFlows instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedOAuthFlows;
        }

        public final void setAllowedOAuthFlows(Collection<String> allowedOAuthFlows) {
            this.allowedOAuthFlows = OAuthFlowsTypeCopier.copy(allowedOAuthFlows);
        }

        @Override
        public final Builder allowedOAuthFlowsWithStrings(Collection<String> allowedOAuthFlows) {
            this.allowedOAuthFlows = OAuthFlowsTypeCopier.copy(allowedOAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOAuthFlowsWithStrings(String ... allowedOAuthFlows) {
            this.allowedOAuthFlowsWithStrings(Arrays.asList(allowedOAuthFlows));
            return this;
        }

        @Override
        public final Builder allowedOAuthFlows(Collection<OAuthFlowType> allowedOAuthFlows) {
            this.allowedOAuthFlows = OAuthFlowsTypeCopier.copyEnumToString(allowedOAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOAuthFlows(OAuthFlowType ... allowedOAuthFlows) {
            this.allowedOAuthFlows(Arrays.asList(allowedOAuthFlows));
            return this;
        }

        public final Collection<String> getAllowedOAuthScopes() {
            if (this.allowedOAuthScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedOAuthScopes;
        }

        public final void setAllowedOAuthScopes(Collection<String> allowedOAuthScopes) {
            this.allowedOAuthScopes = ScopeListTypeCopier.copy(allowedOAuthScopes);
        }

        @Override
        public final Builder allowedOAuthScopes(Collection<String> allowedOAuthScopes) {
            this.allowedOAuthScopes = ScopeListTypeCopier.copy(allowedOAuthScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOAuthScopes(String ... allowedOAuthScopes) {
            this.allowedOAuthScopes(Arrays.asList(allowedOAuthScopes));
            return this;
        }

        public final Boolean getAllowedOAuthFlowsUserPoolClient() {
            return this.allowedOAuthFlowsUserPoolClient;
        }

        public final void setAllowedOAuthFlowsUserPoolClient(Boolean allowedOAuthFlowsUserPoolClient) {
            this.allowedOAuthFlowsUserPoolClient = allowedOAuthFlowsUserPoolClient;
        }

        @Override
        public final Builder allowedOAuthFlowsUserPoolClient(Boolean allowedOAuthFlowsUserPoolClient) {
            this.allowedOAuthFlowsUserPoolClient = allowedOAuthFlowsUserPoolClient;
            return this;
        }

        public final AnalyticsConfigurationType.Builder getAnalyticsConfiguration() {
            return this.analyticsConfiguration != null ? this.analyticsConfiguration.toBuilder() : null;
        }

        public final void setAnalyticsConfiguration(AnalyticsConfigurationType.BuilderImpl analyticsConfiguration) {
            this.analyticsConfiguration = analyticsConfiguration != null ? analyticsConfiguration.build() : null;
        }

        @Override
        public final Builder analyticsConfiguration(AnalyticsConfigurationType analyticsConfiguration) {
            this.analyticsConfiguration = analyticsConfiguration;
            return this;
        }

        public final String getPreventUserExistenceErrors() {
            return this.preventUserExistenceErrors;
        }

        public final void setPreventUserExistenceErrors(String preventUserExistenceErrors) {
            this.preventUserExistenceErrors = preventUserExistenceErrors;
        }

        @Override
        public final Builder preventUserExistenceErrors(String preventUserExistenceErrors) {
            this.preventUserExistenceErrors = preventUserExistenceErrors;
            return this;
        }

        @Override
        public final Builder preventUserExistenceErrors(PreventUserExistenceErrorTypes preventUserExistenceErrors) {
            this.preventUserExistenceErrors(preventUserExistenceErrors == null ? null : preventUserExistenceErrors.toString());
            return this;
        }

        public final Boolean getEnableTokenRevocation() {
            return this.enableTokenRevocation;
        }

        public final void setEnableTokenRevocation(Boolean enableTokenRevocation) {
            this.enableTokenRevocation = enableTokenRevocation;
        }

        @Override
        public final Builder enableTokenRevocation(Boolean enableTokenRevocation) {
            this.enableTokenRevocation = enableTokenRevocation;
            return this;
        }

        public final Boolean getEnablePropagateAdditionalUserContextData() {
            return this.enablePropagateAdditionalUserContextData;
        }

        public final void setEnablePropagateAdditionalUserContextData(Boolean enablePropagateAdditionalUserContextData) {
            this.enablePropagateAdditionalUserContextData = enablePropagateAdditionalUserContextData;
        }

        @Override
        public final Builder enablePropagateAdditionalUserContextData(Boolean enablePropagateAdditionalUserContextData) {
            this.enablePropagateAdditionalUserContextData = enablePropagateAdditionalUserContextData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserPoolClientRequest build() {
            return new UpdateUserPoolClientRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUserPoolClientRequest> {
        public Builder userPoolId(String var1);

        public Builder clientId(String var1);

        public Builder clientName(String var1);

        public Builder refreshTokenValidity(Integer var1);

        public Builder accessTokenValidity(Integer var1);

        public Builder idTokenValidity(Integer var1);

        public Builder tokenValidityUnits(TokenValidityUnitsType var1);

        default public Builder tokenValidityUnits(Consumer<TokenValidityUnitsType.Builder> tokenValidityUnits) {
            return this.tokenValidityUnits((TokenValidityUnitsType)((TokenValidityUnitsType.Builder)TokenValidityUnitsType.builder().applyMutation(tokenValidityUnits)).build());
        }

        public Builder readAttributes(Collection<String> var1);

        public Builder readAttributes(String ... var1);

        public Builder writeAttributes(Collection<String> var1);

        public Builder writeAttributes(String ... var1);

        public Builder explicitAuthFlowsWithStrings(Collection<String> var1);

        public Builder explicitAuthFlowsWithStrings(String ... var1);

        public Builder explicitAuthFlows(Collection<ExplicitAuthFlowsType> var1);

        public Builder explicitAuthFlows(ExplicitAuthFlowsType ... var1);

        public Builder supportedIdentityProviders(Collection<String> var1);

        public Builder supportedIdentityProviders(String ... var1);

        public Builder callbackURLs(Collection<String> var1);

        public Builder callbackURLs(String ... var1);

        public Builder logoutURLs(Collection<String> var1);

        public Builder logoutURLs(String ... var1);

        public Builder defaultRedirectURI(String var1);

        public Builder allowedOAuthFlowsWithStrings(Collection<String> var1);

        public Builder allowedOAuthFlowsWithStrings(String ... var1);

        public Builder allowedOAuthFlows(Collection<OAuthFlowType> var1);

        public Builder allowedOAuthFlows(OAuthFlowType ... var1);

        public Builder allowedOAuthScopes(Collection<String> var1);

        public Builder allowedOAuthScopes(String ... var1);

        public Builder allowedOAuthFlowsUserPoolClient(Boolean var1);

        public Builder analyticsConfiguration(AnalyticsConfigurationType var1);

        default public Builder analyticsConfiguration(Consumer<AnalyticsConfigurationType.Builder> analyticsConfiguration) {
            return this.analyticsConfiguration((AnalyticsConfigurationType)((AnalyticsConfigurationType.Builder)AnalyticsConfigurationType.builder().applyMutation(analyticsConfiguration)).build());
        }

        public Builder preventUserExistenceErrors(String var1);

        public Builder preventUserExistenceErrors(PreventUserExistenceErrorTypes var1);

        public Builder enableTokenRevocation(Boolean var1);

        public Builder enablePropagateAdditionalUserContextData(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

