/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifyUserAttributeRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, VerifyUserAttributeRequest> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessToken").getter(VerifyUserAttributeRequest.getter(VerifyUserAttributeRequest::accessToken)).setter(VerifyUserAttributeRequest.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()}).build();
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeName").getter(VerifyUserAttributeRequest.getter(VerifyUserAttributeRequest::attributeName)).setter(VerifyUserAttributeRequest.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()}).build();
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Code").getter(VerifyUserAttributeRequest.getter(VerifyUserAttributeRequest::code)).setter(VerifyUserAttributeRequest.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD, ATTRIBUTE_NAME_FIELD, CODE_FIELD));
    private final String accessToken;
    private final String attributeName;
    private final String code;

    private VerifyUserAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.attributeName = builder.attributeName;
        this.code = builder.code;
    }

    public final String accessToken() {
        return this.accessToken;
    }

    public final String attributeName() {
        return this.attributeName;
    }

    public final String code() {
        return this.code;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyUserAttributeRequest)) {
            return false;
        }
        VerifyUserAttributeRequest other = (VerifyUserAttributeRequest)((Object)obj);
        return Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.code(), other.code());
    }

    public final String toString() {
        return ToString.builder((String)"VerifyUserAttributeRequest").add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).add("AttributeName", (Object)this.attributeName()).add("Code", (Object)this.code()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyUserAttributeRequest, T> g) {
        return obj -> g.apply((VerifyUserAttributeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String accessToken;
        private String attributeName;
        private String code;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyUserAttributeRequest model) {
            super(model);
            this.accessToken(model.accessToken);
            this.attributeName(model.attributeName);
            this.code(model.code);
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        @Transient
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        @Transient
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        @Transient
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifyUserAttributeRequest build() {
            return new VerifyUserAttributeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, VerifyUserAttributeRequest> {
        public Builder accessToken(String var1);

        public Builder attributeName(String var1);

        public Builder code(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

