/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventResponseType {
    SUCCESS("Success"),
    FAILURE("Failure"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventResponseType> VALUE_MAP;
    private final String value;

    private EventResponseType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventResponseType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventResponseType> knownValues() {
        EnumSet<EventResponseType> knownValues = EnumSet.allOf(EventResponseType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventResponseType.class, EventResponseType::toString);
    }
}

