/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AccountRecoverySettingType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserConfigType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceConfigurationType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EmailConfigurationType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LambdaConfigType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SmsConfigurationType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolAddOnsType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolMfaType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolPolicyType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolTagsTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerificationMessageTemplateType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifiedAttributeType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifiedAttributesListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserPoolRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, UpdateUserPoolRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(UpdateUserPoolRequest.getter(UpdateUserPoolRequest::userPoolId)).setter(UpdateUserPoolRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<UserPoolPolicyType> POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Policies").getter(UpdateUserPoolRequest.getter(UpdateUserPoolRequest::policies)).setter(UpdateUserPoolRequest.setter(Builder::policies)).constructor(UserPoolPolicyType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build()}).build();
    private static final SdkField<LambdaConfigType> LAMBDA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LambdaConfig").getter(UpdateUserPoolRequest.getter(UpdateUserPoolRequest::lambdaConfig)).setter(UpdateUserPoolRequest.setter(Builder::lambdaConfig)).constructor(LambdaConfigType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaConfig").build()}).build();
    private static final SdkField<List<String>> AUTO_VERIFIED_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AutoVerifiedAttributes").getter(UpdateUserPoolRequest.getter(UpdateUserPoolRequest::autoVerifiedAttributesAsStrings)).setter(UpdateUserPoolRequest.setter(Builder::autoVerifiedAttributesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoVerifiedAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SMS_VERIFICATION_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SmsVerificationMessage").getter(UpdateUserPoolRequest.getter(UpdateUserPoolRequest::smsVerificationMessage)).setter(UpdateUserPoolRequest.setter(Builder::smsVerificationMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsVerificationMessage").build()}).build();
    private static final SdkField<String> EMAIL_VERIFICATION_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailVerificationMessage").getter(UpdateUserPoolRequest.getter(UpdateUserPoolRequest::emailVerificationMessage)).setter(UpdateUserPoolRequest.setter(Builder::emailVerificationMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailVerificationMessage").build()}).build();
    private static final SdkField<String> EMAIL_VERIFICATION_SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailVerificationSubject").getter(UpdateUserPoolRequest.getter(UpdateUserPoolRequest::emailVerificationSubject)).setter(UpdateUserPoolRequest.setter(Builder::emailVerificationSubject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailVerificationSubject").build()}).build();
    private static final SdkField<VerificationMessageTemplateType> VERIFICATION_MESSAGE_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VerificationMessageTemplate").getter(UpdateUserPoolRequest.getter(UpdateUserPoolRequest::verificationMessageTemplate)).setter(UpdateUserPoolRequest.setter(Builder::verificationMessageTemplate)).constructor(VerificationMessageTemplateType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationMessageTemplate").build()}).build();
    private static final SdkField<String> SMS_AUTHENTICATION_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SmsAuthenticationMessage").getter(UpdateUserPoolRequest.getter(UpdateUserPoolRequest::smsAuthenticationMessage)).setter(UpdateUserPoolRequest.setter(Builder::smsAuthenticationMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsAuthenticationMessage").build()}).build();
    private static final SdkField<String> MFA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MfaConfiguration").getter(UpdateUserPoolRequest.getter(UpdateUserPoolRequest::mfaConfigurationAsString)).setter(UpdateUserPoolRequest.setter(Builder::mfaConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MfaConfiguration").build()}).build();
    private static final SdkField<DeviceConfigurationType> DEVICE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceConfiguration").getter(UpdateUserPoolRequest.getter(UpdateUserPoolRequest::deviceConfiguration)).setter(UpdateUserPoolRequest.setter(Builder::deviceConfiguration)).constructor(DeviceConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceConfiguration").build()}).build();
    private static final SdkField<EmailConfigurationType> EMAIL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmailConfiguration").getter(UpdateUserPoolRequest.getter(UpdateUserPoolRequest::emailConfiguration)).setter(UpdateUserPoolRequest.setter(Builder::emailConfiguration)).constructor(EmailConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailConfiguration").build()}).build();
    private static final SdkField<SmsConfigurationType> SMS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SmsConfiguration").getter(UpdateUserPoolRequest.getter(UpdateUserPoolRequest::smsConfiguration)).setter(UpdateUserPoolRequest.setter(Builder::smsConfiguration)).constructor(SmsConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> USER_POOL_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("UserPoolTags").getter(UpdateUserPoolRequest.getter(UpdateUserPoolRequest::userPoolTags)).setter(UpdateUserPoolRequest.setter(Builder::userPoolTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AdminCreateUserConfigType> ADMIN_CREATE_USER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdminCreateUserConfig").getter(UpdateUserPoolRequest.getter(UpdateUserPoolRequest::adminCreateUserConfig)).setter(UpdateUserPoolRequest.setter(Builder::adminCreateUserConfig)).constructor(AdminCreateUserConfigType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminCreateUserConfig").build()}).build();
    private static final SdkField<UserPoolAddOnsType> USER_POOL_ADD_ONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserPoolAddOns").getter(UpdateUserPoolRequest.getter(UpdateUserPoolRequest::userPoolAddOns)).setter(UpdateUserPoolRequest.setter(Builder::userPoolAddOns)).constructor(UserPoolAddOnsType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolAddOns").build()}).build();
    private static final SdkField<AccountRecoverySettingType> ACCOUNT_RECOVERY_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccountRecoverySetting").getter(UpdateUserPoolRequest.getter(UpdateUserPoolRequest::accountRecoverySetting)).setter(UpdateUserPoolRequest.setter(Builder::accountRecoverySetting)).constructor(AccountRecoverySettingType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountRecoverySetting").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, POLICIES_FIELD, LAMBDA_CONFIG_FIELD, AUTO_VERIFIED_ATTRIBUTES_FIELD, SMS_VERIFICATION_MESSAGE_FIELD, EMAIL_VERIFICATION_MESSAGE_FIELD, EMAIL_VERIFICATION_SUBJECT_FIELD, VERIFICATION_MESSAGE_TEMPLATE_FIELD, SMS_AUTHENTICATION_MESSAGE_FIELD, MFA_CONFIGURATION_FIELD, DEVICE_CONFIGURATION_FIELD, EMAIL_CONFIGURATION_FIELD, SMS_CONFIGURATION_FIELD, USER_POOL_TAGS_FIELD, ADMIN_CREATE_USER_CONFIG_FIELD, USER_POOL_ADD_ONS_FIELD, ACCOUNT_RECOVERY_SETTING_FIELD));
    private final String userPoolId;
    private final UserPoolPolicyType policies;
    private final LambdaConfigType lambdaConfig;
    private final List<String> autoVerifiedAttributes;
    private final String smsVerificationMessage;
    private final String emailVerificationMessage;
    private final String emailVerificationSubject;
    private final VerificationMessageTemplateType verificationMessageTemplate;
    private final String smsAuthenticationMessage;
    private final String mfaConfiguration;
    private final DeviceConfigurationType deviceConfiguration;
    private final EmailConfigurationType emailConfiguration;
    private final SmsConfigurationType smsConfiguration;
    private final Map<String, String> userPoolTags;
    private final AdminCreateUserConfigType adminCreateUserConfig;
    private final UserPoolAddOnsType userPoolAddOns;
    private final AccountRecoverySettingType accountRecoverySetting;

    private UpdateUserPoolRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.policies = builder.policies;
        this.lambdaConfig = builder.lambdaConfig;
        this.autoVerifiedAttributes = builder.autoVerifiedAttributes;
        this.smsVerificationMessage = builder.smsVerificationMessage;
        this.emailVerificationMessage = builder.emailVerificationMessage;
        this.emailVerificationSubject = builder.emailVerificationSubject;
        this.verificationMessageTemplate = builder.verificationMessageTemplate;
        this.smsAuthenticationMessage = builder.smsAuthenticationMessage;
        this.mfaConfiguration = builder.mfaConfiguration;
        this.deviceConfiguration = builder.deviceConfiguration;
        this.emailConfiguration = builder.emailConfiguration;
        this.smsConfiguration = builder.smsConfiguration;
        this.userPoolTags = builder.userPoolTags;
        this.adminCreateUserConfig = builder.adminCreateUserConfig;
        this.userPoolAddOns = builder.userPoolAddOns;
        this.accountRecoverySetting = builder.accountRecoverySetting;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final UserPoolPolicyType policies() {
        return this.policies;
    }

    public final LambdaConfigType lambdaConfig() {
        return this.lambdaConfig;
    }

    public final List<VerifiedAttributeType> autoVerifiedAttributes() {
        return VerifiedAttributesListTypeCopier.copyStringToEnum(this.autoVerifiedAttributes);
    }

    public final boolean hasAutoVerifiedAttributes() {
        return this.autoVerifiedAttributes != null && !(this.autoVerifiedAttributes instanceof SdkAutoConstructList);
    }

    public final List<String> autoVerifiedAttributesAsStrings() {
        return this.autoVerifiedAttributes;
    }

    public final String smsVerificationMessage() {
        return this.smsVerificationMessage;
    }

    public final String emailVerificationMessage() {
        return this.emailVerificationMessage;
    }

    public final String emailVerificationSubject() {
        return this.emailVerificationSubject;
    }

    public final VerificationMessageTemplateType verificationMessageTemplate() {
        return this.verificationMessageTemplate;
    }

    public final String smsAuthenticationMessage() {
        return this.smsAuthenticationMessage;
    }

    public final UserPoolMfaType mfaConfiguration() {
        return UserPoolMfaType.fromValue(this.mfaConfiguration);
    }

    public final String mfaConfigurationAsString() {
        return this.mfaConfiguration;
    }

    public final DeviceConfigurationType deviceConfiguration() {
        return this.deviceConfiguration;
    }

    public final EmailConfigurationType emailConfiguration() {
        return this.emailConfiguration;
    }

    public final SmsConfigurationType smsConfiguration() {
        return this.smsConfiguration;
    }

    public final boolean hasUserPoolTags() {
        return this.userPoolTags != null && !(this.userPoolTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> userPoolTags() {
        return this.userPoolTags;
    }

    public final AdminCreateUserConfigType adminCreateUserConfig() {
        return this.adminCreateUserConfig;
    }

    public final UserPoolAddOnsType userPoolAddOns() {
        return this.userPoolAddOns;
    }

    public final AccountRecoverySettingType accountRecoverySetting() {
        return this.accountRecoverySetting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policies());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoVerifiedAttributes() ? this.autoVerifiedAttributesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.smsVerificationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailVerificationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailVerificationSubject());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationMessageTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.smsAuthenticationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.mfaConfigurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.smsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserPoolTags() ? this.userPoolTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.adminCreateUserConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolAddOns());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountRecoverySetting());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserPoolRequest)) {
            return false;
        }
        UpdateUserPoolRequest other = (UpdateUserPoolRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.policies(), other.policies()) && Objects.equals(this.lambdaConfig(), other.lambdaConfig()) && this.hasAutoVerifiedAttributes() == other.hasAutoVerifiedAttributes() && Objects.equals(this.autoVerifiedAttributesAsStrings(), other.autoVerifiedAttributesAsStrings()) && Objects.equals(this.smsVerificationMessage(), other.smsVerificationMessage()) && Objects.equals(this.emailVerificationMessage(), other.emailVerificationMessage()) && Objects.equals(this.emailVerificationSubject(), other.emailVerificationSubject()) && Objects.equals(this.verificationMessageTemplate(), other.verificationMessageTemplate()) && Objects.equals(this.smsAuthenticationMessage(), other.smsAuthenticationMessage()) && Objects.equals(this.mfaConfigurationAsString(), other.mfaConfigurationAsString()) && Objects.equals(this.deviceConfiguration(), other.deviceConfiguration()) && Objects.equals(this.emailConfiguration(), other.emailConfiguration()) && Objects.equals(this.smsConfiguration(), other.smsConfiguration()) && this.hasUserPoolTags() == other.hasUserPoolTags() && Objects.equals(this.userPoolTags(), other.userPoolTags()) && Objects.equals(this.adminCreateUserConfig(), other.adminCreateUserConfig()) && Objects.equals(this.userPoolAddOns(), other.userPoolAddOns()) && Objects.equals(this.accountRecoverySetting(), other.accountRecoverySetting());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateUserPoolRequest").add("UserPoolId", (Object)this.userPoolId()).add("Policies", (Object)this.policies()).add("LambdaConfig", (Object)this.lambdaConfig()).add("AutoVerifiedAttributes", this.hasAutoVerifiedAttributes() ? this.autoVerifiedAttributesAsStrings() : null).add("SmsVerificationMessage", (Object)this.smsVerificationMessage()).add("EmailVerificationMessage", (Object)this.emailVerificationMessage()).add("EmailVerificationSubject", (Object)this.emailVerificationSubject()).add("VerificationMessageTemplate", (Object)this.verificationMessageTemplate()).add("SmsAuthenticationMessage", (Object)this.smsAuthenticationMessage()).add("MfaConfiguration", (Object)this.mfaConfigurationAsString()).add("DeviceConfiguration", (Object)this.deviceConfiguration()).add("EmailConfiguration", (Object)this.emailConfiguration()).add("SmsConfiguration", (Object)this.smsConfiguration()).add("UserPoolTags", this.hasUserPoolTags() ? this.userPoolTags() : null).add("AdminCreateUserConfig", (Object)this.adminCreateUserConfig()).add("UserPoolAddOns", (Object)this.userPoolAddOns()).add("AccountRecoverySetting", (Object)this.accountRecoverySetting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "Policies": {
                return Optional.ofNullable(clazz.cast(this.policies()));
            }
            case "LambdaConfig": {
                return Optional.ofNullable(clazz.cast(this.lambdaConfig()));
            }
            case "AutoVerifiedAttributes": {
                return Optional.ofNullable(clazz.cast(this.autoVerifiedAttributesAsStrings()));
            }
            case "SmsVerificationMessage": {
                return Optional.ofNullable(clazz.cast(this.smsVerificationMessage()));
            }
            case "EmailVerificationMessage": {
                return Optional.ofNullable(clazz.cast(this.emailVerificationMessage()));
            }
            case "EmailVerificationSubject": {
                return Optional.ofNullable(clazz.cast(this.emailVerificationSubject()));
            }
            case "VerificationMessageTemplate": {
                return Optional.ofNullable(clazz.cast(this.verificationMessageTemplate()));
            }
            case "SmsAuthenticationMessage": {
                return Optional.ofNullable(clazz.cast(this.smsAuthenticationMessage()));
            }
            case "MfaConfiguration": {
                return Optional.ofNullable(clazz.cast(this.mfaConfigurationAsString()));
            }
            case "DeviceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deviceConfiguration()));
            }
            case "EmailConfiguration": {
                return Optional.ofNullable(clazz.cast(this.emailConfiguration()));
            }
            case "SmsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.smsConfiguration()));
            }
            case "UserPoolTags": {
                return Optional.ofNullable(clazz.cast(this.userPoolTags()));
            }
            case "AdminCreateUserConfig": {
                return Optional.ofNullable(clazz.cast(this.adminCreateUserConfig()));
            }
            case "UserPoolAddOns": {
                return Optional.ofNullable(clazz.cast(this.userPoolAddOns()));
            }
            case "AccountRecoverySetting": {
                return Optional.ofNullable(clazz.cast(this.accountRecoverySetting()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserPoolRequest, T> g) {
        return obj -> g.apply((UpdateUserPoolRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private UserPoolPolicyType policies;
        private LambdaConfigType lambdaConfig;
        private List<String> autoVerifiedAttributes = DefaultSdkAutoConstructList.getInstance();
        private String smsVerificationMessage;
        private String emailVerificationMessage;
        private String emailVerificationSubject;
        private VerificationMessageTemplateType verificationMessageTemplate;
        private String smsAuthenticationMessage;
        private String mfaConfiguration;
        private DeviceConfigurationType deviceConfiguration;
        private EmailConfigurationType emailConfiguration;
        private SmsConfigurationType smsConfiguration;
        private Map<String, String> userPoolTags = DefaultSdkAutoConstructMap.getInstance();
        private AdminCreateUserConfigType adminCreateUserConfig;
        private UserPoolAddOnsType userPoolAddOns;
        private AccountRecoverySettingType accountRecoverySetting;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserPoolRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.policies(model.policies);
            this.lambdaConfig(model.lambdaConfig);
            this.autoVerifiedAttributesWithStrings(model.autoVerifiedAttributes);
            this.smsVerificationMessage(model.smsVerificationMessage);
            this.emailVerificationMessage(model.emailVerificationMessage);
            this.emailVerificationSubject(model.emailVerificationSubject);
            this.verificationMessageTemplate(model.verificationMessageTemplate);
            this.smsAuthenticationMessage(model.smsAuthenticationMessage);
            this.mfaConfiguration(model.mfaConfiguration);
            this.deviceConfiguration(model.deviceConfiguration);
            this.emailConfiguration(model.emailConfiguration);
            this.smsConfiguration(model.smsConfiguration);
            this.userPoolTags(model.userPoolTags);
            this.adminCreateUserConfig(model.adminCreateUserConfig);
            this.userPoolAddOns(model.userPoolAddOns);
            this.accountRecoverySetting(model.accountRecoverySetting);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        @Transient
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final UserPoolPolicyType.Builder getPolicies() {
            return this.policies != null ? this.policies.toBuilder() : null;
        }

        public final void setPolicies(UserPoolPolicyType.BuilderImpl policies) {
            this.policies = policies != null ? policies.build() : null;
        }

        @Override
        @Transient
        public final Builder policies(UserPoolPolicyType policies) {
            this.policies = policies;
            return this;
        }

        public final LambdaConfigType.Builder getLambdaConfig() {
            return this.lambdaConfig != null ? this.lambdaConfig.toBuilder() : null;
        }

        public final void setLambdaConfig(LambdaConfigType.BuilderImpl lambdaConfig) {
            this.lambdaConfig = lambdaConfig != null ? lambdaConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder lambdaConfig(LambdaConfigType lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        public final Collection<String> getAutoVerifiedAttributes() {
            if (this.autoVerifiedAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.autoVerifiedAttributes;
        }

        public final void setAutoVerifiedAttributes(Collection<String> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = VerifiedAttributesListTypeCopier.copy(autoVerifiedAttributes);
        }

        @Override
        @Transient
        public final Builder autoVerifiedAttributesWithStrings(Collection<String> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = VerifiedAttributesListTypeCopier.copy(autoVerifiedAttributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder autoVerifiedAttributesWithStrings(String ... autoVerifiedAttributes) {
            this.autoVerifiedAttributesWithStrings(Arrays.asList(autoVerifiedAttributes));
            return this;
        }

        @Override
        @Transient
        public final Builder autoVerifiedAttributes(Collection<VerifiedAttributeType> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = VerifiedAttributesListTypeCopier.copyEnumToString(autoVerifiedAttributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder autoVerifiedAttributes(VerifiedAttributeType ... autoVerifiedAttributes) {
            this.autoVerifiedAttributes(Arrays.asList(autoVerifiedAttributes));
            return this;
        }

        public final String getSmsVerificationMessage() {
            return this.smsVerificationMessage;
        }

        public final void setSmsVerificationMessage(String smsVerificationMessage) {
            this.smsVerificationMessage = smsVerificationMessage;
        }

        @Override
        @Transient
        public final Builder smsVerificationMessage(String smsVerificationMessage) {
            this.smsVerificationMessage = smsVerificationMessage;
            return this;
        }

        public final String getEmailVerificationMessage() {
            return this.emailVerificationMessage;
        }

        public final void setEmailVerificationMessage(String emailVerificationMessage) {
            this.emailVerificationMessage = emailVerificationMessage;
        }

        @Override
        @Transient
        public final Builder emailVerificationMessage(String emailVerificationMessage) {
            this.emailVerificationMessage = emailVerificationMessage;
            return this;
        }

        public final String getEmailVerificationSubject() {
            return this.emailVerificationSubject;
        }

        public final void setEmailVerificationSubject(String emailVerificationSubject) {
            this.emailVerificationSubject = emailVerificationSubject;
        }

        @Override
        @Transient
        public final Builder emailVerificationSubject(String emailVerificationSubject) {
            this.emailVerificationSubject = emailVerificationSubject;
            return this;
        }

        public final VerificationMessageTemplateType.Builder getVerificationMessageTemplate() {
            return this.verificationMessageTemplate != null ? this.verificationMessageTemplate.toBuilder() : null;
        }

        public final void setVerificationMessageTemplate(VerificationMessageTemplateType.BuilderImpl verificationMessageTemplate) {
            this.verificationMessageTemplate = verificationMessageTemplate != null ? verificationMessageTemplate.build() : null;
        }

        @Override
        @Transient
        public final Builder verificationMessageTemplate(VerificationMessageTemplateType verificationMessageTemplate) {
            this.verificationMessageTemplate = verificationMessageTemplate;
            return this;
        }

        public final String getSmsAuthenticationMessage() {
            return this.smsAuthenticationMessage;
        }

        public final void setSmsAuthenticationMessage(String smsAuthenticationMessage) {
            this.smsAuthenticationMessage = smsAuthenticationMessage;
        }

        @Override
        @Transient
        public final Builder smsAuthenticationMessage(String smsAuthenticationMessage) {
            this.smsAuthenticationMessage = smsAuthenticationMessage;
            return this;
        }

        public final String getMfaConfiguration() {
            return this.mfaConfiguration;
        }

        public final void setMfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
        }

        @Override
        @Transient
        public final Builder mfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
            return this;
        }

        @Override
        @Transient
        public final Builder mfaConfiguration(UserPoolMfaType mfaConfiguration) {
            this.mfaConfiguration(mfaConfiguration == null ? null : mfaConfiguration.toString());
            return this;
        }

        public final DeviceConfigurationType.Builder getDeviceConfiguration() {
            return this.deviceConfiguration != null ? this.deviceConfiguration.toBuilder() : null;
        }

        public final void setDeviceConfiguration(DeviceConfigurationType.BuilderImpl deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration != null ? deviceConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder deviceConfiguration(DeviceConfigurationType deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration;
            return this;
        }

        public final EmailConfigurationType.Builder getEmailConfiguration() {
            return this.emailConfiguration != null ? this.emailConfiguration.toBuilder() : null;
        }

        public final void setEmailConfiguration(EmailConfigurationType.BuilderImpl emailConfiguration) {
            this.emailConfiguration = emailConfiguration != null ? emailConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder emailConfiguration(EmailConfigurationType emailConfiguration) {
            this.emailConfiguration = emailConfiguration;
            return this;
        }

        public final SmsConfigurationType.Builder getSmsConfiguration() {
            return this.smsConfiguration != null ? this.smsConfiguration.toBuilder() : null;
        }

        public final void setSmsConfiguration(SmsConfigurationType.BuilderImpl smsConfiguration) {
            this.smsConfiguration = smsConfiguration != null ? smsConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder smsConfiguration(SmsConfigurationType smsConfiguration) {
            this.smsConfiguration = smsConfiguration;
            return this;
        }

        public final Map<String, String> getUserPoolTags() {
            if (this.userPoolTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.userPoolTags;
        }

        public final void setUserPoolTags(Map<String, String> userPoolTags) {
            this.userPoolTags = UserPoolTagsTypeCopier.copy(userPoolTags);
        }

        @Override
        @Transient
        public final Builder userPoolTags(Map<String, String> userPoolTags) {
            this.userPoolTags = UserPoolTagsTypeCopier.copy(userPoolTags);
            return this;
        }

        public final AdminCreateUserConfigType.Builder getAdminCreateUserConfig() {
            return this.adminCreateUserConfig != null ? this.adminCreateUserConfig.toBuilder() : null;
        }

        public final void setAdminCreateUserConfig(AdminCreateUserConfigType.BuilderImpl adminCreateUserConfig) {
            this.adminCreateUserConfig = adminCreateUserConfig != null ? adminCreateUserConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder adminCreateUserConfig(AdminCreateUserConfigType adminCreateUserConfig) {
            this.adminCreateUserConfig = adminCreateUserConfig;
            return this;
        }

        public final UserPoolAddOnsType.Builder getUserPoolAddOns() {
            return this.userPoolAddOns != null ? this.userPoolAddOns.toBuilder() : null;
        }

        public final void setUserPoolAddOns(UserPoolAddOnsType.BuilderImpl userPoolAddOns) {
            this.userPoolAddOns = userPoolAddOns != null ? userPoolAddOns.build() : null;
        }

        @Override
        @Transient
        public final Builder userPoolAddOns(UserPoolAddOnsType userPoolAddOns) {
            this.userPoolAddOns = userPoolAddOns;
            return this;
        }

        public final AccountRecoverySettingType.Builder getAccountRecoverySetting() {
            return this.accountRecoverySetting != null ? this.accountRecoverySetting.toBuilder() : null;
        }

        public final void setAccountRecoverySetting(AccountRecoverySettingType.BuilderImpl accountRecoverySetting) {
            this.accountRecoverySetting = accountRecoverySetting != null ? accountRecoverySetting.build() : null;
        }

        @Override
        @Transient
        public final Builder accountRecoverySetting(AccountRecoverySettingType accountRecoverySetting) {
            this.accountRecoverySetting = accountRecoverySetting;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserPoolRequest build() {
            return new UpdateUserPoolRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUserPoolRequest> {
        public Builder userPoolId(String var1);

        public Builder policies(UserPoolPolicyType var1);

        default public Builder policies(Consumer<UserPoolPolicyType.Builder> policies) {
            return this.policies((UserPoolPolicyType)((UserPoolPolicyType.Builder)UserPoolPolicyType.builder().applyMutation(policies)).build());
        }

        public Builder lambdaConfig(LambdaConfigType var1);

        default public Builder lambdaConfig(Consumer<LambdaConfigType.Builder> lambdaConfig) {
            return this.lambdaConfig((LambdaConfigType)((LambdaConfigType.Builder)LambdaConfigType.builder().applyMutation(lambdaConfig)).build());
        }

        public Builder autoVerifiedAttributesWithStrings(Collection<String> var1);

        public Builder autoVerifiedAttributesWithStrings(String ... var1);

        public Builder autoVerifiedAttributes(Collection<VerifiedAttributeType> var1);

        public Builder autoVerifiedAttributes(VerifiedAttributeType ... var1);

        public Builder smsVerificationMessage(String var1);

        public Builder emailVerificationMessage(String var1);

        public Builder emailVerificationSubject(String var1);

        public Builder verificationMessageTemplate(VerificationMessageTemplateType var1);

        default public Builder verificationMessageTemplate(Consumer<VerificationMessageTemplateType.Builder> verificationMessageTemplate) {
            return this.verificationMessageTemplate((VerificationMessageTemplateType)((VerificationMessageTemplateType.Builder)VerificationMessageTemplateType.builder().applyMutation(verificationMessageTemplate)).build());
        }

        public Builder smsAuthenticationMessage(String var1);

        public Builder mfaConfiguration(String var1);

        public Builder mfaConfiguration(UserPoolMfaType var1);

        public Builder deviceConfiguration(DeviceConfigurationType var1);

        default public Builder deviceConfiguration(Consumer<DeviceConfigurationType.Builder> deviceConfiguration) {
            return this.deviceConfiguration((DeviceConfigurationType)((DeviceConfigurationType.Builder)DeviceConfigurationType.builder().applyMutation(deviceConfiguration)).build());
        }

        public Builder emailConfiguration(EmailConfigurationType var1);

        default public Builder emailConfiguration(Consumer<EmailConfigurationType.Builder> emailConfiguration) {
            return this.emailConfiguration((EmailConfigurationType)((EmailConfigurationType.Builder)EmailConfigurationType.builder().applyMutation(emailConfiguration)).build());
        }

        public Builder smsConfiguration(SmsConfigurationType var1);

        default public Builder smsConfiguration(Consumer<SmsConfigurationType.Builder> smsConfiguration) {
            return this.smsConfiguration((SmsConfigurationType)((SmsConfigurationType.Builder)SmsConfigurationType.builder().applyMutation(smsConfiguration)).build());
        }

        public Builder userPoolTags(Map<String, String> var1);

        public Builder adminCreateUserConfig(AdminCreateUserConfigType var1);

        default public Builder adminCreateUserConfig(Consumer<AdminCreateUserConfigType.Builder> adminCreateUserConfig) {
            return this.adminCreateUserConfig((AdminCreateUserConfigType)((AdminCreateUserConfigType.Builder)AdminCreateUserConfigType.builder().applyMutation(adminCreateUserConfig)).build());
        }

        public Builder userPoolAddOns(UserPoolAddOnsType var1);

        default public Builder userPoolAddOns(Consumer<UserPoolAddOnsType.Builder> userPoolAddOns) {
            return this.userPoolAddOns((UserPoolAddOnsType)((UserPoolAddOnsType.Builder)UserPoolAddOnsType.builder().applyMutation(userPoolAddOns)).build());
        }

        public Builder accountRecoverySetting(AccountRecoverySettingType var1);

        default public Builder accountRecoverySetting(Consumer<AccountRecoverySettingType.Builder> accountRecoverySetting) {
            return this.accountRecoverySetting((AccountRecoverySettingType)((AccountRecoverySettingType.Builder)AccountRecoverySettingType.builder().applyMutation(accountRecoverySetting)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

