/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeDataType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.NumberAttributeConstraintsType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StringAttributeConstraintsType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SchemaAttributeType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SchemaAttributeType> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SchemaAttributeType.getter(SchemaAttributeType::name)).setter(SchemaAttributeType.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ATTRIBUTE_DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeDataType").getter(SchemaAttributeType.getter(SchemaAttributeType::attributeDataTypeAsString)).setter(SchemaAttributeType.setter(Builder::attributeDataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeDataType").build()}).build();
    private static final SdkField<Boolean> DEVELOPER_ONLY_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeveloperOnlyAttribute").getter(SchemaAttributeType.getter(SchemaAttributeType::developerOnlyAttribute)).setter(SchemaAttributeType.setter(Builder::developerOnlyAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeveloperOnlyAttribute").build()}).build();
    private static final SdkField<Boolean> MUTABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Mutable").getter(SchemaAttributeType.getter(SchemaAttributeType::mutable)).setter(SchemaAttributeType.setter(Builder::mutable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mutable").build()}).build();
    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Required").getter(SchemaAttributeType.getter(SchemaAttributeType::required)).setter(SchemaAttributeType.setter(Builder::required)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Required").build()}).build();
    private static final SdkField<NumberAttributeConstraintsType> NUMBER_ATTRIBUTE_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NumberAttributeConstraints").getter(SchemaAttributeType.getter(SchemaAttributeType::numberAttributeConstraints)).setter(SchemaAttributeType.setter(Builder::numberAttributeConstraints)).constructor(NumberAttributeConstraintsType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberAttributeConstraints").build()}).build();
    private static final SdkField<StringAttributeConstraintsType> STRING_ATTRIBUTE_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StringAttributeConstraints").getter(SchemaAttributeType.getter(SchemaAttributeType::stringAttributeConstraints)).setter(SchemaAttributeType.setter(Builder::stringAttributeConstraints)).constructor(StringAttributeConstraintsType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringAttributeConstraints").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ATTRIBUTE_DATA_TYPE_FIELD, DEVELOPER_ONLY_ATTRIBUTE_FIELD, MUTABLE_FIELD, REQUIRED_FIELD, NUMBER_ATTRIBUTE_CONSTRAINTS_FIELD, STRING_ATTRIBUTE_CONSTRAINTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String attributeDataType;
    private final Boolean developerOnlyAttribute;
    private final Boolean mutable;
    private final Boolean required;
    private final NumberAttributeConstraintsType numberAttributeConstraints;
    private final StringAttributeConstraintsType stringAttributeConstraints;

    private SchemaAttributeType(BuilderImpl builder) {
        this.name = builder.name;
        this.attributeDataType = builder.attributeDataType;
        this.developerOnlyAttribute = builder.developerOnlyAttribute;
        this.mutable = builder.mutable;
        this.required = builder.required;
        this.numberAttributeConstraints = builder.numberAttributeConstraints;
        this.stringAttributeConstraints = builder.stringAttributeConstraints;
    }

    public String name() {
        return this.name;
    }

    public AttributeDataType attributeDataType() {
        return AttributeDataType.fromValue(this.attributeDataType);
    }

    public String attributeDataTypeAsString() {
        return this.attributeDataType;
    }

    public Boolean developerOnlyAttribute() {
        return this.developerOnlyAttribute;
    }

    public Boolean mutable() {
        return this.mutable;
    }

    public Boolean required() {
        return this.required;
    }

    public NumberAttributeConstraintsType numberAttributeConstraints() {
        return this.numberAttributeConstraints;
    }

    public StringAttributeConstraintsType stringAttributeConstraints() {
        return this.stringAttributeConstraints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeDataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.developerOnlyAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.mutable());
        hashCode = 31 * hashCode + Objects.hashCode(this.required());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberAttributeConstraints());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringAttributeConstraints());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaAttributeType)) {
            return false;
        }
        SchemaAttributeType other = (SchemaAttributeType)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.attributeDataTypeAsString(), other.attributeDataTypeAsString()) && Objects.equals(this.developerOnlyAttribute(), other.developerOnlyAttribute()) && Objects.equals(this.mutable(), other.mutable()) && Objects.equals(this.required(), other.required()) && Objects.equals(this.numberAttributeConstraints(), other.numberAttributeConstraints()) && Objects.equals(this.stringAttributeConstraints(), other.stringAttributeConstraints());
    }

    public String toString() {
        return ToString.builder((String)"SchemaAttributeType").add("Name", (Object)this.name()).add("AttributeDataType", (Object)this.attributeDataTypeAsString()).add("DeveloperOnlyAttribute", (Object)this.developerOnlyAttribute()).add("Mutable", (Object)this.mutable()).add("Required", (Object)this.required()).add("NumberAttributeConstraints", (Object)this.numberAttributeConstraints()).add("StringAttributeConstraints", (Object)this.stringAttributeConstraints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AttributeDataType": {
                return Optional.ofNullable(clazz.cast(this.attributeDataTypeAsString()));
            }
            case "DeveloperOnlyAttribute": {
                return Optional.ofNullable(clazz.cast(this.developerOnlyAttribute()));
            }
            case "Mutable": {
                return Optional.ofNullable(clazz.cast(this.mutable()));
            }
            case "Required": {
                return Optional.ofNullable(clazz.cast(this.required()));
            }
            case "NumberAttributeConstraints": {
                return Optional.ofNullable(clazz.cast(this.numberAttributeConstraints()));
            }
            case "StringAttributeConstraints": {
                return Optional.ofNullable(clazz.cast(this.stringAttributeConstraints()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaAttributeType, T> g) {
        return obj -> g.apply((SchemaAttributeType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String attributeDataType;
        private Boolean developerOnlyAttribute;
        private Boolean mutable;
        private Boolean required;
        private NumberAttributeConstraintsType numberAttributeConstraints;
        private StringAttributeConstraintsType stringAttributeConstraints;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaAttributeType model) {
            this.name(model.name);
            this.attributeDataType(model.attributeDataType);
            this.developerOnlyAttribute(model.developerOnlyAttribute);
            this.mutable(model.mutable);
            this.required(model.required);
            this.numberAttributeConstraints(model.numberAttributeConstraints);
            this.stringAttributeConstraints(model.stringAttributeConstraints);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getAttributeDataType() {
            return this.attributeDataType;
        }

        @Override
        public final Builder attributeDataType(String attributeDataType) {
            this.attributeDataType = attributeDataType;
            return this;
        }

        @Override
        public final Builder attributeDataType(AttributeDataType attributeDataType) {
            this.attributeDataType(attributeDataType == null ? null : attributeDataType.toString());
            return this;
        }

        public final void setAttributeDataType(String attributeDataType) {
            this.attributeDataType = attributeDataType;
        }

        public final Boolean getDeveloperOnlyAttribute() {
            return this.developerOnlyAttribute;
        }

        @Override
        public final Builder developerOnlyAttribute(Boolean developerOnlyAttribute) {
            this.developerOnlyAttribute = developerOnlyAttribute;
            return this;
        }

        public final void setDeveloperOnlyAttribute(Boolean developerOnlyAttribute) {
            this.developerOnlyAttribute = developerOnlyAttribute;
        }

        public final Boolean getMutable() {
            return this.mutable;
        }

        @Override
        public final Builder mutable(Boolean mutable) {
            this.mutable = mutable;
            return this;
        }

        public final void setMutable(Boolean mutable) {
            this.mutable = mutable;
        }

        public final Boolean getRequired() {
            return this.required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        public final NumberAttributeConstraintsType.Builder getNumberAttributeConstraints() {
            return this.numberAttributeConstraints != null ? this.numberAttributeConstraints.toBuilder() : null;
        }

        @Override
        public final Builder numberAttributeConstraints(NumberAttributeConstraintsType numberAttributeConstraints) {
            this.numberAttributeConstraints = numberAttributeConstraints;
            return this;
        }

        public final void setNumberAttributeConstraints(NumberAttributeConstraintsType.BuilderImpl numberAttributeConstraints) {
            this.numberAttributeConstraints = numberAttributeConstraints != null ? numberAttributeConstraints.build() : null;
        }

        public final StringAttributeConstraintsType.Builder getStringAttributeConstraints() {
            return this.stringAttributeConstraints != null ? this.stringAttributeConstraints.toBuilder() : null;
        }

        @Override
        public final Builder stringAttributeConstraints(StringAttributeConstraintsType stringAttributeConstraints) {
            this.stringAttributeConstraints = stringAttributeConstraints;
            return this;
        }

        public final void setStringAttributeConstraints(StringAttributeConstraintsType.BuilderImpl stringAttributeConstraints) {
            this.stringAttributeConstraints = stringAttributeConstraints != null ? stringAttributeConstraints.build() : null;
        }

        public SchemaAttributeType build() {
            return new SchemaAttributeType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SchemaAttributeType> {
        public Builder name(String var1);

        public Builder attributeDataType(String var1);

        public Builder attributeDataType(AttributeDataType var1);

        public Builder developerOnlyAttribute(Boolean var1);

        public Builder mutable(Boolean var1);

        public Builder required(Boolean var1);

        public Builder numberAttributeConstraints(NumberAttributeConstraintsType var1);

        default public Builder numberAttributeConstraints(Consumer<NumberAttributeConstraintsType.Builder> numberAttributeConstraints) {
            return this.numberAttributeConstraints((NumberAttributeConstraintsType)((NumberAttributeConstraintsType.Builder)NumberAttributeConstraintsType.builder().applyMutation(numberAttributeConstraints)).build());
        }

        public Builder stringAttributeConstraints(StringAttributeConstraintsType var1);

        default public Builder stringAttributeConstraints(Consumer<StringAttributeConstraintsType.Builder> stringAttributeConstraints) {
            return this.stringAttributeConstraints((StringAttributeConstraintsType)((StringAttributeConstraintsType.Builder)StringAttributeConstraintsType.builder().applyMutation(stringAttributeConstraints)).build());
        }
    }
}

