/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RecoveryMechanismsTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RecoveryOptionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountRecoverySettingType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountRecoverySettingType> {
    private static final SdkField<List<RecoveryOptionType>> RECOVERY_MECHANISMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecoveryMechanisms").getter(AccountRecoverySettingType.getter(AccountRecoverySettingType::recoveryMechanisms)).setter(AccountRecoverySettingType.setter(Builder::recoveryMechanisms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryMechanisms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecoveryOptionType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_MECHANISMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<RecoveryOptionType> recoveryMechanisms;

    private AccountRecoverySettingType(BuilderImpl builder) {
        this.recoveryMechanisms = builder.recoveryMechanisms;
    }

    public final boolean hasRecoveryMechanisms() {
        return this.recoveryMechanisms != null && !(this.recoveryMechanisms instanceof SdkAutoConstructList);
    }

    public final List<RecoveryOptionType> recoveryMechanisms() {
        return this.recoveryMechanisms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecoveryMechanisms() ? this.recoveryMechanisms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountRecoverySettingType)) {
            return false;
        }
        AccountRecoverySettingType other = (AccountRecoverySettingType)obj;
        return this.hasRecoveryMechanisms() == other.hasRecoveryMechanisms() && Objects.equals(this.recoveryMechanisms(), other.recoveryMechanisms());
    }

    public final String toString() {
        return ToString.builder((String)"AccountRecoverySettingType").add("RecoveryMechanisms", this.hasRecoveryMechanisms() ? this.recoveryMechanisms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecoveryMechanisms": {
                return Optional.ofNullable(clazz.cast(this.recoveryMechanisms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountRecoverySettingType, T> g) {
        return obj -> g.apply((AccountRecoverySettingType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RecoveryOptionType> recoveryMechanisms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccountRecoverySettingType model) {
            this.recoveryMechanisms(model.recoveryMechanisms);
        }

        public final Collection<RecoveryOptionType.Builder> getRecoveryMechanisms() {
            if (this.recoveryMechanisms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recoveryMechanisms != null ? (Collection)this.recoveryMechanisms.stream().map(RecoveryOptionType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recoveryMechanisms(Collection<RecoveryOptionType> recoveryMechanisms) {
            this.recoveryMechanisms = RecoveryMechanismsTypeCopier.copy(recoveryMechanisms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recoveryMechanisms(RecoveryOptionType ... recoveryMechanisms) {
            this.recoveryMechanisms(Arrays.asList(recoveryMechanisms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recoveryMechanisms(Consumer<RecoveryOptionType.Builder> ... recoveryMechanisms) {
            this.recoveryMechanisms(Stream.of(recoveryMechanisms).map(c -> (RecoveryOptionType)((RecoveryOptionType.Builder)RecoveryOptionType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecoveryMechanisms(Collection<RecoveryOptionType.BuilderImpl> recoveryMechanisms) {
            this.recoveryMechanisms = RecoveryMechanismsTypeCopier.copyFromBuilder(recoveryMechanisms);
        }

        public AccountRecoverySettingType build() {
            return new AccountRecoverySettingType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountRecoverySettingType> {
        public Builder recoveryMechanisms(Collection<RecoveryOptionType> var1);

        public Builder recoveryMechanisms(RecoveryOptionType ... var1);

        public Builder recoveryMechanisms(Consumer<RecoveryOptionType.Builder> ... var1);
    }
}

