/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ClientMetadataTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeliveryMediumListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeliveryMediumType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MessageActionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdminCreateUserRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, AdminCreateUserRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(AdminCreateUserRequest.getter(AdminCreateUserRequest::userPoolId)).setter(AdminCreateUserRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(AdminCreateUserRequest.getter(AdminCreateUserRequest::username)).setter(AdminCreateUserRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<List<AttributeType>> USER_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserAttributes").getter(AdminCreateUserRequest.getter(AdminCreateUserRequest::userAttributes)).setter(AdminCreateUserRequest.setter(Builder::userAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AttributeType>> VALIDATION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidationData").getter(AdminCreateUserRequest.getter(AdminCreateUserRequest::validationData)).setter(AdminCreateUserRequest.setter(Builder::validationData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPORARY_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemporaryPassword").getter(AdminCreateUserRequest.getter(AdminCreateUserRequest::temporaryPassword)).setter(AdminCreateUserRequest.setter(Builder::temporaryPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemporaryPassword").build()}).build();
    private static final SdkField<Boolean> FORCE_ALIAS_CREATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ForceAliasCreation").getter(AdminCreateUserRequest.getter(AdminCreateUserRequest::forceAliasCreation)).setter(AdminCreateUserRequest.setter(Builder::forceAliasCreation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceAliasCreation").build()}).build();
    private static final SdkField<String> MESSAGE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageAction").getter(AdminCreateUserRequest.getter(AdminCreateUserRequest::messageActionAsString)).setter(AdminCreateUserRequest.setter(Builder::messageAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageAction").build()}).build();
    private static final SdkField<List<String>> DESIRED_DELIVERY_MEDIUMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DesiredDeliveryMediums").getter(AdminCreateUserRequest.getter(AdminCreateUserRequest::desiredDeliveryMediumsAsStrings)).setter(AdminCreateUserRequest.setter(Builder::desiredDeliveryMediumsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredDeliveryMediums").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CLIENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ClientMetadata").getter(AdminCreateUserRequest.getter(AdminCreateUserRequest::clientMetadata)).setter(AdminCreateUserRequest.setter(Builder::clientMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, USERNAME_FIELD, USER_ATTRIBUTES_FIELD, VALIDATION_DATA_FIELD, TEMPORARY_PASSWORD_FIELD, FORCE_ALIAS_CREATION_FIELD, MESSAGE_ACTION_FIELD, DESIRED_DELIVERY_MEDIUMS_FIELD, CLIENT_METADATA_FIELD));
    private final String userPoolId;
    private final String username;
    private final List<AttributeType> userAttributes;
    private final List<AttributeType> validationData;
    private final String temporaryPassword;
    private final Boolean forceAliasCreation;
    private final String messageAction;
    private final List<String> desiredDeliveryMediums;
    private final Map<String, String> clientMetadata;

    private AdminCreateUserRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.username = builder.username;
        this.userAttributes = builder.userAttributes;
        this.validationData = builder.validationData;
        this.temporaryPassword = builder.temporaryPassword;
        this.forceAliasCreation = builder.forceAliasCreation;
        this.messageAction = builder.messageAction;
        this.desiredDeliveryMediums = builder.desiredDeliveryMediums;
        this.clientMetadata = builder.clientMetadata;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String username() {
        return this.username;
    }

    public boolean hasUserAttributes() {
        return this.userAttributes != null && !(this.userAttributes instanceof SdkAutoConstructList);
    }

    public List<AttributeType> userAttributes() {
        return this.userAttributes;
    }

    public boolean hasValidationData() {
        return this.validationData != null && !(this.validationData instanceof SdkAutoConstructList);
    }

    public List<AttributeType> validationData() {
        return this.validationData;
    }

    public String temporaryPassword() {
        return this.temporaryPassword;
    }

    public Boolean forceAliasCreation() {
        return this.forceAliasCreation;
    }

    public MessageActionType messageAction() {
        return MessageActionType.fromValue(this.messageAction);
    }

    public String messageActionAsString() {
        return this.messageAction;
    }

    public List<DeliveryMediumType> desiredDeliveryMediums() {
        return DeliveryMediumListTypeCopier.copyStringToEnum(this.desiredDeliveryMediums);
    }

    public boolean hasDesiredDeliveryMediums() {
        return this.desiredDeliveryMediums != null && !(this.desiredDeliveryMediums instanceof SdkAutoConstructList);
    }

    public List<String> desiredDeliveryMediumsAsStrings() {
        return this.desiredDeliveryMediums;
    }

    public boolean hasClientMetadata() {
        return this.clientMetadata != null && !(this.clientMetadata instanceof SdkAutoConstructMap);
    }

    public Map<String, String> clientMetadata() {
        return this.clientMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationData());
        hashCode = 31 * hashCode + Objects.hashCode(this.temporaryPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceAliasCreation());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredDeliveryMediumsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminCreateUserRequest)) {
            return false;
        }
        AdminCreateUserRequest other = (AdminCreateUserRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.userAttributes(), other.userAttributes()) && Objects.equals(this.validationData(), other.validationData()) && Objects.equals(this.temporaryPassword(), other.temporaryPassword()) && Objects.equals(this.forceAliasCreation(), other.forceAliasCreation()) && Objects.equals(this.messageActionAsString(), other.messageActionAsString()) && Objects.equals(this.desiredDeliveryMediumsAsStrings(), other.desiredDeliveryMediumsAsStrings()) && Objects.equals(this.clientMetadata(), other.clientMetadata());
    }

    public String toString() {
        return ToString.builder((String)"AdminCreateUserRequest").add("UserPoolId", (Object)this.userPoolId()).add("Username", (Object)(this.username() == null ? null : "*** Sensitive Data Redacted ***")).add("UserAttributes", this.userAttributes()).add("ValidationData", this.validationData()).add("TemporaryPassword", (Object)(this.temporaryPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("ForceAliasCreation", (Object)this.forceAliasCreation()).add("MessageAction", (Object)this.messageActionAsString()).add("DesiredDeliveryMediums", this.desiredDeliveryMediumsAsStrings()).add("ClientMetadata", this.clientMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "UserAttributes": {
                return Optional.ofNullable(clazz.cast(this.userAttributes()));
            }
            case "ValidationData": {
                return Optional.ofNullable(clazz.cast(this.validationData()));
            }
            case "TemporaryPassword": {
                return Optional.ofNullable(clazz.cast(this.temporaryPassword()));
            }
            case "ForceAliasCreation": {
                return Optional.ofNullable(clazz.cast(this.forceAliasCreation()));
            }
            case "MessageAction": {
                return Optional.ofNullable(clazz.cast(this.messageActionAsString()));
            }
            case "DesiredDeliveryMediums": {
                return Optional.ofNullable(clazz.cast(this.desiredDeliveryMediumsAsStrings()));
            }
            case "ClientMetadata": {
                return Optional.ofNullable(clazz.cast(this.clientMetadata()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdminCreateUserRequest, T> g) {
        return obj -> g.apply((AdminCreateUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private String username;
        private List<AttributeType> userAttributes = DefaultSdkAutoConstructList.getInstance();
        private List<AttributeType> validationData = DefaultSdkAutoConstructList.getInstance();
        private String temporaryPassword;
        private Boolean forceAliasCreation;
        private String messageAction;
        private List<String> desiredDeliveryMediums = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> clientMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdminCreateUserRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.username(model.username);
            this.userAttributes(model.userAttributes);
            this.validationData(model.validationData);
            this.temporaryPassword(model.temporaryPassword);
            this.forceAliasCreation(model.forceAliasCreation);
            this.messageAction(model.messageAction);
            this.desiredDeliveryMediumsWithStrings(model.desiredDeliveryMediums);
            this.clientMetadata(model.clientMetadata);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final Collection<AttributeType.Builder> getUserAttributes() {
            return this.userAttributes != null ? (Collection)this.userAttributes.stream().map(AttributeType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userAttributes(Collection<AttributeType> userAttributes) {
            this.userAttributes = AttributeListTypeCopier.copy(userAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(AttributeType ... userAttributes) {
            this.userAttributes(Arrays.asList(userAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(Consumer<AttributeType.Builder> ... userAttributes) {
            this.userAttributes(Stream.of(userAttributes).map(c -> (AttributeType)((AttributeType.Builder)AttributeType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserAttributes(Collection<AttributeType.BuilderImpl> userAttributes) {
            this.userAttributes = AttributeListTypeCopier.copyFromBuilder(userAttributes);
        }

        public final Collection<AttributeType.Builder> getValidationData() {
            return this.validationData != null ? (Collection)this.validationData.stream().map(AttributeType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validationData(Collection<AttributeType> validationData) {
            this.validationData = AttributeListTypeCopier.copy(validationData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationData(AttributeType ... validationData) {
            this.validationData(Arrays.asList(validationData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationData(Consumer<AttributeType.Builder> ... validationData) {
            this.validationData(Stream.of(validationData).map(c -> (AttributeType)((AttributeType.Builder)AttributeType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValidationData(Collection<AttributeType.BuilderImpl> validationData) {
            this.validationData = AttributeListTypeCopier.copyFromBuilder(validationData);
        }

        public final String getTemporaryPassword() {
            return this.temporaryPassword;
        }

        @Override
        public final Builder temporaryPassword(String temporaryPassword) {
            this.temporaryPassword = temporaryPassword;
            return this;
        }

        public final void setTemporaryPassword(String temporaryPassword) {
            this.temporaryPassword = temporaryPassword;
        }

        public final Boolean getForceAliasCreation() {
            return this.forceAliasCreation;
        }

        @Override
        public final Builder forceAliasCreation(Boolean forceAliasCreation) {
            this.forceAliasCreation = forceAliasCreation;
            return this;
        }

        public final void setForceAliasCreation(Boolean forceAliasCreation) {
            this.forceAliasCreation = forceAliasCreation;
        }

        public final String getMessageAction() {
            return this.messageAction;
        }

        @Override
        public final Builder messageAction(String messageAction) {
            this.messageAction = messageAction;
            return this;
        }

        @Override
        public final Builder messageAction(MessageActionType messageAction) {
            this.messageAction(messageAction == null ? null : messageAction.toString());
            return this;
        }

        public final void setMessageAction(String messageAction) {
            this.messageAction = messageAction;
        }

        public final Collection<String> getDesiredDeliveryMediums() {
            return this.desiredDeliveryMediums;
        }

        @Override
        public final Builder desiredDeliveryMediumsWithStrings(Collection<String> desiredDeliveryMediums) {
            this.desiredDeliveryMediums = DeliveryMediumListTypeCopier.copy(desiredDeliveryMediums);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredDeliveryMediumsWithStrings(String ... desiredDeliveryMediums) {
            this.desiredDeliveryMediumsWithStrings(Arrays.asList(desiredDeliveryMediums));
            return this;
        }

        @Override
        public final Builder desiredDeliveryMediums(Collection<DeliveryMediumType> desiredDeliveryMediums) {
            this.desiredDeliveryMediums = DeliveryMediumListTypeCopier.copyEnumToString(desiredDeliveryMediums);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredDeliveryMediums(DeliveryMediumType ... desiredDeliveryMediums) {
            this.desiredDeliveryMediums(Arrays.asList(desiredDeliveryMediums));
            return this;
        }

        public final void setDesiredDeliveryMediums(Collection<String> desiredDeliveryMediums) {
            this.desiredDeliveryMediums = DeliveryMediumListTypeCopier.copy(desiredDeliveryMediums);
        }

        public final Map<String, String> getClientMetadata() {
            return this.clientMetadata;
        }

        @Override
        public final Builder clientMetadata(Map<String, String> clientMetadata) {
            this.clientMetadata = ClientMetadataTypeCopier.copy(clientMetadata);
            return this;
        }

        public final void setClientMetadata(Map<String, String> clientMetadata) {
            this.clientMetadata = ClientMetadataTypeCopier.copy(clientMetadata);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminCreateUserRequest build() {
            return new AdminCreateUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AdminCreateUserRequest> {
        public Builder userPoolId(String var1);

        public Builder username(String var1);

        public Builder userAttributes(Collection<AttributeType> var1);

        public Builder userAttributes(AttributeType ... var1);

        public Builder userAttributes(Consumer<AttributeType.Builder> ... var1);

        public Builder validationData(Collection<AttributeType> var1);

        public Builder validationData(AttributeType ... var1);

        public Builder validationData(Consumer<AttributeType.Builder> ... var1);

        public Builder temporaryPassword(String var1);

        public Builder forceAliasCreation(Boolean var1);

        public Builder messageAction(String var1);

        public Builder messageAction(MessageActionType var1);

        public Builder desiredDeliveryMediumsWithStrings(Collection<String> var1);

        public Builder desiredDeliveryMediumsWithStrings(String ... var1);

        public Builder desiredDeliveryMediums(Collection<DeliveryMediumType> var1);

        public Builder desiredDeliveryMediums(DeliveryMediumType ... var1);

        public Builder clientMetadata(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

