/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.BlockedIPRangeListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SkippedIPRangeListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RiskExceptionConfigurationType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RiskExceptionConfigurationType> {
    private static final SdkField<List<String>> BLOCKED_IP_RANGE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockedIPRangeList").getter(RiskExceptionConfigurationType.getter(RiskExceptionConfigurationType::blockedIPRangeList)).setter(RiskExceptionConfigurationType.setter(Builder::blockedIPRangeList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockedIPRangeList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SKIPPED_IP_RANGE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SkippedIPRangeList").getter(RiskExceptionConfigurationType.getter(RiskExceptionConfigurationType::skippedIPRangeList)).setter(RiskExceptionConfigurationType.setter(Builder::skippedIPRangeList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkippedIPRangeList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCKED_IP_RANGE_LIST_FIELD, SKIPPED_IP_RANGE_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> blockedIPRangeList;
    private final List<String> skippedIPRangeList;

    private RiskExceptionConfigurationType(BuilderImpl builder) {
        this.blockedIPRangeList = builder.blockedIPRangeList;
        this.skippedIPRangeList = builder.skippedIPRangeList;
    }

    public boolean hasBlockedIPRangeList() {
        return this.blockedIPRangeList != null && !(this.blockedIPRangeList instanceof SdkAutoConstructList);
    }

    public List<String> blockedIPRangeList() {
        return this.blockedIPRangeList;
    }

    public boolean hasSkippedIPRangeList() {
        return this.skippedIPRangeList != null && !(this.skippedIPRangeList instanceof SdkAutoConstructList);
    }

    public List<String> skippedIPRangeList() {
        return this.skippedIPRangeList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockedIPRangeList() ? this.blockedIPRangeList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSkippedIPRangeList() ? this.skippedIPRangeList() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RiskExceptionConfigurationType)) {
            return false;
        }
        RiskExceptionConfigurationType other = (RiskExceptionConfigurationType)obj;
        return this.hasBlockedIPRangeList() == other.hasBlockedIPRangeList() && Objects.equals(this.blockedIPRangeList(), other.blockedIPRangeList()) && this.hasSkippedIPRangeList() == other.hasSkippedIPRangeList() && Objects.equals(this.skippedIPRangeList(), other.skippedIPRangeList());
    }

    public String toString() {
        return ToString.builder((String)"RiskExceptionConfigurationType").add("BlockedIPRangeList", this.hasBlockedIPRangeList() ? this.blockedIPRangeList() : null).add("SkippedIPRangeList", this.hasSkippedIPRangeList() ? this.skippedIPRangeList() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlockedIPRangeList": {
                return Optional.ofNullable(clazz.cast(this.blockedIPRangeList()));
            }
            case "SkippedIPRangeList": {
                return Optional.ofNullable(clazz.cast(this.skippedIPRangeList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RiskExceptionConfigurationType, T> g) {
        return obj -> g.apply((RiskExceptionConfigurationType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> blockedIPRangeList = DefaultSdkAutoConstructList.getInstance();
        private List<String> skippedIPRangeList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RiskExceptionConfigurationType model) {
            this.blockedIPRangeList(model.blockedIPRangeList);
            this.skippedIPRangeList(model.skippedIPRangeList);
        }

        public final Collection<String> getBlockedIPRangeList() {
            if (this.blockedIPRangeList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.blockedIPRangeList;
        }

        @Override
        public final Builder blockedIPRangeList(Collection<String> blockedIPRangeList) {
            this.blockedIPRangeList = BlockedIPRangeListTypeCopier.copy(blockedIPRangeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedIPRangeList(String ... blockedIPRangeList) {
            this.blockedIPRangeList(Arrays.asList(blockedIPRangeList));
            return this;
        }

        public final void setBlockedIPRangeList(Collection<String> blockedIPRangeList) {
            this.blockedIPRangeList = BlockedIPRangeListTypeCopier.copy(blockedIPRangeList);
        }

        public final Collection<String> getSkippedIPRangeList() {
            if (this.skippedIPRangeList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.skippedIPRangeList;
        }

        @Override
        public final Builder skippedIPRangeList(Collection<String> skippedIPRangeList) {
            this.skippedIPRangeList = SkippedIPRangeListTypeCopier.copy(skippedIPRangeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skippedIPRangeList(String ... skippedIPRangeList) {
            this.skippedIPRangeList(Arrays.asList(skippedIPRangeList));
            return this;
        }

        public final void setSkippedIPRangeList(Collection<String> skippedIPRangeList) {
            this.skippedIPRangeList = SkippedIPRangeListTypeCopier.copy(skippedIPRangeList);
        }

        public RiskExceptionConfigurationType build() {
            return new RiskExceptionConfigurationType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RiskExceptionConfigurationType> {
        public Builder blockedIPRangeList(Collection<String> var1);

        public Builder blockedIPRangeList(String ... var1);

        public Builder skippedIPRangeList(Collection<String> var1);

        public Builder skippedIPRangeList(String ... var1);
    }
}

