/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AnalyticsConfigurationType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CallbackURLsListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ClientPermissionListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ExplicitAuthFlowsListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ExplicitAuthFlowsType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LogoutURLsListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.OAuthFlowType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.OAuthFlowsTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PreventUserExistenceErrorTypes;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ScopeListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SupportedIdentityProvidersListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TokenValidityUnitsType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserPoolClientType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserPoolClientType> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(UserPoolClientType.getter(UserPoolClientType::userPoolId)).setter(UserPoolClientType.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> CLIENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientName").getter(UserPoolClientType.getter(UserPoolClientType::clientName)).setter(UserPoolClientType.setter(Builder::clientName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientName").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientId").getter(UserPoolClientType.getter(UserPoolClientType::clientId)).setter(UserPoolClientType.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientSecret").getter(UserPoolClientType.getter(UserPoolClientType::clientSecret)).setter(UserPoolClientType.setter(Builder::clientSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientSecret").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(UserPoolClientType.getter(UserPoolClientType::lastModifiedDate)).setter(UserPoolClientType.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(UserPoolClientType.getter(UserPoolClientType::creationDate)).setter(UserPoolClientType.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Integer> REFRESH_TOKEN_VALIDITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RefreshTokenValidity").getter(UserPoolClientType.getter(UserPoolClientType::refreshTokenValidity)).setter(UserPoolClientType.setter(Builder::refreshTokenValidity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshTokenValidity").build()}).build();
    private static final SdkField<Integer> ACCESS_TOKEN_VALIDITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AccessTokenValidity").getter(UserPoolClientType.getter(UserPoolClientType::accessTokenValidity)).setter(UserPoolClientType.setter(Builder::accessTokenValidity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessTokenValidity").build()}).build();
    private static final SdkField<Integer> ID_TOKEN_VALIDITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IdTokenValidity").getter(UserPoolClientType.getter(UserPoolClientType::idTokenValidity)).setter(UserPoolClientType.setter(Builder::idTokenValidity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdTokenValidity").build()}).build();
    private static final SdkField<TokenValidityUnitsType> TOKEN_VALIDITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TokenValidityUnits").getter(UserPoolClientType.getter(UserPoolClientType::tokenValidityUnits)).setter(UserPoolClientType.setter(Builder::tokenValidityUnits)).constructor(TokenValidityUnitsType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenValidityUnits").build()}).build();
    private static final SdkField<List<String>> READ_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReadAttributes").getter(UserPoolClientType.getter(UserPoolClientType::readAttributes)).setter(UserPoolClientType.setter(Builder::readAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> WRITE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WriteAttributes").getter(UserPoolClientType.getter(UserPoolClientType::writeAttributes)).setter(UserPoolClientType.setter(Builder::writeAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXPLICIT_AUTH_FLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExplicitAuthFlows").getter(UserPoolClientType.getter(UserPoolClientType::explicitAuthFlowsAsStrings)).setter(UserPoolClientType.setter(Builder::explicitAuthFlowsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplicitAuthFlows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_IDENTITY_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedIdentityProviders").getter(UserPoolClientType.getter(UserPoolClientType::supportedIdentityProviders)).setter(UserPoolClientType.setter(Builder::supportedIdentityProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedIdentityProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CALLBACK_UR_LS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CallbackURLs").getter(UserPoolClientType.getter(UserPoolClientType::callbackURLs)).setter(UserPoolClientType.setter(Builder::callbackURLs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackURLs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LOGOUT_UR_LS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogoutURLs").getter(UserPoolClientType.getter(UserPoolClientType::logoutURLs)).setter(UserPoolClientType.setter(Builder::logoutURLs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoutURLs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEFAULT_REDIRECT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultRedirectURI").getter(UserPoolClientType.getter(UserPoolClientType::defaultRedirectURI)).setter(UserPoolClientType.setter(Builder::defaultRedirectURI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRedirectURI").build()}).build();
    private static final SdkField<List<String>> ALLOWED_O_AUTH_FLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedOAuthFlows").getter(UserPoolClientType.getter(UserPoolClientType::allowedOAuthFlowsAsStrings)).setter(UserPoolClientType.setter(Builder::allowedOAuthFlowsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOAuthFlows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_O_AUTH_SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedOAuthScopes").getter(UserPoolClientType.getter(UserPoolClientType::allowedOAuthScopes)).setter(UserPoolClientType.setter(Builder::allowedOAuthScopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOAuthScopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ALLOWED_O_AUTH_FLOWS_USER_POOL_CLIENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowedOAuthFlowsUserPoolClient").getter(UserPoolClientType.getter(UserPoolClientType::allowedOAuthFlowsUserPoolClient)).setter(UserPoolClientType.setter(Builder::allowedOAuthFlowsUserPoolClient)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOAuthFlowsUserPoolClient").build()}).build();
    private static final SdkField<AnalyticsConfigurationType> ANALYTICS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnalyticsConfiguration").getter(UserPoolClientType.getter(UserPoolClientType::analyticsConfiguration)).setter(UserPoolClientType.setter(Builder::analyticsConfiguration)).constructor(AnalyticsConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyticsConfiguration").build()}).build();
    private static final SdkField<String> PREVENT_USER_EXISTENCE_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreventUserExistenceErrors").getter(UserPoolClientType.getter(UserPoolClientType::preventUserExistenceErrorsAsString)).setter(UserPoolClientType.setter(Builder::preventUserExistenceErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreventUserExistenceErrors").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, CLIENT_NAME_FIELD, CLIENT_ID_FIELD, CLIENT_SECRET_FIELD, LAST_MODIFIED_DATE_FIELD, CREATION_DATE_FIELD, REFRESH_TOKEN_VALIDITY_FIELD, ACCESS_TOKEN_VALIDITY_FIELD, ID_TOKEN_VALIDITY_FIELD, TOKEN_VALIDITY_UNITS_FIELD, READ_ATTRIBUTES_FIELD, WRITE_ATTRIBUTES_FIELD, EXPLICIT_AUTH_FLOWS_FIELD, SUPPORTED_IDENTITY_PROVIDERS_FIELD, CALLBACK_UR_LS_FIELD, LOGOUT_UR_LS_FIELD, DEFAULT_REDIRECT_URI_FIELD, ALLOWED_O_AUTH_FLOWS_FIELD, ALLOWED_O_AUTH_SCOPES_FIELD, ALLOWED_O_AUTH_FLOWS_USER_POOL_CLIENT_FIELD, ANALYTICS_CONFIGURATION_FIELD, PREVENT_USER_EXISTENCE_ERRORS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userPoolId;
    private final String clientName;
    private final String clientId;
    private final String clientSecret;
    private final Instant lastModifiedDate;
    private final Instant creationDate;
    private final Integer refreshTokenValidity;
    private final Integer accessTokenValidity;
    private final Integer idTokenValidity;
    private final TokenValidityUnitsType tokenValidityUnits;
    private final List<String> readAttributes;
    private final List<String> writeAttributes;
    private final List<String> explicitAuthFlows;
    private final List<String> supportedIdentityProviders;
    private final List<String> callbackURLs;
    private final List<String> logoutURLs;
    private final String defaultRedirectURI;
    private final List<String> allowedOAuthFlows;
    private final List<String> allowedOAuthScopes;
    private final Boolean allowedOAuthFlowsUserPoolClient;
    private final AnalyticsConfigurationType analyticsConfiguration;
    private final String preventUserExistenceErrors;

    private UserPoolClientType(BuilderImpl builder) {
        this.userPoolId = builder.userPoolId;
        this.clientName = builder.clientName;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.creationDate = builder.creationDate;
        this.refreshTokenValidity = builder.refreshTokenValidity;
        this.accessTokenValidity = builder.accessTokenValidity;
        this.idTokenValidity = builder.idTokenValidity;
        this.tokenValidityUnits = builder.tokenValidityUnits;
        this.readAttributes = builder.readAttributes;
        this.writeAttributes = builder.writeAttributes;
        this.explicitAuthFlows = builder.explicitAuthFlows;
        this.supportedIdentityProviders = builder.supportedIdentityProviders;
        this.callbackURLs = builder.callbackURLs;
        this.logoutURLs = builder.logoutURLs;
        this.defaultRedirectURI = builder.defaultRedirectURI;
        this.allowedOAuthFlows = builder.allowedOAuthFlows;
        this.allowedOAuthScopes = builder.allowedOAuthScopes;
        this.allowedOAuthFlowsUserPoolClient = builder.allowedOAuthFlowsUserPoolClient;
        this.analyticsConfiguration = builder.analyticsConfiguration;
        this.preventUserExistenceErrors = builder.preventUserExistenceErrors;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String clientName() {
        return this.clientName;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Integer refreshTokenValidity() {
        return this.refreshTokenValidity;
    }

    public Integer accessTokenValidity() {
        return this.accessTokenValidity;
    }

    public Integer idTokenValidity() {
        return this.idTokenValidity;
    }

    public TokenValidityUnitsType tokenValidityUnits() {
        return this.tokenValidityUnits;
    }

    public boolean hasReadAttributes() {
        return this.readAttributes != null && !(this.readAttributes instanceof SdkAutoConstructList);
    }

    public List<String> readAttributes() {
        return this.readAttributes;
    }

    public boolean hasWriteAttributes() {
        return this.writeAttributes != null && !(this.writeAttributes instanceof SdkAutoConstructList);
    }

    public List<String> writeAttributes() {
        return this.writeAttributes;
    }

    public List<ExplicitAuthFlowsType> explicitAuthFlows() {
        return ExplicitAuthFlowsListTypeCopier.copyStringToEnum(this.explicitAuthFlows);
    }

    public boolean hasExplicitAuthFlows() {
        return this.explicitAuthFlows != null && !(this.explicitAuthFlows instanceof SdkAutoConstructList);
    }

    public List<String> explicitAuthFlowsAsStrings() {
        return this.explicitAuthFlows;
    }

    public boolean hasSupportedIdentityProviders() {
        return this.supportedIdentityProviders != null && !(this.supportedIdentityProviders instanceof SdkAutoConstructList);
    }

    public List<String> supportedIdentityProviders() {
        return this.supportedIdentityProviders;
    }

    public boolean hasCallbackURLs() {
        return this.callbackURLs != null && !(this.callbackURLs instanceof SdkAutoConstructList);
    }

    public List<String> callbackURLs() {
        return this.callbackURLs;
    }

    public boolean hasLogoutURLs() {
        return this.logoutURLs != null && !(this.logoutURLs instanceof SdkAutoConstructList);
    }

    public List<String> logoutURLs() {
        return this.logoutURLs;
    }

    public String defaultRedirectURI() {
        return this.defaultRedirectURI;
    }

    public List<OAuthFlowType> allowedOAuthFlows() {
        return OAuthFlowsTypeCopier.copyStringToEnum(this.allowedOAuthFlows);
    }

    public boolean hasAllowedOAuthFlows() {
        return this.allowedOAuthFlows != null && !(this.allowedOAuthFlows instanceof SdkAutoConstructList);
    }

    public List<String> allowedOAuthFlowsAsStrings() {
        return this.allowedOAuthFlows;
    }

    public boolean hasAllowedOAuthScopes() {
        return this.allowedOAuthScopes != null && !(this.allowedOAuthScopes instanceof SdkAutoConstructList);
    }

    public List<String> allowedOAuthScopes() {
        return this.allowedOAuthScopes;
    }

    public Boolean allowedOAuthFlowsUserPoolClient() {
        return this.allowedOAuthFlowsUserPoolClient;
    }

    public AnalyticsConfigurationType analyticsConfiguration() {
        return this.analyticsConfiguration;
    }

    public PreventUserExistenceErrorTypes preventUserExistenceErrors() {
        return PreventUserExistenceErrorTypes.fromValue(this.preventUserExistenceErrors);
    }

    public String preventUserExistenceErrorsAsString() {
        return this.preventUserExistenceErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshTokenValidity());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessTokenValidity());
        hashCode = 31 * hashCode + Objects.hashCode(this.idTokenValidity());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenValidityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.readAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.explicitAuthFlowsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedIdentityProviders());
        hashCode = 31 * hashCode + Objects.hashCode(this.callbackURLs());
        hashCode = 31 * hashCode + Objects.hashCode(this.logoutURLs());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRedirectURI());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedOAuthFlowsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedOAuthScopes());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedOAuthFlowsUserPoolClient());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyticsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.preventUserExistenceErrorsAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPoolClientType)) {
            return false;
        }
        UserPoolClientType other = (UserPoolClientType)obj;
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.clientName(), other.clientName()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.clientSecret(), other.clientSecret()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.refreshTokenValidity(), other.refreshTokenValidity()) && Objects.equals(this.accessTokenValidity(), other.accessTokenValidity()) && Objects.equals(this.idTokenValidity(), other.idTokenValidity()) && Objects.equals(this.tokenValidityUnits(), other.tokenValidityUnits()) && Objects.equals(this.readAttributes(), other.readAttributes()) && Objects.equals(this.writeAttributes(), other.writeAttributes()) && Objects.equals(this.explicitAuthFlowsAsStrings(), other.explicitAuthFlowsAsStrings()) && Objects.equals(this.supportedIdentityProviders(), other.supportedIdentityProviders()) && Objects.equals(this.callbackURLs(), other.callbackURLs()) && Objects.equals(this.logoutURLs(), other.logoutURLs()) && Objects.equals(this.defaultRedirectURI(), other.defaultRedirectURI()) && Objects.equals(this.allowedOAuthFlowsAsStrings(), other.allowedOAuthFlowsAsStrings()) && Objects.equals(this.allowedOAuthScopes(), other.allowedOAuthScopes()) && Objects.equals(this.allowedOAuthFlowsUserPoolClient(), other.allowedOAuthFlowsUserPoolClient()) && Objects.equals(this.analyticsConfiguration(), other.analyticsConfiguration()) && Objects.equals(this.preventUserExistenceErrorsAsString(), other.preventUserExistenceErrorsAsString());
    }

    public String toString() {
        return ToString.builder((String)"UserPoolClientType").add("UserPoolId", (Object)this.userPoolId()).add("ClientName", (Object)this.clientName()).add("ClientId", (Object)(this.clientId() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientSecret", (Object)(this.clientSecret() == null ? null : "*** Sensitive Data Redacted ***")).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("CreationDate", (Object)this.creationDate()).add("RefreshTokenValidity", (Object)this.refreshTokenValidity()).add("AccessTokenValidity", (Object)this.accessTokenValidity()).add("IdTokenValidity", (Object)this.idTokenValidity()).add("TokenValidityUnits", (Object)this.tokenValidityUnits()).add("ReadAttributes", this.readAttributes()).add("WriteAttributes", this.writeAttributes()).add("ExplicitAuthFlows", this.explicitAuthFlowsAsStrings()).add("SupportedIdentityProviders", this.supportedIdentityProviders()).add("CallbackURLs", this.callbackURLs()).add("LogoutURLs", this.logoutURLs()).add("DefaultRedirectURI", (Object)this.defaultRedirectURI()).add("AllowedOAuthFlows", this.allowedOAuthFlowsAsStrings()).add("AllowedOAuthScopes", this.allowedOAuthScopes()).add("AllowedOAuthFlowsUserPoolClient", (Object)this.allowedOAuthFlowsUserPoolClient()).add("AnalyticsConfiguration", (Object)this.analyticsConfiguration()).add("PreventUserExistenceErrors", (Object)this.preventUserExistenceErrorsAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "ClientName": {
                return Optional.ofNullable(clazz.cast(this.clientName()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "ClientSecret": {
                return Optional.ofNullable(clazz.cast(this.clientSecret()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "RefreshTokenValidity": {
                return Optional.ofNullable(clazz.cast(this.refreshTokenValidity()));
            }
            case "AccessTokenValidity": {
                return Optional.ofNullable(clazz.cast(this.accessTokenValidity()));
            }
            case "IdTokenValidity": {
                return Optional.ofNullable(clazz.cast(this.idTokenValidity()));
            }
            case "TokenValidityUnits": {
                return Optional.ofNullable(clazz.cast(this.tokenValidityUnits()));
            }
            case "ReadAttributes": {
                return Optional.ofNullable(clazz.cast(this.readAttributes()));
            }
            case "WriteAttributes": {
                return Optional.ofNullable(clazz.cast(this.writeAttributes()));
            }
            case "ExplicitAuthFlows": {
                return Optional.ofNullable(clazz.cast(this.explicitAuthFlowsAsStrings()));
            }
            case "SupportedIdentityProviders": {
                return Optional.ofNullable(clazz.cast(this.supportedIdentityProviders()));
            }
            case "CallbackURLs": {
                return Optional.ofNullable(clazz.cast(this.callbackURLs()));
            }
            case "LogoutURLs": {
                return Optional.ofNullable(clazz.cast(this.logoutURLs()));
            }
            case "DefaultRedirectURI": {
                return Optional.ofNullable(clazz.cast(this.defaultRedirectURI()));
            }
            case "AllowedOAuthFlows": {
                return Optional.ofNullable(clazz.cast(this.allowedOAuthFlowsAsStrings()));
            }
            case "AllowedOAuthScopes": {
                return Optional.ofNullable(clazz.cast(this.allowedOAuthScopes()));
            }
            case "AllowedOAuthFlowsUserPoolClient": {
                return Optional.ofNullable(clazz.cast(this.allowedOAuthFlowsUserPoolClient()));
            }
            case "AnalyticsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.analyticsConfiguration()));
            }
            case "PreventUserExistenceErrors": {
                return Optional.ofNullable(clazz.cast(this.preventUserExistenceErrorsAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserPoolClientType, T> g) {
        return obj -> g.apply((UserPoolClientType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userPoolId;
        private String clientName;
        private String clientId;
        private String clientSecret;
        private Instant lastModifiedDate;
        private Instant creationDate;
        private Integer refreshTokenValidity;
        private Integer accessTokenValidity;
        private Integer idTokenValidity;
        private TokenValidityUnitsType tokenValidityUnits;
        private List<String> readAttributes = DefaultSdkAutoConstructList.getInstance();
        private List<String> writeAttributes = DefaultSdkAutoConstructList.getInstance();
        private List<String> explicitAuthFlows = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedIdentityProviders = DefaultSdkAutoConstructList.getInstance();
        private List<String> callbackURLs = DefaultSdkAutoConstructList.getInstance();
        private List<String> logoutURLs = DefaultSdkAutoConstructList.getInstance();
        private String defaultRedirectURI;
        private List<String> allowedOAuthFlows = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedOAuthScopes = DefaultSdkAutoConstructList.getInstance();
        private Boolean allowedOAuthFlowsUserPoolClient;
        private AnalyticsConfigurationType analyticsConfiguration;
        private String preventUserExistenceErrors;

        private BuilderImpl() {
        }

        private BuilderImpl(UserPoolClientType model) {
            this.userPoolId(model.userPoolId);
            this.clientName(model.clientName);
            this.clientId(model.clientId);
            this.clientSecret(model.clientSecret);
            this.lastModifiedDate(model.lastModifiedDate);
            this.creationDate(model.creationDate);
            this.refreshTokenValidity(model.refreshTokenValidity);
            this.accessTokenValidity(model.accessTokenValidity);
            this.idTokenValidity(model.idTokenValidity);
            this.tokenValidityUnits(model.tokenValidityUnits);
            this.readAttributes(model.readAttributes);
            this.writeAttributes(model.writeAttributes);
            this.explicitAuthFlowsWithStrings(model.explicitAuthFlows);
            this.supportedIdentityProviders(model.supportedIdentityProviders);
            this.callbackURLs(model.callbackURLs);
            this.logoutURLs(model.logoutURLs);
            this.defaultRedirectURI(model.defaultRedirectURI);
            this.allowedOAuthFlowsWithStrings(model.allowedOAuthFlows);
            this.allowedOAuthScopes(model.allowedOAuthScopes);
            this.allowedOAuthFlowsUserPoolClient(model.allowedOAuthFlowsUserPoolClient);
            this.analyticsConfiguration(model.analyticsConfiguration);
            this.preventUserExistenceErrors(model.preventUserExistenceErrors);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getClientName() {
            return this.clientName;
        }

        @Override
        public final Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public final void setClientName(String clientName) {
            this.clientName = clientName;
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getClientSecret() {
            return this.clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Integer getRefreshTokenValidity() {
            return this.refreshTokenValidity;
        }

        @Override
        public final Builder refreshTokenValidity(Integer refreshTokenValidity) {
            this.refreshTokenValidity = refreshTokenValidity;
            return this;
        }

        public final void setRefreshTokenValidity(Integer refreshTokenValidity) {
            this.refreshTokenValidity = refreshTokenValidity;
        }

        public final Integer getAccessTokenValidity() {
            return this.accessTokenValidity;
        }

        @Override
        public final Builder accessTokenValidity(Integer accessTokenValidity) {
            this.accessTokenValidity = accessTokenValidity;
            return this;
        }

        public final void setAccessTokenValidity(Integer accessTokenValidity) {
            this.accessTokenValidity = accessTokenValidity;
        }

        public final Integer getIdTokenValidity() {
            return this.idTokenValidity;
        }

        @Override
        public final Builder idTokenValidity(Integer idTokenValidity) {
            this.idTokenValidity = idTokenValidity;
            return this;
        }

        public final void setIdTokenValidity(Integer idTokenValidity) {
            this.idTokenValidity = idTokenValidity;
        }

        public final TokenValidityUnitsType.Builder getTokenValidityUnits() {
            return this.tokenValidityUnits != null ? this.tokenValidityUnits.toBuilder() : null;
        }

        @Override
        public final Builder tokenValidityUnits(TokenValidityUnitsType tokenValidityUnits) {
            this.tokenValidityUnits = tokenValidityUnits;
            return this;
        }

        public final void setTokenValidityUnits(TokenValidityUnitsType.BuilderImpl tokenValidityUnits) {
            this.tokenValidityUnits = tokenValidityUnits != null ? tokenValidityUnits.build() : null;
        }

        public final Collection<String> getReadAttributes() {
            return this.readAttributes;
        }

        @Override
        public final Builder readAttributes(Collection<String> readAttributes) {
            this.readAttributes = ClientPermissionListTypeCopier.copy(readAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readAttributes(String ... readAttributes) {
            this.readAttributes(Arrays.asList(readAttributes));
            return this;
        }

        public final void setReadAttributes(Collection<String> readAttributes) {
            this.readAttributes = ClientPermissionListTypeCopier.copy(readAttributes);
        }

        public final Collection<String> getWriteAttributes() {
            return this.writeAttributes;
        }

        @Override
        public final Builder writeAttributes(Collection<String> writeAttributes) {
            this.writeAttributes = ClientPermissionListTypeCopier.copy(writeAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder writeAttributes(String ... writeAttributes) {
            this.writeAttributes(Arrays.asList(writeAttributes));
            return this;
        }

        public final void setWriteAttributes(Collection<String> writeAttributes) {
            this.writeAttributes = ClientPermissionListTypeCopier.copy(writeAttributes);
        }

        public final Collection<String> getExplicitAuthFlows() {
            return this.explicitAuthFlows;
        }

        @Override
        public final Builder explicitAuthFlowsWithStrings(Collection<String> explicitAuthFlows) {
            this.explicitAuthFlows = ExplicitAuthFlowsListTypeCopier.copy(explicitAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explicitAuthFlowsWithStrings(String ... explicitAuthFlows) {
            this.explicitAuthFlowsWithStrings(Arrays.asList(explicitAuthFlows));
            return this;
        }

        @Override
        public final Builder explicitAuthFlows(Collection<ExplicitAuthFlowsType> explicitAuthFlows) {
            this.explicitAuthFlows = ExplicitAuthFlowsListTypeCopier.copyEnumToString(explicitAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explicitAuthFlows(ExplicitAuthFlowsType ... explicitAuthFlows) {
            this.explicitAuthFlows(Arrays.asList(explicitAuthFlows));
            return this;
        }

        public final void setExplicitAuthFlows(Collection<String> explicitAuthFlows) {
            this.explicitAuthFlows = ExplicitAuthFlowsListTypeCopier.copy(explicitAuthFlows);
        }

        public final Collection<String> getSupportedIdentityProviders() {
            return this.supportedIdentityProviders;
        }

        @Override
        public final Builder supportedIdentityProviders(Collection<String> supportedIdentityProviders) {
            this.supportedIdentityProviders = SupportedIdentityProvidersListTypeCopier.copy(supportedIdentityProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedIdentityProviders(String ... supportedIdentityProviders) {
            this.supportedIdentityProviders(Arrays.asList(supportedIdentityProviders));
            return this;
        }

        public final void setSupportedIdentityProviders(Collection<String> supportedIdentityProviders) {
            this.supportedIdentityProviders = SupportedIdentityProvidersListTypeCopier.copy(supportedIdentityProviders);
        }

        public final Collection<String> getCallbackURLs() {
            return this.callbackURLs;
        }

        @Override
        public final Builder callbackURLs(Collection<String> callbackURLs) {
            this.callbackURLs = CallbackURLsListTypeCopier.copy(callbackURLs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callbackURLs(String ... callbackURLs) {
            this.callbackURLs(Arrays.asList(callbackURLs));
            return this;
        }

        public final void setCallbackURLs(Collection<String> callbackURLs) {
            this.callbackURLs = CallbackURLsListTypeCopier.copy(callbackURLs);
        }

        public final Collection<String> getLogoutURLs() {
            return this.logoutURLs;
        }

        @Override
        public final Builder logoutURLs(Collection<String> logoutURLs) {
            this.logoutURLs = LogoutURLsListTypeCopier.copy(logoutURLs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logoutURLs(String ... logoutURLs) {
            this.logoutURLs(Arrays.asList(logoutURLs));
            return this;
        }

        public final void setLogoutURLs(Collection<String> logoutURLs) {
            this.logoutURLs = LogoutURLsListTypeCopier.copy(logoutURLs);
        }

        public final String getDefaultRedirectURI() {
            return this.defaultRedirectURI;
        }

        @Override
        public final Builder defaultRedirectURI(String defaultRedirectURI) {
            this.defaultRedirectURI = defaultRedirectURI;
            return this;
        }

        public final void setDefaultRedirectURI(String defaultRedirectURI) {
            this.defaultRedirectURI = defaultRedirectURI;
        }

        public final Collection<String> getAllowedOAuthFlows() {
            return this.allowedOAuthFlows;
        }

        @Override
        public final Builder allowedOAuthFlowsWithStrings(Collection<String> allowedOAuthFlows) {
            this.allowedOAuthFlows = OAuthFlowsTypeCopier.copy(allowedOAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOAuthFlowsWithStrings(String ... allowedOAuthFlows) {
            this.allowedOAuthFlowsWithStrings(Arrays.asList(allowedOAuthFlows));
            return this;
        }

        @Override
        public final Builder allowedOAuthFlows(Collection<OAuthFlowType> allowedOAuthFlows) {
            this.allowedOAuthFlows = OAuthFlowsTypeCopier.copyEnumToString(allowedOAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOAuthFlows(OAuthFlowType ... allowedOAuthFlows) {
            this.allowedOAuthFlows(Arrays.asList(allowedOAuthFlows));
            return this;
        }

        public final void setAllowedOAuthFlows(Collection<String> allowedOAuthFlows) {
            this.allowedOAuthFlows = OAuthFlowsTypeCopier.copy(allowedOAuthFlows);
        }

        public final Collection<String> getAllowedOAuthScopes() {
            return this.allowedOAuthScopes;
        }

        @Override
        public final Builder allowedOAuthScopes(Collection<String> allowedOAuthScopes) {
            this.allowedOAuthScopes = ScopeListTypeCopier.copy(allowedOAuthScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOAuthScopes(String ... allowedOAuthScopes) {
            this.allowedOAuthScopes(Arrays.asList(allowedOAuthScopes));
            return this;
        }

        public final void setAllowedOAuthScopes(Collection<String> allowedOAuthScopes) {
            this.allowedOAuthScopes = ScopeListTypeCopier.copy(allowedOAuthScopes);
        }

        public final Boolean getAllowedOAuthFlowsUserPoolClient() {
            return this.allowedOAuthFlowsUserPoolClient;
        }

        @Override
        public final Builder allowedOAuthFlowsUserPoolClient(Boolean allowedOAuthFlowsUserPoolClient) {
            this.allowedOAuthFlowsUserPoolClient = allowedOAuthFlowsUserPoolClient;
            return this;
        }

        public final void setAllowedOAuthFlowsUserPoolClient(Boolean allowedOAuthFlowsUserPoolClient) {
            this.allowedOAuthFlowsUserPoolClient = allowedOAuthFlowsUserPoolClient;
        }

        public final AnalyticsConfigurationType.Builder getAnalyticsConfiguration() {
            return this.analyticsConfiguration != null ? this.analyticsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder analyticsConfiguration(AnalyticsConfigurationType analyticsConfiguration) {
            this.analyticsConfiguration = analyticsConfiguration;
            return this;
        }

        public final void setAnalyticsConfiguration(AnalyticsConfigurationType.BuilderImpl analyticsConfiguration) {
            this.analyticsConfiguration = analyticsConfiguration != null ? analyticsConfiguration.build() : null;
        }

        public final String getPreventUserExistenceErrors() {
            return this.preventUserExistenceErrors;
        }

        @Override
        public final Builder preventUserExistenceErrors(String preventUserExistenceErrors) {
            this.preventUserExistenceErrors = preventUserExistenceErrors;
            return this;
        }

        @Override
        public final Builder preventUserExistenceErrors(PreventUserExistenceErrorTypes preventUserExistenceErrors) {
            this.preventUserExistenceErrors(preventUserExistenceErrors == null ? null : preventUserExistenceErrors.toString());
            return this;
        }

        public final void setPreventUserExistenceErrors(String preventUserExistenceErrors) {
            this.preventUserExistenceErrors = preventUserExistenceErrors;
        }

        public UserPoolClientType build() {
            return new UserPoolClientType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserPoolClientType> {
        public Builder userPoolId(String var1);

        public Builder clientName(String var1);

        public Builder clientId(String var1);

        public Builder clientSecret(String var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder creationDate(Instant var1);

        public Builder refreshTokenValidity(Integer var1);

        public Builder accessTokenValidity(Integer var1);

        public Builder idTokenValidity(Integer var1);

        public Builder tokenValidityUnits(TokenValidityUnitsType var1);

        default public Builder tokenValidityUnits(Consumer<TokenValidityUnitsType.Builder> tokenValidityUnits) {
            return this.tokenValidityUnits((TokenValidityUnitsType)((TokenValidityUnitsType.Builder)TokenValidityUnitsType.builder().applyMutation(tokenValidityUnits)).build());
        }

        public Builder readAttributes(Collection<String> var1);

        public Builder readAttributes(String ... var1);

        public Builder writeAttributes(Collection<String> var1);

        public Builder writeAttributes(String ... var1);

        public Builder explicitAuthFlowsWithStrings(Collection<String> var1);

        public Builder explicitAuthFlowsWithStrings(String ... var1);

        public Builder explicitAuthFlows(Collection<ExplicitAuthFlowsType> var1);

        public Builder explicitAuthFlows(ExplicitAuthFlowsType ... var1);

        public Builder supportedIdentityProviders(Collection<String> var1);

        public Builder supportedIdentityProviders(String ... var1);

        public Builder callbackURLs(Collection<String> var1);

        public Builder callbackURLs(String ... var1);

        public Builder logoutURLs(Collection<String> var1);

        public Builder logoutURLs(String ... var1);

        public Builder defaultRedirectURI(String var1);

        public Builder allowedOAuthFlowsWithStrings(Collection<String> var1);

        public Builder allowedOAuthFlowsWithStrings(String ... var1);

        public Builder allowedOAuthFlows(Collection<OAuthFlowType> var1);

        public Builder allowedOAuthFlows(OAuthFlowType ... var1);

        public Builder allowedOAuthScopes(Collection<String> var1);

        public Builder allowedOAuthScopes(String ... var1);

        public Builder allowedOAuthFlowsUserPoolClient(Boolean var1);

        public Builder analyticsConfiguration(AnalyticsConfigurationType var1);

        default public Builder analyticsConfiguration(Consumer<AnalyticsConfigurationType.Builder> analyticsConfiguration) {
            return this.analyticsConfiguration((AnalyticsConfigurationType)((AnalyticsConfigurationType.Builder)AnalyticsConfigurationType.builder().applyMutation(analyticsConfiguration)).build());
        }

        public Builder preventUserExistenceErrors(String var1);

        public Builder preventUserExistenceErrors(PreventUserExistenceErrorTypes var1);
    }
}

