/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponseListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponseType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EventContextDataType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EventFeedbackType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EventRiskType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthEventType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthEventType> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventId").getter(AuthEventType.getter(AuthEventType::eventId)).setter(AuthEventType.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventType").getter(AuthEventType.getter(AuthEventType::eventTypeAsString)).setter(AuthEventType.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(AuthEventType.getter(AuthEventType::creationDate)).setter(AuthEventType.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> EVENT_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventResponse").getter(AuthEventType.getter(AuthEventType::eventResponseAsString)).setter(AuthEventType.setter(Builder::eventResponse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventResponse").build()}).build();
    private static final SdkField<EventRiskType> EVENT_RISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EventRisk").getter(AuthEventType.getter(AuthEventType::eventRisk)).setter(AuthEventType.setter(Builder::eventRisk)).constructor(EventRiskType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventRisk").build()}).build();
    private static final SdkField<List<ChallengeResponseType>> CHALLENGE_RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChallengeResponses").getter(AuthEventType.getter(AuthEventType::challengeResponses)).setter(AuthEventType.setter(Builder::challengeResponses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeResponses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChallengeResponseType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EventContextDataType> EVENT_CONTEXT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EventContextData").getter(AuthEventType.getter(AuthEventType::eventContextData)).setter(AuthEventType.setter(Builder::eventContextData)).constructor(EventContextDataType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventContextData").build()}).build();
    private static final SdkField<EventFeedbackType> EVENT_FEEDBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EventFeedback").getter(AuthEventType.getter(AuthEventType::eventFeedback)).setter(AuthEventType.setter(Builder::eventFeedback)).constructor(EventFeedbackType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventFeedback").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD, EVENT_TYPE_FIELD, CREATION_DATE_FIELD, EVENT_RESPONSE_FIELD, EVENT_RISK_FIELD, CHALLENGE_RESPONSES_FIELD, EVENT_CONTEXT_DATA_FIELD, EVENT_FEEDBACK_FIELD));
    private static final long serialVersionUID = 1L;
    private final String eventId;
    private final String eventType;
    private final Instant creationDate;
    private final String eventResponse;
    private final EventRiskType eventRisk;
    private final List<ChallengeResponseType> challengeResponses;
    private final EventContextDataType eventContextData;
    private final EventFeedbackType eventFeedback;

    private AuthEventType(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.eventType = builder.eventType;
        this.creationDate = builder.creationDate;
        this.eventResponse = builder.eventResponse;
        this.eventRisk = builder.eventRisk;
        this.challengeResponses = builder.challengeResponses;
        this.eventContextData = builder.eventContextData;
        this.eventFeedback = builder.eventFeedback;
    }

    public String eventId() {
        return this.eventId;
    }

    public EventType eventType() {
        return EventType.fromValue(this.eventType);
    }

    public String eventTypeAsString() {
        return this.eventType;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public EventResponseType eventResponse() {
        return EventResponseType.fromValue(this.eventResponse);
    }

    public String eventResponseAsString() {
        return this.eventResponse;
    }

    public EventRiskType eventRisk() {
        return this.eventRisk;
    }

    public boolean hasChallengeResponses() {
        return this.challengeResponses != null && !(this.challengeResponses instanceof SdkAutoConstructList);
    }

    public List<ChallengeResponseType> challengeResponses() {
        return this.challengeResponses;
    }

    public EventContextDataType eventContextData() {
        return this.eventContextData;
    }

    public EventFeedbackType eventFeedback() {
        return this.eventFeedback;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventResponseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventRisk());
        hashCode = 31 * hashCode + Objects.hashCode(this.challengeResponses());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventContextData());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventFeedback());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthEventType)) {
            return false;
        }
        AuthEventType other = (AuthEventType)obj;
        return Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.eventResponseAsString(), other.eventResponseAsString()) && Objects.equals(this.eventRisk(), other.eventRisk()) && Objects.equals(this.challengeResponses(), other.challengeResponses()) && Objects.equals(this.eventContextData(), other.eventContextData()) && Objects.equals(this.eventFeedback(), other.eventFeedback());
    }

    public String toString() {
        return ToString.builder((String)"AuthEventType").add("EventId", (Object)this.eventId()).add("EventType", (Object)this.eventTypeAsString()).add("CreationDate", (Object)this.creationDate()).add("EventResponse", (Object)this.eventResponseAsString()).add("EventRisk", (Object)this.eventRisk()).add("ChallengeResponses", this.challengeResponses()).add("EventContextData", (Object)this.eventContextData()).add("EventFeedback", (Object)this.eventFeedback()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "EventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "EventResponse": {
                return Optional.ofNullable(clazz.cast(this.eventResponseAsString()));
            }
            case "EventRisk": {
                return Optional.ofNullable(clazz.cast(this.eventRisk()));
            }
            case "ChallengeResponses": {
                return Optional.ofNullable(clazz.cast(this.challengeResponses()));
            }
            case "EventContextData": {
                return Optional.ofNullable(clazz.cast(this.eventContextData()));
            }
            case "EventFeedback": {
                return Optional.ofNullable(clazz.cast(this.eventFeedback()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthEventType, T> g) {
        return obj -> g.apply((AuthEventType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventId;
        private String eventType;
        private Instant creationDate;
        private String eventResponse;
        private EventRiskType eventRisk;
        private List<ChallengeResponseType> challengeResponses = DefaultSdkAutoConstructList.getInstance();
        private EventContextDataType eventContextData;
        private EventFeedbackType eventFeedback;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthEventType model) {
            this.eventId(model.eventId);
            this.eventType(model.eventType);
            this.creationDate(model.creationDate);
            this.eventResponse(model.eventResponse);
            this.eventRisk(model.eventRisk);
            this.challengeResponses(model.challengeResponses);
            this.eventContextData(model.eventContextData);
            this.eventFeedback(model.eventFeedback);
        }

        public final String getEventId() {
            return this.eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getEventType() {
            return this.eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getEventResponse() {
            return this.eventResponse;
        }

        @Override
        public final Builder eventResponse(String eventResponse) {
            this.eventResponse = eventResponse;
            return this;
        }

        @Override
        public final Builder eventResponse(EventResponseType eventResponse) {
            this.eventResponse(eventResponse == null ? null : eventResponse.toString());
            return this;
        }

        public final void setEventResponse(String eventResponse) {
            this.eventResponse = eventResponse;
        }

        public final EventRiskType.Builder getEventRisk() {
            return this.eventRisk != null ? this.eventRisk.toBuilder() : null;
        }

        @Override
        public final Builder eventRisk(EventRiskType eventRisk) {
            this.eventRisk = eventRisk;
            return this;
        }

        public final void setEventRisk(EventRiskType.BuilderImpl eventRisk) {
            this.eventRisk = eventRisk != null ? eventRisk.build() : null;
        }

        public final Collection<ChallengeResponseType.Builder> getChallengeResponses() {
            return this.challengeResponses != null ? (Collection)this.challengeResponses.stream().map(ChallengeResponseType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder challengeResponses(Collection<ChallengeResponseType> challengeResponses) {
            this.challengeResponses = ChallengeResponseListTypeCopier.copy(challengeResponses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder challengeResponses(ChallengeResponseType ... challengeResponses) {
            this.challengeResponses(Arrays.asList(challengeResponses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder challengeResponses(Consumer<ChallengeResponseType.Builder> ... challengeResponses) {
            this.challengeResponses(Stream.of(challengeResponses).map(c -> (ChallengeResponseType)((ChallengeResponseType.Builder)ChallengeResponseType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setChallengeResponses(Collection<ChallengeResponseType.BuilderImpl> challengeResponses) {
            this.challengeResponses = ChallengeResponseListTypeCopier.copyFromBuilder(challengeResponses);
        }

        public final EventContextDataType.Builder getEventContextData() {
            return this.eventContextData != null ? this.eventContextData.toBuilder() : null;
        }

        @Override
        public final Builder eventContextData(EventContextDataType eventContextData) {
            this.eventContextData = eventContextData;
            return this;
        }

        public final void setEventContextData(EventContextDataType.BuilderImpl eventContextData) {
            this.eventContextData = eventContextData != null ? eventContextData.build() : null;
        }

        public final EventFeedbackType.Builder getEventFeedback() {
            return this.eventFeedback != null ? this.eventFeedback.toBuilder() : null;
        }

        @Override
        public final Builder eventFeedback(EventFeedbackType eventFeedback) {
            this.eventFeedback = eventFeedback;
            return this;
        }

        public final void setEventFeedback(EventFeedbackType.BuilderImpl eventFeedback) {
            this.eventFeedback = eventFeedback != null ? eventFeedback.build() : null;
        }

        public AuthEventType build() {
            return new AuthEventType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthEventType> {
        public Builder eventId(String var1);

        public Builder eventType(String var1);

        public Builder eventType(EventType var1);

        public Builder creationDate(Instant var1);

        public Builder eventResponse(String var1);

        public Builder eventResponse(EventResponseType var1);

        public Builder eventRisk(EventRiskType var1);

        default public Builder eventRisk(Consumer<EventRiskType.Builder> eventRisk) {
            return this.eventRisk((EventRiskType)((EventRiskType.Builder)EventRiskType.builder().applyMutation(eventRisk)).build());
        }

        public Builder challengeResponses(Collection<ChallengeResponseType> var1);

        public Builder challengeResponses(ChallengeResponseType ... var1);

        public Builder challengeResponses(Consumer<ChallengeResponseType.Builder> ... var1);

        public Builder eventContextData(EventContextDataType var1);

        default public Builder eventContextData(Consumer<EventContextDataType.Builder> eventContextData) {
            return this.eventContextData((EventContextDataType)((EventContextDataType.Builder)EventContextDataType.builder().applyMutation(eventContextData)).build());
        }

        public Builder eventFeedback(EventFeedbackType var1);

        default public Builder eventFeedback(Consumer<EventFeedbackType.Builder> eventFeedback) {
            return this.eventFeedback((EventFeedbackType)((EventFeedbackType.Builder)EventFeedbackType.builder().applyMutation(eventFeedback)).build());
        }
    }
}

