/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TimeUnitsType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TokenValidityUnitsType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TokenValidityUnitsType> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TokenValidityUnitsType.getter(TokenValidityUnitsType::accessTokenAsString)).setter(TokenValidityUnitsType.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()}).build();
    private static final SdkField<String> ID_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TokenValidityUnitsType.getter(TokenValidityUnitsType::idTokenAsString)).setter(TokenValidityUnitsType.setter(Builder::idToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdToken").build()}).build();
    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TokenValidityUnitsType.getter(TokenValidityUnitsType::refreshTokenAsString)).setter(TokenValidityUnitsType.setter(Builder::refreshToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD, ID_TOKEN_FIELD, REFRESH_TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accessToken;
    private final String idToken;
    private final String refreshToken;

    private TokenValidityUnitsType(BuilderImpl builder) {
        this.accessToken = builder.accessToken;
        this.idToken = builder.idToken;
        this.refreshToken = builder.refreshToken;
    }

    public TimeUnitsType accessToken() {
        return TimeUnitsType.fromValue(this.accessToken);
    }

    public String accessTokenAsString() {
        return this.accessToken;
    }

    public TimeUnitsType idToken() {
        return TimeUnitsType.fromValue(this.idToken);
    }

    public String idTokenAsString() {
        return this.idToken;
    }

    public TimeUnitsType refreshToken() {
        return TimeUnitsType.fromValue(this.refreshToken);
    }

    public String refreshTokenAsString() {
        return this.refreshToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessTokenAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.idTokenAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshTokenAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TokenValidityUnitsType)) {
            return false;
        }
        TokenValidityUnitsType other = (TokenValidityUnitsType)obj;
        return Objects.equals(this.accessTokenAsString(), other.accessTokenAsString()) && Objects.equals(this.idTokenAsString(), other.idTokenAsString()) && Objects.equals(this.refreshTokenAsString(), other.refreshTokenAsString());
    }

    public String toString() {
        return ToString.builder((String)"TokenValidityUnitsType").add("AccessToken", (Object)this.accessTokenAsString()).add("IdToken", (Object)this.idTokenAsString()).add("RefreshToken", (Object)this.refreshTokenAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessToken": {
                return Optional.ofNullable(clazz.cast(this.accessTokenAsString()));
            }
            case "IdToken": {
                return Optional.ofNullable(clazz.cast(this.idTokenAsString()));
            }
            case "RefreshToken": {
                return Optional.ofNullable(clazz.cast(this.refreshTokenAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TokenValidityUnitsType, T> g) {
        return obj -> g.apply((TokenValidityUnitsType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessToken;
        private String idToken;
        private String refreshToken;

        private BuilderImpl() {
        }

        private BuilderImpl(TokenValidityUnitsType model) {
            this.accessToken(model.accessToken);
            this.idToken(model.idToken);
            this.refreshToken(model.refreshToken);
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @Override
        public final Builder accessToken(TimeUnitsType accessToken) {
            this.accessToken(accessToken == null ? null : accessToken.toString());
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public final String getIdToken() {
            return this.idToken;
        }

        @Override
        public final Builder idToken(String idToken) {
            this.idToken = idToken;
            return this;
        }

        @Override
        public final Builder idToken(TimeUnitsType idToken) {
            this.idToken(idToken == null ? null : idToken.toString());
            return this;
        }

        public final void setIdToken(String idToken) {
            this.idToken = idToken;
        }

        public final String getRefreshToken() {
            return this.refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        @Override
        public final Builder refreshToken(TimeUnitsType refreshToken) {
            this.refreshToken(refreshToken == null ? null : refreshToken.toString());
            return this;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        public TokenValidityUnitsType build() {
            return new TokenValidityUnitsType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TokenValidityUnitsType> {
        public Builder accessToken(String var1);

        public Builder accessToken(TimeUnitsType var1);

        public Builder idToken(String var1);

        public Builder idToken(TimeUnitsType var1);

        public Builder refreshToken(String var1);

        public Builder refreshToken(TimeUnitsType var1);
    }
}

