/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SmsMfaConfigType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SoftwareTokenMfaConfigType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolMfaType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUserPoolMfaConfigResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, GetUserPoolMfaConfigResponse> {
    private static final SdkField<SmsMfaConfigType> SMS_MFA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetUserPoolMfaConfigResponse.getter(GetUserPoolMfaConfigResponse::smsMfaConfiguration)).setter(GetUserPoolMfaConfigResponse.setter(Builder::smsMfaConfiguration)).constructor(SmsMfaConfigType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsMfaConfiguration").build()}).build();
    private static final SdkField<SoftwareTokenMfaConfigType> SOFTWARE_TOKEN_MFA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetUserPoolMfaConfigResponse.getter(GetUserPoolMfaConfigResponse::softwareTokenMfaConfiguration)).setter(GetUserPoolMfaConfigResponse.setter(Builder::softwareTokenMfaConfiguration)).constructor(SoftwareTokenMfaConfigType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareTokenMfaConfiguration").build()}).build();
    private static final SdkField<String> MFA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetUserPoolMfaConfigResponse.getter(GetUserPoolMfaConfigResponse::mfaConfigurationAsString)).setter(GetUserPoolMfaConfigResponse.setter(Builder::mfaConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MfaConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMS_MFA_CONFIGURATION_FIELD, SOFTWARE_TOKEN_MFA_CONFIGURATION_FIELD, MFA_CONFIGURATION_FIELD));
    private final SmsMfaConfigType smsMfaConfiguration;
    private final SoftwareTokenMfaConfigType softwareTokenMfaConfiguration;
    private final String mfaConfiguration;

    private GetUserPoolMfaConfigResponse(BuilderImpl builder) {
        super(builder);
        this.smsMfaConfiguration = builder.smsMfaConfiguration;
        this.softwareTokenMfaConfiguration = builder.softwareTokenMfaConfiguration;
        this.mfaConfiguration = builder.mfaConfiguration;
    }

    public SmsMfaConfigType smsMfaConfiguration() {
        return this.smsMfaConfiguration;
    }

    public SoftwareTokenMfaConfigType softwareTokenMfaConfiguration() {
        return this.softwareTokenMfaConfiguration;
    }

    public UserPoolMfaType mfaConfiguration() {
        return UserPoolMfaType.fromValue(this.mfaConfiguration);
    }

    public String mfaConfigurationAsString() {
        return this.mfaConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.smsMfaConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareTokenMfaConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.mfaConfigurationAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserPoolMfaConfigResponse)) {
            return false;
        }
        GetUserPoolMfaConfigResponse other = (GetUserPoolMfaConfigResponse)((Object)obj);
        return Objects.equals(this.smsMfaConfiguration(), other.smsMfaConfiguration()) && Objects.equals(this.softwareTokenMfaConfiguration(), other.softwareTokenMfaConfiguration()) && Objects.equals(this.mfaConfigurationAsString(), other.mfaConfigurationAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetUserPoolMfaConfigResponse").add("SmsMfaConfiguration", (Object)this.smsMfaConfiguration()).add("SoftwareTokenMfaConfiguration", (Object)this.softwareTokenMfaConfiguration()).add("MfaConfiguration", (Object)this.mfaConfigurationAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SmsMfaConfiguration": {
                return Optional.ofNullable(clazz.cast(this.smsMfaConfiguration()));
            }
            case "SoftwareTokenMfaConfiguration": {
                return Optional.ofNullable(clazz.cast(this.softwareTokenMfaConfiguration()));
            }
            case "MfaConfiguration": {
                return Optional.ofNullable(clazz.cast(this.mfaConfigurationAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUserPoolMfaConfigResponse, T> g) {
        return obj -> g.apply((GetUserPoolMfaConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private SmsMfaConfigType smsMfaConfiguration;
        private SoftwareTokenMfaConfigType softwareTokenMfaConfiguration;
        private String mfaConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUserPoolMfaConfigResponse model) {
            super(model);
            this.smsMfaConfiguration(model.smsMfaConfiguration);
            this.softwareTokenMfaConfiguration(model.softwareTokenMfaConfiguration);
            this.mfaConfiguration(model.mfaConfiguration);
        }

        public final SmsMfaConfigType.Builder getSmsMfaConfiguration() {
            return this.smsMfaConfiguration != null ? this.smsMfaConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder smsMfaConfiguration(SmsMfaConfigType smsMfaConfiguration) {
            this.smsMfaConfiguration = smsMfaConfiguration;
            return this;
        }

        public final void setSmsMfaConfiguration(SmsMfaConfigType.BuilderImpl smsMfaConfiguration) {
            this.smsMfaConfiguration = smsMfaConfiguration != null ? smsMfaConfiguration.build() : null;
        }

        public final SoftwareTokenMfaConfigType.Builder getSoftwareTokenMfaConfiguration() {
            return this.softwareTokenMfaConfiguration != null ? this.softwareTokenMfaConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder softwareTokenMfaConfiguration(SoftwareTokenMfaConfigType softwareTokenMfaConfiguration) {
            this.softwareTokenMfaConfiguration = softwareTokenMfaConfiguration;
            return this;
        }

        public final void setSoftwareTokenMfaConfiguration(SoftwareTokenMfaConfigType.BuilderImpl softwareTokenMfaConfiguration) {
            this.softwareTokenMfaConfiguration = softwareTokenMfaConfiguration != null ? softwareTokenMfaConfiguration.build() : null;
        }

        public final String getMfaConfiguration() {
            return this.mfaConfiguration;
        }

        @Override
        public final Builder mfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
            return this;
        }

        @Override
        public final Builder mfaConfiguration(UserPoolMfaType mfaConfiguration) {
            this.mfaConfiguration(mfaConfiguration == null ? null : mfaConfiguration.toString());
            return this;
        }

        public final void setMfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
        }

        @Override
        public GetUserPoolMfaConfigResponse build() {
            return new GetUserPoolMfaConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUserPoolMfaConfigResponse> {
        public Builder smsMfaConfiguration(SmsMfaConfigType var1);

        default public Builder smsMfaConfiguration(Consumer<SmsMfaConfigType.Builder> smsMfaConfiguration) {
            return this.smsMfaConfiguration((SmsMfaConfigType)((SmsMfaConfigType.Builder)SmsMfaConfigType.builder().applyMutation(smsMfaConfiguration)).build());
        }

        public Builder softwareTokenMfaConfiguration(SoftwareTokenMfaConfigType var1);

        default public Builder softwareTokenMfaConfiguration(Consumer<SoftwareTokenMfaConfigType.Builder> softwareTokenMfaConfiguration) {
            return this.softwareTokenMfaConfiguration((SoftwareTokenMfaConfigType)((SoftwareTokenMfaConfigType.Builder)SoftwareTokenMfaConfigType.builder().applyMutation(softwareTokenMfaConfiguration)).build());
        }

        public Builder mfaConfiguration(String var1);

        public Builder mfaConfiguration(UserPoolMfaType var1);
    }
}

