/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerScopeListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerScopeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResourceServerRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, CreateResourceServerRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateResourceServerRequest.getter(CreateResourceServerRequest::userPoolId)).setter(CreateResourceServerRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateResourceServerRequest.getter(CreateResourceServerRequest::identifier)).setter(CreateResourceServerRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateResourceServerRequest.getter(CreateResourceServerRequest::name)).setter(CreateResourceServerRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<ResourceServerScopeType>> SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateResourceServerRequest.getter(CreateResourceServerRequest::scopes)).setter(CreateResourceServerRequest.setter(Builder::scopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceServerScopeType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, IDENTIFIER_FIELD, NAME_FIELD, SCOPES_FIELD));
    private final String userPoolId;
    private final String identifier;
    private final String name;
    private final List<ResourceServerScopeType> scopes;

    private CreateResourceServerRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.scopes = builder.scopes;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String identifier() {
        return this.identifier;
    }

    public String name() {
        return this.name;
    }

    public boolean hasScopes() {
        return this.scopes != null && !(this.scopes instanceof SdkAutoConstructList);
    }

    public List<ResourceServerScopeType> scopes() {
        return this.scopes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceServerRequest)) {
            return false;
        }
        CreateResourceServerRequest other = (CreateResourceServerRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.scopes(), other.scopes());
    }

    public String toString() {
        return ToString.builder((String)"CreateResourceServerRequest").add("UserPoolId", (Object)this.userPoolId()).add("Identifier", (Object)this.identifier()).add("Name", (Object)this.name()).add("Scopes", this.scopes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Scopes": {
                return Optional.ofNullable(clazz.cast(this.scopes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceServerRequest, T> g) {
        return obj -> g.apply((CreateResourceServerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private String identifier;
        private String name;
        private List<ResourceServerScopeType> scopes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceServerRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.identifier(model.identifier);
            this.name(model.name);
            this.scopes(model.scopes);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<ResourceServerScopeType.Builder> getScopes() {
            return this.scopes != null ? (Collection)this.scopes.stream().map(ResourceServerScopeType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scopes(Collection<ResourceServerScopeType> scopes) {
            this.scopes = ResourceServerScopeListTypeCopier.copy(scopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(ResourceServerScopeType ... scopes) {
            this.scopes(Arrays.asList(scopes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(Consumer<ResourceServerScopeType.Builder> ... scopes) {
            this.scopes(Stream.of(scopes).map(c -> (ResourceServerScopeType)((ResourceServerScopeType.Builder)ResourceServerScopeType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setScopes(Collection<ResourceServerScopeType.BuilderImpl> scopes) {
            this.scopes = ResourceServerScopeListTypeCopier.copyFromBuilder(scopes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceServerRequest build() {
            return new CreateResourceServerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateResourceServerRequest> {
        public Builder userPoolId(String var1);

        public Builder identifier(String var1);

        public Builder name(String var1);

        public Builder scopes(Collection<ResourceServerScopeType> var1);

        public Builder scopes(ResourceServerScopeType ... var1);

        public Builder scopes(Consumer<ResourceServerScopeType.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

