/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The constraints associated with a string attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StringAttributeConstraintsType implements SdkPojo, Serializable,
        ToCopyableBuilder<StringAttributeConstraintsType.Builder, StringAttributeConstraintsType> {
    private static final SdkField<String> MIN_LENGTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StringAttributeConstraintsType::minLength)).setter(setter(Builder::minLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinLength").build()).build();

    private static final SdkField<String> MAX_LENGTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StringAttributeConstraintsType::maxLength)).setter(setter(Builder::maxLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxLength").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_LENGTH_FIELD,
            MAX_LENGTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String minLength;

    private final String maxLength;

    private StringAttributeConstraintsType(BuilderImpl builder) {
        this.minLength = builder.minLength;
        this.maxLength = builder.maxLength;
    }

    /**
     * <p>
     * The minimum length.
     * </p>
     * 
     * @return The minimum length.
     */
    public String minLength() {
        return minLength;
    }

    /**
     * <p>
     * The maximum length.
     * </p>
     * 
     * @return The maximum length.
     */
    public String maxLength() {
        return maxLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minLength());
        hashCode = 31 * hashCode + Objects.hashCode(maxLength());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringAttributeConstraintsType)) {
            return false;
        }
        StringAttributeConstraintsType other = (StringAttributeConstraintsType) obj;
        return Objects.equals(minLength(), other.minLength()) && Objects.equals(maxLength(), other.maxLength());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StringAttributeConstraintsType").add("MinLength", minLength()).add("MaxLength", maxLength())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinLength":
            return Optional.ofNullable(clazz.cast(minLength()));
        case "MaxLength":
            return Optional.ofNullable(clazz.cast(maxLength()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StringAttributeConstraintsType, T> g) {
        return obj -> g.apply((StringAttributeConstraintsType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StringAttributeConstraintsType> {
        /**
         * <p>
         * The minimum length.
         * </p>
         * 
         * @param minLength
         *        The minimum length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minLength(String minLength);

        /**
         * <p>
         * The maximum length.
         * </p>
         * 
         * @param maxLength
         *        The maximum length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLength(String maxLength);
    }

    static final class BuilderImpl implements Builder {
        private String minLength;

        private String maxLength;

        private BuilderImpl() {
        }

        private BuilderImpl(StringAttributeConstraintsType model) {
            minLength(model.minLength);
            maxLength(model.maxLength);
        }

        public final String getMinLength() {
            return minLength;
        }

        @Override
        public final Builder minLength(String minLength) {
            this.minLength = minLength;
            return this;
        }

        public final void setMinLength(String minLength) {
            this.minLength = minLength;
        }

        public final String getMaxLength() {
            return maxLength;
        }

        @Override
        public final Builder maxLength(String maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public final void setMaxLength(String maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public StringAttributeConstraintsType build() {
            return new StringAttributeConstraintsType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
