/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MFAOptionListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MFAOptionType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserType> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UserType.getter(UserType::username)).setter(UserType.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<List<AttributeType>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UserType.getter(UserType::attributes)).setter(UserType.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> USER_CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(UserType.getter(UserType::userCreateDate)).setter(UserType.setter(Builder::userCreateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserCreateDate").build()}).build();
    private static final SdkField<Instant> USER_LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(UserType.getter(UserType::userLastModifiedDate)).setter(UserType.setter(Builder::userLastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserLastModifiedDate").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UserType.getter(UserType::enabled)).setter(UserType.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<String> USER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UserType.getter(UserType::userStatusAsString)).setter(UserType.setter(Builder::userStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserStatus").build()}).build();
    private static final SdkField<List<MFAOptionType>> MFA_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UserType.getter(UserType::mfaOptions)).setter(UserType.setter(Builder::mfaOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MFAOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MFAOptionType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD, ATTRIBUTES_FIELD, USER_CREATE_DATE_FIELD, USER_LAST_MODIFIED_DATE_FIELD, ENABLED_FIELD, USER_STATUS_FIELD, MFA_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String username;
    private final List<AttributeType> attributes;
    private final Instant userCreateDate;
    private final Instant userLastModifiedDate;
    private final Boolean enabled;
    private final String userStatus;
    private final List<MFAOptionType> mfaOptions;

    private UserType(BuilderImpl builder) {
        this.username = builder.username;
        this.attributes = builder.attributes;
        this.userCreateDate = builder.userCreateDate;
        this.userLastModifiedDate = builder.userLastModifiedDate;
        this.enabled = builder.enabled;
        this.userStatus = builder.userStatus;
        this.mfaOptions = builder.mfaOptions;
    }

    public String username() {
        return this.username;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public List<AttributeType> attributes() {
        return this.attributes;
    }

    public Instant userCreateDate() {
        return this.userCreateDate;
    }

    public Instant userLastModifiedDate() {
        return this.userLastModifiedDate;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public UserStatusType userStatus() {
        return UserStatusType.fromValue(this.userStatus);
    }

    public String userStatusAsString() {
        return this.userStatus;
    }

    public boolean hasMfaOptions() {
        return this.mfaOptions != null && !(this.mfaOptions instanceof SdkAutoConstructList);
    }

    public List<MFAOptionType> mfaOptions() {
        return this.mfaOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.userCreateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.userLastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.userStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mfaOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserType)) {
            return false;
        }
        UserType other = (UserType)obj;
        return Objects.equals(this.username(), other.username()) && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.userCreateDate(), other.userCreateDate()) && Objects.equals(this.userLastModifiedDate(), other.userLastModifiedDate()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.userStatusAsString(), other.userStatusAsString()) && Objects.equals(this.mfaOptions(), other.mfaOptions());
    }

    public String toString() {
        return ToString.builder((String)"UserType").add("Username", (Object)(this.username() == null ? null : "*** Sensitive Data Redacted ***")).add("Attributes", this.attributes()).add("UserCreateDate", (Object)this.userCreateDate()).add("UserLastModifiedDate", (Object)this.userLastModifiedDate()).add("Enabled", (Object)this.enabled()).add("UserStatus", (Object)this.userStatusAsString()).add("MFAOptions", this.mfaOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "UserCreateDate": {
                return Optional.ofNullable(clazz.cast(this.userCreateDate()));
            }
            case "UserLastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.userLastModifiedDate()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "UserStatus": {
                return Optional.ofNullable(clazz.cast(this.userStatusAsString()));
            }
            case "MFAOptions": {
                return Optional.ofNullable(clazz.cast(this.mfaOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserType, T> g) {
        return obj -> g.apply((UserType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String username;
        private List<AttributeType> attributes = DefaultSdkAutoConstructList.getInstance();
        private Instant userCreateDate;
        private Instant userLastModifiedDate;
        private Boolean enabled;
        private String userStatus;
        private List<MFAOptionType> mfaOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UserType model) {
            this.username(model.username);
            this.attributes(model.attributes);
            this.userCreateDate(model.userCreateDate);
            this.userLastModifiedDate(model.userLastModifiedDate);
            this.enabled(model.enabled);
            this.userStatus(model.userStatus);
            this.mfaOptions(model.mfaOptions);
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final Collection<AttributeType.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(AttributeType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<AttributeType> attributes) {
            this.attributes = AttributeListTypeCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(AttributeType ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<AttributeType.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (AttributeType)((AttributeType.Builder)AttributeType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<AttributeType.BuilderImpl> attributes) {
            this.attributes = AttributeListTypeCopier.copyFromBuilder(attributes);
        }

        public final Instant getUserCreateDate() {
            return this.userCreateDate;
        }

        @Override
        public final Builder userCreateDate(Instant userCreateDate) {
            this.userCreateDate = userCreateDate;
            return this;
        }

        public final void setUserCreateDate(Instant userCreateDate) {
            this.userCreateDate = userCreateDate;
        }

        public final Instant getUserLastModifiedDate() {
            return this.userLastModifiedDate;
        }

        @Override
        public final Builder userLastModifiedDate(Instant userLastModifiedDate) {
            this.userLastModifiedDate = userLastModifiedDate;
            return this;
        }

        public final void setUserLastModifiedDate(Instant userLastModifiedDate) {
            this.userLastModifiedDate = userLastModifiedDate;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getUserStatusAsString() {
            return this.userStatus;
        }

        @Override
        public final Builder userStatus(String userStatus) {
            this.userStatus = userStatus;
            return this;
        }

        @Override
        public final Builder userStatus(UserStatusType userStatus) {
            this.userStatus(userStatus == null ? null : userStatus.toString());
            return this;
        }

        public final void setUserStatus(String userStatus) {
            this.userStatus = userStatus;
        }

        public final Collection<MFAOptionType.Builder> getMfaOptions() {
            return this.mfaOptions != null ? (Collection)this.mfaOptions.stream().map(MFAOptionType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mfaOptions(Collection<MFAOptionType> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copy(mfaOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaOptions(MFAOptionType ... mfaOptions) {
            this.mfaOptions(Arrays.asList(mfaOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaOptions(Consumer<MFAOptionType.Builder> ... mfaOptions) {
            this.mfaOptions(Stream.of(mfaOptions).map(c -> (MFAOptionType)((MFAOptionType.Builder)MFAOptionType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMfaOptions(Collection<MFAOptionType.BuilderImpl> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copyFromBuilder(mfaOptions);
        }

        public UserType build() {
            return new UserType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserType> {
        public Builder username(String var1);

        public Builder attributes(Collection<AttributeType> var1);

        public Builder attributes(AttributeType ... var1);

        public Builder attributes(Consumer<AttributeType.Builder> ... var1);

        public Builder userCreateDate(Instant var1);

        public Builder userLastModifiedDate(Instant var1);

        public Builder enabled(Boolean var1);

        public Builder userStatus(String var1);

        public Builder userStatus(UserStatusType var1);

        public Builder mfaOptions(Collection<MFAOptionType> var1);

        public Builder mfaOptions(MFAOptionType ... var1);

        public Builder mfaOptions(Consumer<MFAOptionType.Builder> ... var1);
    }
}

