/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.HttpHeader;
import software.amazon.awssdk.services.cognitoidentityprovider.model.HttpHeaderListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContextDataType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContextDataType> {
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContextDataType.getter(ContextDataType::ipAddress)).setter(ContextDataType.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContextDataType.getter(ContextDataType::serverName)).setter(ContextDataType.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<String> SERVER_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContextDataType.getter(ContextDataType::serverPath)).setter(ContextDataType.setter(Builder::serverPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerPath").build()}).build();
    private static final SdkField<List<HttpHeader>> HTTP_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ContextDataType.getter(ContextDataType::httpHeaders)).setter(ContextDataType.setter(Builder::httpHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpHeaders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HttpHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENCODED_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContextDataType.getter(ContextDataType::encodedData)).setter(ContextDataType.setter(Builder::encodedData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncodedData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_FIELD, SERVER_NAME_FIELD, SERVER_PATH_FIELD, HTTP_HEADERS_FIELD, ENCODED_DATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ipAddress;
    private final String serverName;
    private final String serverPath;
    private final List<HttpHeader> httpHeaders;
    private final String encodedData;

    private ContextDataType(BuilderImpl builder) {
        this.ipAddress = builder.ipAddress;
        this.serverName = builder.serverName;
        this.serverPath = builder.serverPath;
        this.httpHeaders = builder.httpHeaders;
        this.encodedData = builder.encodedData;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public String serverName() {
        return this.serverName;
    }

    public String serverPath() {
        return this.serverPath;
    }

    public boolean hasHttpHeaders() {
        return this.httpHeaders != null && !(this.httpHeaders instanceof SdkAutoConstructList);
    }

    public List<HttpHeader> httpHeaders() {
        return this.httpHeaders;
    }

    public String encodedData() {
        return this.encodedData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(this.encodedData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContextDataType)) {
            return false;
        }
        ContextDataType other = (ContextDataType)obj;
        return Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.serverPath(), other.serverPath()) && Objects.equals(this.httpHeaders(), other.httpHeaders()) && Objects.equals(this.encodedData(), other.encodedData());
    }

    public String toString() {
        return ToString.builder((String)"ContextDataType").add("IpAddress", (Object)this.ipAddress()).add("ServerName", (Object)this.serverName()).add("ServerPath", (Object)this.serverPath()).add("HttpHeaders", this.httpHeaders()).add("EncodedData", (Object)this.encodedData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "ServerPath": {
                return Optional.ofNullable(clazz.cast(this.serverPath()));
            }
            case "HttpHeaders": {
                return Optional.ofNullable(clazz.cast(this.httpHeaders()));
            }
            case "EncodedData": {
                return Optional.ofNullable(clazz.cast(this.encodedData()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContextDataType, T> g) {
        return obj -> g.apply((ContextDataType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipAddress;
        private String serverName;
        private String serverPath;
        private List<HttpHeader> httpHeaders = DefaultSdkAutoConstructList.getInstance();
        private String encodedData;

        private BuilderImpl() {
        }

        private BuilderImpl(ContextDataType model) {
            this.ipAddress(model.ipAddress);
            this.serverName(model.serverName);
            this.serverPath(model.serverPath);
            this.httpHeaders(model.httpHeaders);
            this.encodedData(model.encodedData);
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getServerPath() {
            return this.serverPath;
        }

        @Override
        public final Builder serverPath(String serverPath) {
            this.serverPath = serverPath;
            return this;
        }

        public final void setServerPath(String serverPath) {
            this.serverPath = serverPath;
        }

        public final Collection<HttpHeader.Builder> getHttpHeaders() {
            return this.httpHeaders != null ? (Collection)this.httpHeaders.stream().map(HttpHeader::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder httpHeaders(Collection<HttpHeader> httpHeaders) {
            this.httpHeaders = HttpHeaderListCopier.copy(httpHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder httpHeaders(HttpHeader ... httpHeaders) {
            this.httpHeaders(Arrays.asList(httpHeaders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder httpHeaders(Consumer<HttpHeader.Builder> ... httpHeaders) {
            this.httpHeaders(Stream.of(httpHeaders).map(c -> (HttpHeader)((HttpHeader.Builder)HttpHeader.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHttpHeaders(Collection<HttpHeader.BuilderImpl> httpHeaders) {
            this.httpHeaders = HttpHeaderListCopier.copyFromBuilder(httpHeaders);
        }

        public final String getEncodedData() {
            return this.encodedData;
        }

        @Override
        public final Builder encodedData(String encodedData) {
            this.encodedData = encodedData;
            return this;
        }

        public final void setEncodedData(String encodedData) {
            this.encodedData = encodedData;
        }

        public ContextDataType build() {
            return new ContextDataType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContextDataType> {
        public Builder ipAddress(String var1);

        public Builder serverName(String var1);

        public Builder serverPath(String var1);

        public Builder httpHeaders(Collection<HttpHeader> var1);

        public Builder httpHeaders(HttpHeader ... var1);

        public Builder httpHeaders(Consumer<HttpHeader.Builder> ... var1);

        public Builder encodedData(String var1);
    }
}

