/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EventResponseType {
    SUCCESS("Success"),
    FAILURE("Failure"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EventResponseType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventResponseType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EventResponseType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventResponseType> knownValues() {
        return Stream.of(EventResponseType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

