/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RoleMappingType {
    TOKEN("Token"),
    RULES("Rules"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RoleMappingType> VALUE_MAP;
    private final String value;

    private RoleMappingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RoleMappingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RoleMappingType> knownValues() {
        EnumSet<RoleMappingType> knownValues = EnumSet.allOf(RoleMappingType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RoleMappingType.class, RoleMappingType::toString);
    }
}

