/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.auth.scheme.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.cognitoidentity.auth.scheme.CognitoIdentityAuthSchemeParams;
import software.amazon.awssdk.services.cognitoidentity.auth.scheme.CognitoIdentityAuthSchemeProvider;

@SdkInternalApi
public final class DefaultCognitoIdentityAuthSchemeProvider
implements CognitoIdentityAuthSchemeProvider {
    private static final DefaultCognitoIdentityAuthSchemeProvider DEFAULT = new DefaultCognitoIdentityAuthSchemeProvider();

    private DefaultCognitoIdentityAuthSchemeProvider() {
    }

    public static DefaultCognitoIdentityAuthSchemeProvider create() {
        return DEFAULT;
    }

    @Override
    public List<AuthSchemeOption> resolveAuthScheme(CognitoIdentityAuthSchemeParams params) {
        ArrayList<Object> options = new ArrayList<Object>();
        switch (params.operation()) {
            case "GetCredentialsForIdentity": 
            case "GetId": 
            case "GetOpenIdToken": 
            case "UnlinkIdentity": {
                options.add(AuthSchemeOption.builder().schemeId("smithy.api#noAuth").build());
                break;
            }
            default: {
                options.add(AuthSchemeOption.builder().schemeId("aws.auth#sigv4").putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)"cognito-identity").putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)params.region().id()).build());
            }
        }
        return Collections.unmodifiableList(options);
    }
}

