/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityClient;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityClientBuilder;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityServiceClientConfiguration;
import software.amazon.awssdk.services.cognitoidentity.DefaultCognitoIdentityBaseClientBuilder;
import software.amazon.awssdk.services.cognitoidentity.DefaultCognitoIdentityClient;
import software.amazon.awssdk.services.cognitoidentity.endpoints.CognitoIdentityEndpointProvider;

@SdkInternalApi
final class DefaultCognitoIdentityClientBuilder
extends DefaultCognitoIdentityBaseClientBuilder<CognitoIdentityClientBuilder, CognitoIdentityClient>
implements CognitoIdentityClientBuilder {
    DefaultCognitoIdentityClientBuilder() {
    }

    @Override
    public DefaultCognitoIdentityClientBuilder endpointProvider(CognitoIdentityEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CognitoIdentityClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCognitoIdentityClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CognitoIdentityServiceClientConfiguration serviceClientConfiguration = CognitoIdentityServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCognitoIdentityClient(serviceClientConfiguration, clientConfiguration);
    }
}

