/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.UnprocessedIdentityId;
import software.amazon.awssdk.services.cognitoidentity.model.UnprocessedIdentityIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteIdentitiesResponse
extends CognitoIdentityResponse
implements ToCopyableBuilder<Builder, DeleteIdentitiesResponse> {
    private static final SdkField<List<UnprocessedIdentityId>> UNPROCESSED_IDENTITY_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedIdentityIds").getter(DeleteIdentitiesResponse.getter(DeleteIdentitiesResponse::unprocessedIdentityIds)).setter(DeleteIdentitiesResponse.setter(Builder::unprocessedIdentityIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedIdentityIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnprocessedIdentityId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNPROCESSED_IDENTITY_IDS_FIELD));
    private final List<UnprocessedIdentityId> unprocessedIdentityIds;

    private DeleteIdentitiesResponse(BuilderImpl builder) {
        super(builder);
        this.unprocessedIdentityIds = builder.unprocessedIdentityIds;
    }

    public boolean hasUnprocessedIdentityIds() {
        return this.unprocessedIdentityIds != null && !(this.unprocessedIdentityIds instanceof SdkAutoConstructList);
    }

    public List<UnprocessedIdentityId> unprocessedIdentityIds() {
        return this.unprocessedIdentityIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedIdentityIds() ? this.unprocessedIdentityIds() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIdentitiesResponse)) {
            return false;
        }
        DeleteIdentitiesResponse other = (DeleteIdentitiesResponse)((Object)obj);
        return this.hasUnprocessedIdentityIds() == other.hasUnprocessedIdentityIds() && Objects.equals(this.unprocessedIdentityIds(), other.unprocessedIdentityIds());
    }

    public String toString() {
        return ToString.builder((String)"DeleteIdentitiesResponse").add("UnprocessedIdentityIds", this.hasUnprocessedIdentityIds() ? this.unprocessedIdentityIds() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UnprocessedIdentityIds": {
                return Optional.ofNullable(clazz.cast(this.unprocessedIdentityIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteIdentitiesResponse, T> g) {
        return obj -> g.apply((DeleteIdentitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityResponse.BuilderImpl
    implements Builder {
        private List<UnprocessedIdentityId> unprocessedIdentityIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIdentitiesResponse model) {
            super(model);
            this.unprocessedIdentityIds(model.unprocessedIdentityIds);
        }

        public final Collection<UnprocessedIdentityId.Builder> getUnprocessedIdentityIds() {
            if (this.unprocessedIdentityIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.unprocessedIdentityIds != null ? (Collection)this.unprocessedIdentityIds.stream().map(UnprocessedIdentityId::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedIdentityIds(Collection<UnprocessedIdentityId> unprocessedIdentityIds) {
            this.unprocessedIdentityIds = UnprocessedIdentityIdListCopier.copy(unprocessedIdentityIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedIdentityIds(UnprocessedIdentityId ... unprocessedIdentityIds) {
            this.unprocessedIdentityIds(Arrays.asList(unprocessedIdentityIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedIdentityIds(Consumer<UnprocessedIdentityId.Builder> ... unprocessedIdentityIds) {
            this.unprocessedIdentityIds(Stream.of(unprocessedIdentityIds).map(c -> (UnprocessedIdentityId)((UnprocessedIdentityId.Builder)UnprocessedIdentityId.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedIdentityIds(Collection<UnprocessedIdentityId.BuilderImpl> unprocessedIdentityIds) {
            this.unprocessedIdentityIds = UnprocessedIdentityIdListCopier.copyFromBuilder(unprocessedIdentityIds);
        }

        @Override
        public DeleteIdentitiesResponse build() {
            return new DeleteIdentitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteIdentitiesResponse> {
        public Builder unprocessedIdentityIds(Collection<UnprocessedIdentityId> var1);

        public Builder unprocessedIdentityIds(UnprocessedIdentityId ... var1);

        public Builder unprocessedIdentityIds(Consumer<UnprocessedIdentityId.Builder> ... var1);
    }
}

