/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a successful ListIdentityPools action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIdentityPoolsResponse extends CognitoIdentityResponse implements
        ToCopyableBuilder<ListIdentityPoolsResponse.Builder, ListIdentityPoolsResponse> {
    private static final SdkField<List<IdentityPoolShortDescription>> IDENTITY_POOLS_FIELD = SdkField
            .<List<IdentityPoolShortDescription>> builder(MarshallingType.LIST)
            .getter(getter(ListIdentityPoolsResponse::identityPools))
            .setter(setter(Builder::identityPools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPools").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdentityPoolShortDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdentityPoolShortDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListIdentityPoolsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOLS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<IdentityPoolShortDescription> identityPools;

    private final String nextToken;

    private ListIdentityPoolsResponse(BuilderImpl builder) {
        super(builder);
        this.identityPools = builder.identityPools;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the IdentityPools property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasIdentityPools() {
        return identityPools != null && !(identityPools instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identity pools returned by the ListIdentityPools action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIdentityPools()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The identity pools returned by the ListIdentityPools action.
     */
    public List<IdentityPoolShortDescription> identityPools() {
        return identityPools;
    }

    /**
     * <p>
     * A pagination token.
     * </p>
     * 
     * @return A pagination token.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityPools());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityPoolsResponse)) {
            return false;
        }
        ListIdentityPoolsResponse other = (ListIdentityPoolsResponse) obj;
        return Objects.equals(identityPools(), other.identityPools()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListIdentityPoolsResponse").add("IdentityPools", identityPools()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPools":
            return Optional.ofNullable(clazz.cast(identityPools()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIdentityPoolsResponse, T> g) {
        return obj -> g.apply((ListIdentityPoolsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListIdentityPoolsResponse> {
        /**
         * <p>
         * The identity pools returned by the ListIdentityPools action.
         * </p>
         * 
         * @param identityPools
         *        The identity pools returned by the ListIdentityPools action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPools(Collection<IdentityPoolShortDescription> identityPools);

        /**
         * <p>
         * The identity pools returned by the ListIdentityPools action.
         * </p>
         * 
         * @param identityPools
         *        The identity pools returned by the ListIdentityPools action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPools(IdentityPoolShortDescription... identityPools);

        /**
         * <p>
         * The identity pools returned by the ListIdentityPools action.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IdentityPoolShortDescription>.Builder}
         * avoiding the need to create one manually via {@link List<IdentityPoolShortDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IdentityPoolShortDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #identityPools(List<IdentityPoolShortDescription>)}.
         * 
         * @param identityPools
         *        a consumer that will call methods on {@link List<IdentityPoolShortDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityPools(List<IdentityPoolShortDescription>)
         */
        Builder identityPools(Consumer<IdentityPoolShortDescription.Builder>... identityPools);

        /**
         * <p>
         * A pagination token.
         * </p>
         * 
         * @param nextToken
         *        A pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CognitoIdentityResponse.BuilderImpl implements Builder {
        private List<IdentityPoolShortDescription> identityPools = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityPoolsResponse model) {
            super(model);
            identityPools(model.identityPools);
            nextToken(model.nextToken);
        }

        public final Collection<IdentityPoolShortDescription.Builder> getIdentityPools() {
            return identityPools != null ? identityPools.stream().map(IdentityPoolShortDescription::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder identityPools(Collection<IdentityPoolShortDescription> identityPools) {
            this.identityPools = IdentityPoolsListCopier.copy(identityPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityPools(IdentityPoolShortDescription... identityPools) {
            identityPools(Arrays.asList(identityPools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityPools(Consumer<IdentityPoolShortDescription.Builder>... identityPools) {
            identityPools(Stream.of(identityPools).map(c -> IdentityPoolShortDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIdentityPools(Collection<IdentityPoolShortDescription.BuilderImpl> identityPools) {
            this.identityPools = IdentityPoolsListCopier.copyFromBuilder(identityPools);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIdentityPoolsResponse build() {
            return new ListIdentityPoolsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
