/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.model.MappingRuleMatchType;
import software.amazon.awssdk.services.cognitoidentity.transform.MappingRuleMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MappingRule
implements StructuredPojo,
ToCopyableBuilder<Builder, MappingRule> {
    private final String claim;
    private final String matchType;
    private final String value;
    private final String roleARN;

    private MappingRule(BuilderImpl builder) {
        this.claim = builder.claim;
        this.matchType = builder.matchType;
        this.value = builder.value;
        this.roleARN = builder.roleARN;
    }

    public String claim() {
        return this.claim;
    }

    public MappingRuleMatchType matchType() {
        return MappingRuleMatchType.fromValue(this.matchType);
    }

    public String matchTypeString() {
        return this.matchType;
    }

    public String value() {
        return this.value;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.claim());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MappingRule)) {
            return false;
        }
        MappingRule other = (MappingRule)obj;
        return Objects.equals(this.claim(), other.claim()) && Objects.equals(this.matchTypeString(), other.matchTypeString()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.roleARN(), other.roleARN());
    }

    public String toString() {
        return ToString.builder((String)"MappingRule").add("Claim", (Object)this.claim()).add("MatchType", (Object)this.matchTypeString()).add("Value", (Object)this.value()).add("RoleARN", (Object)this.roleARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Claim": {
                return Optional.of(clazz.cast(this.claim()));
            }
            case "MatchType": {
                return Optional.of(clazz.cast(this.matchTypeString()));
            }
            case "Value": {
                return Optional.of(clazz.cast(this.value()));
            }
            case "RoleARN": {
                return Optional.of(clazz.cast(this.roleARN()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MappingRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String claim;
        private String matchType;
        private String value;
        private String roleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(MappingRule model) {
            this.claim(model.claim);
            this.matchType(model.matchType);
            this.value(model.value);
            this.roleARN(model.roleARN);
        }

        public final String getClaim() {
            return this.claim;
        }

        @Override
        public final Builder claim(String claim) {
            this.claim = claim;
            return this;
        }

        public final void setClaim(String claim) {
            this.claim = claim;
        }

        public final String getMatchType() {
            return this.matchType;
        }

        @Override
        public final Builder matchType(String matchType) {
            this.matchType = matchType;
            return this;
        }

        @Override
        public final Builder matchType(MappingRuleMatchType matchType) {
            this.matchType(matchType.toString());
            return this;
        }

        public final void setMatchType(String matchType) {
            this.matchType = matchType;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public MappingRule build() {
            return new MappingRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MappingRule> {
        public Builder claim(String var1);

        public Builder matchType(String var1);

        public Builder matchType(MappingRuleMatchType var1);

        public Builder value(String var1);

        public Builder roleARN(String var1);
    }
}

