/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListIdentitiesRequest
extends CognitoIdentityRequest
implements ToCopyableBuilder<Builder, ListIdentitiesRequest> {
    private final String identityPoolId;
    private final Integer maxResults;
    private final String nextToken;
    private final Boolean hideDisabled;

    private ListIdentitiesRequest(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.hideDisabled = builder.hideDisabled;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Boolean hideDisabled() {
        return this.hideDisabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hideDisabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentitiesRequest)) {
            return false;
        }
        ListIdentitiesRequest other = (ListIdentitiesRequest)((Object)obj);
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.hideDisabled(), other.hideDisabled());
    }

    public String toString() {
        return ToString.builder((String)"ListIdentitiesRequest").add("IdentityPoolId", (Object)this.identityPoolId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("HideDisabled", (Object)this.hideDisabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.of(clazz.cast(this.identityPoolId()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "HideDisabled": {
                return Optional.of(clazz.cast(this.hideDisabled()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityRequest.BuilderImpl
    implements Builder {
        private String identityPoolId;
        private Integer maxResults;
        private String nextToken;
        private Boolean hideDisabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentitiesRequest model) {
            this.identityPoolId(model.identityPoolId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.hideDisabled(model.hideDisabled);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Boolean getHideDisabled() {
            return this.hideDisabled;
        }

        @Override
        public final Builder hideDisabled(Boolean hideDisabled) {
            this.hideDisabled = hideDisabled;
            return this;
        }

        public final void setHideDisabled(Boolean hideDisabled) {
            this.hideDisabled = hideDisabled;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListIdentitiesRequest build() {
            return new ListIdentitiesRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityRequest.Builder,
    CopyableBuilder<Builder, ListIdentitiesRequest> {
        public Builder identityPoolId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder hideDisabled(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

