/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.transform.IdentityPoolShortDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IdentityPoolShortDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, IdentityPoolShortDescription> {
    private final String identityPoolId;
    private final String identityPoolName;

    private IdentityPoolShortDescription(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.identityPoolName = builder.identityPoolName;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public String identityPoolName() {
        return this.identityPoolName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityPoolShortDescription)) {
            return false;
        }
        IdentityPoolShortDescription other = (IdentityPoolShortDescription)obj;
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.identityPoolName(), other.identityPoolName());
    }

    public String toString() {
        return ToString.builder((String)"IdentityPoolShortDescription").add("IdentityPoolId", (Object)this.identityPoolId()).add("IdentityPoolName", (Object)this.identityPoolName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.of(clazz.cast(this.identityPoolId()));
            }
            case "IdentityPoolName": {
                return Optional.of(clazz.cast(this.identityPoolName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IdentityPoolShortDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String identityPoolId;
        private String identityPoolName;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityPoolShortDescription model) {
            this.identityPoolId(model.identityPoolId);
            this.identityPoolName(model.identityPoolName);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getIdentityPoolName() {
            return this.identityPoolName;
        }

        @Override
        public final Builder identityPoolName(String identityPoolName) {
            this.identityPoolName = identityPoolName;
            return this;
        }

        public final void setIdentityPoolName(String identityPoolName) {
            this.identityPoolName = identityPoolName;
        }

        public IdentityPoolShortDescription build() {
            return new IdentityPoolShortDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IdentityPoolShortDescription> {
        public Builder identityPoolId(String var1);

        public Builder identityPoolName(String var1);
    }
}

