/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.Credentials;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetCredentialsForIdentityResponse
extends CognitoIdentityResponse
implements ToCopyableBuilder<Builder, GetCredentialsForIdentityResponse> {
    private final String identityId;
    private final Credentials credentials;

    private GetCredentialsForIdentityResponse(BuilderImpl builder) {
        super(builder);
        this.identityId = builder.identityId;
        this.credentials = builder.credentials;
    }

    public String identityId() {
        return this.identityId;
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCredentialsForIdentityResponse)) {
            return false;
        }
        GetCredentialsForIdentityResponse other = (GetCredentialsForIdentityResponse)((Object)obj);
        return Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.credentials(), other.credentials());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identityId() != null) {
            sb.append("IdentityId: ").append(this.identityId()).append(",");
        }
        if (this.credentials() != null) {
            sb.append("Credentials: ").append(this.credentials()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityId": {
                return Optional.of(clazz.cast(this.identityId()));
            }
            case "Credentials": {
                return Optional.of(clazz.cast(this.credentials()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityResponse.BuilderImpl
    implements Builder {
        private String identityId;
        private Credentials credentials;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCredentialsForIdentityResponse model) {
            this.identityId(model.identityId);
            this.credentials(model.credentials);
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final Credentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public GetCredentialsForIdentityResponse build() {
            return new GetCredentialsForIdentityResponse(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityResponse.Builder,
    CopyableBuilder<Builder, GetCredentialsForIdentityResponse> {
        public Builder identityId(String var1);

        public Builder credentials(Credentials var1);

        default public Builder credentials(Consumer<Credentials.Builder> credentials) {
            return this.credentials((Credentials)((Credentials.Builder)Credentials.builder().apply(credentials)).build());
        }
    }
}

